/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.functional.utils;

import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.functional.utils.FunctionalMvcProcessingContext;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;

public class SpringMvcFunctionalSearchers {
    public static final String NEST_METHOD_NAME = "nest";
    public static final String AND_NEST_METHOD_NAME = "andNest";
    public static final String ROUTE_METHOD_NAME = "route";
    public static final String AND_ROUTE_METHOD_NAME = "andRoute";
    private static final String METHOD_METHOD_NAME = "method";
    private static final String PATH_METHOD_NAME = "path";
    public static final String ADD_METHOD_NAME = "add";

    @NotNull
    public static Set<UCallExpression> findMethodsCalls(PsiMethod[] psiMethods, @Nullable SearchScope scope) {
        HashSet<UCallExpression> calls = new HashSet<UCallExpression>();
        for (PsiMethod method : psiMethods) {
            calls.addAll(SpringMvcFunctionalSearchers.findMethodCalls(method, scope));
        }
        HashSet<UCallExpression> hashSet = calls;
        if (hashSet == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    public static Set<UCallExpression> findMethodCalls(@Nullable PsiMethod psiMethod, @Nullable SearchScope scope) {
        if (psiMethod == null || scope == null) {
            Set<UCallExpression> set = Collections.emptySet();
            if (set == null) {
                SpringMvcFunctionalSearchers.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<UCallExpression> set = MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)scope, (boolean)false).findAll().stream().map(reference -> (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)reference.getElement(), UCallExpression.class)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Collection<? extends UCallExpression> findMethodCallsWithSearchService(@Nullable PsiMethod psiMethod, @Nullable SearchScope scope) {
        if (psiMethod == null || scope == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                SpringMvcFunctionalSearchers.$$$reportNull$$$0(3);
            }
            return set;
        }
        Collection collection = SearchService.getInstance().searchWord(psiMethod.getProject(), psiMethod.getName()).inContexts(SearchContext.IN_CODE, new SearchContext[0]).inScope(scope).buildQuery((scope1, start, offsetInStart) -> {
            if (offsetInStart != 0) {
                return Collections.emptySet();
            }
            UCallExpression uCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)start, UCallExpression.class);
            return uCallExpression != null && psiMethod.equals(uCallExpression.resolve()) ? Collections.singleton(uCallExpression) : Collections.emptySet();
        }).findAll();
        if (collection == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends UCallExpression> findMethodCallsByPattern(@NotNull Project project, @NotNull String methodName, @NotNull SearchScope scope, UCallExpressionPattern ... patterns) {
        if (project == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(5);
        }
        if (methodName == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(7);
        }
        Collection collection = SearchService.getInstance().searchWord(project, methodName).inContexts(SearchContext.IN_CODE, new SearchContext[0]).inScope(scope).buildQuery((scopeElement, start, offsetInStart) -> {
            if (offsetInStart != 0) {
                return Collections.emptySet();
            }
            UCallExpression uCallExpression = SpringMvcFunctionalSearchers.getUCallExpression(start);
            if (uCallExpression == null) {
                return Collections.emptySet();
            }
            for (UCallExpressionPattern callExpressionPattern : patterns) {
                if (!callExpressionPattern.accepts((Object)uCallExpression)) continue;
                return Collections.singleton(uCallExpression);
            }
            return Collections.emptySet();
        }).findAll();
        if (collection == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nullable
    private static UCallExpression getUCallExpression(@NotNull PsiElement leafNode) {
        UElement uastParent;
        UElement element;
        if (leafNode == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(9);
        }
        if ((element = UastContextKt.toUElement((PsiElement)leafNode)) instanceof UCallExpression) {
            return (UCallExpression)element;
        }
        if (element instanceof UIdentifier && (uastParent = element.getUastParent()) instanceof UCallExpression) {
            return (UCallExpression)uastParent;
        }
        return null;
    }

    @Nullable
    public static UExpression findPathExpression(@NotNull UExpression expression, @NotNull Module module, boolean isReactive) {
        UCallExpression pathCallExpression;
        PsiMethod pathMethod;
        if (expression == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(10);
        }
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(11);
        }
        PsiMethod psiMethod = pathMethod = isReactive ? SpringMvcFunctionalSearchers.findReactiveRequestPredicatesPathMethod(module) : SpringMvcFunctionalSearchers.findRequestPredicatesPathMethod(module);
        if (pathMethod == null) {
            return null;
        }
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        PsiReference psiReference = (PsiReference)MethodReferencesSearch.search((PsiMethod)pathMethod, (SearchScope)new LocalSearchScope(sourcePsi), (boolean)true).findFirst();
        if (psiReference != null && (pathCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)psiReference.getElement(), UCallExpression.class)) != null) {
            return pathCallExpression.getArgumentForParameter(0);
        }
        return null;
    }

    public static PsiClass findRequestPredicatesClass(@Nullable Module module, boolean isReactive) {
        if (module == null) {
            return null;
        }
        return isReactive ? SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RequestPredicates") : SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RequestPredicates");
    }

    public static PsiClass findRequestPredicatesClass(@Nullable Module module, @NotNull String requestPredicatesClass) {
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(12);
        }
        return module == null ? null : SpringCommonUtils.findLibraryClass((Module)module, (String)requestPredicatesClass);
    }

    public static PsiClass findRouterFunctionsBuilderClass(@Nullable Module module, boolean isReactive) {
        if (module == null) {
            return null;
        }
        return isReactive ? SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctions.Builder") : SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RouterFunctions.Builder");
    }

    @Nullable
    public static PsiMethod findMethod(@NotNull String name, @Nullable PsiClass psiClass) {
        if (name == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(13);
        }
        if (psiClass == null) {
            return null;
        }
        for (PsiMethod psiMethod : psiClass.findMethodsByName(name, true)) {
            if (psiMethod == null) continue;
            return psiMethod;
        }
        return null;
    }

    public static PsiMethod @NotNull [] findMethods(@NotNull String name, @Nullable PsiClass psiClass) {
        if (name == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(14);
        }
        if (psiClass == null) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                SpringMvcFunctionalSearchers.$$$reportNull$$$0(15);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = psiClass.findMethodsByName(name, false);
        if (psiMethodArray == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(16);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findReactiveRouterFunctionsNestMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(17);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(NEST_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctions")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    public static PsiMethod findRouterFunctionsNestMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(18);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(NEST_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RouterFunctions")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    public static PsiMethod[] findReactiveRouterFunctionsBuilderNestMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(19);
        }
        return (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethods(NEST_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctions.Builder")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    public static PsiMethod[] findRouterFunctionsBuilderNestMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(20);
        }
        return (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethods(NEST_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RouterFunctions.Builder")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    public static PsiMethod findReactiveRouterFunctionsRouteMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(21);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(ROUTE_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctions")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    public static PsiMethod findRouterFunctionsRouteMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(22);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(ROUTE_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RouterFunctions")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    public static PsiMethod findReactiveRouterPredicateNestMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(23);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(AND_NEST_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunction")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    public static PsiMethod findRouterPredicateNestMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(24);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(AND_NEST_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RouterFunction")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    public static PsiMethod[] findRouterFunctionDslNestMethods(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(25);
        }
        return (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethods(NEST_METHOD_NAME, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctionDsl")), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    public static PsiMethod findReactiveRequestPredicatesMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(26);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(METHOD_METHOD_NAME, SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, true)), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    public static PsiMethod findRequestPredicatesMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(27);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(METHOD_METHOD_NAME, SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, false)), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    private static PsiMethod findRequestPredicatesPathMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(28);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(PATH_METHOD_NAME, SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, false)), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @Nullable
    private static PsiMethod findReactiveRequestPredicatesPathMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(29);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringMvcFunctionalSearchers.findMethod(PATH_METHOD_NAME, SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, true)), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
    }

    @NotNull
    public static Collection<PsiElement> getExtendedDefinitionScope(@NotNull PsiElement definitionScope) {
        UMethod uMethod;
        if (definitionScope == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(30);
        }
        if ((uMethod = (UMethod)UastContextKt.toUElementOfExpectedTypes((PsiElement)definitionScope, (Class[])new Class[]{UMethod.class})) != null) {
            HashSet<PsiElement> scopes = new HashSet<PsiElement>();
            UExpression uBody = uMethod.getUastBody();
            if (!(uBody instanceof UBlockExpression)) {
                Set<PsiElement> set = Collections.emptySet();
                if (set == null) {
                    SpringMvcFunctionalSearchers.$$$reportNull$$$0(31);
                }
                return set;
            }
            List expressions = ((UBlockExpression)uBody).getExpressions().stream().filter(UReturnExpression.class::isInstance).map(UReturnExpression.class::cast).collect(Collectors.toList());
            for (UReturnExpression uReturnExpression : expressions) {
                UExpression returnValue = uReturnExpression.getReturnExpression();
                if (returnValue == null) continue;
                if (returnValue instanceof UReferenceExpression) {
                    UExpression uastInitializer;
                    UReferenceExpression referenceExpression = (UReferenceExpression)returnValue;
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)referenceExpression);
                    if (uElement instanceof UMethod) {
                        ContainerUtil.addIfNotNull(scopes, (Object)uElement.getSourcePsi());
                        continue;
                    }
                    UField uField = (UField)ObjectUtils.tryCast((Object)uElement, UField.class);
                    if (uField == null || !uField.isFinal() || (uastInitializer = uField.getUastInitializer()) == null) continue;
                    ContainerUtil.addIfNotNull(scopes, (Object)uastInitializer.getSourcePsi());
                    continue;
                }
                if (!(returnValue instanceof UCallExpression)) continue;
                ContainerUtil.addIfNotNull(scopes, (Object)((UCallExpression)returnValue).resolve());
            }
            HashSet<PsiElement> hashSet = scopes;
            if (hashSet == null) {
                SpringMvcFunctionalSearchers.$$$reportNull$$$0(32);
            }
            return hashSet;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    static Set<UCallExpression> findRouterFunctionsNestExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(34);
        }
        HashSet<UCallExpression> nestCalls = new HashSet<UCallExpression>();
        if (context.reactive) {
            nestCalls.addAll(SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findReactiveRouterFunctionsNestMethod(context.module), context.searchScope));
            nestCalls.addAll(SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findReactiveRouterPredicateNestMethod(context.module), context.searchScope));
        } else {
            nestCalls.addAll(SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findRouterFunctionsNestMethod(context.module), context.searchScope));
            nestCalls.addAll(SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findRouterPredicateNestMethod(context.module), context.searchScope));
        }
        HashSet<UCallExpression> hashSet = nestCalls;
        if (hashSet == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @NotNull
    static Set<UCallExpression> findRouterFunctionsBuilderNestExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(36);
        }
        return context.reactive ? SpringMvcFunctionalSearchers.findMethodsCalls(SpringMvcFunctionalSearchers.findReactiveRouterFunctionsBuilderNestMethod(context.module), context.searchScope) : SpringMvcFunctionalSearchers.findMethodsCalls(SpringMvcFunctionalSearchers.findRouterFunctionsBuilderNestMethod(context.module), context.searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/functional/utils/SpringMvcFunctionalSearchers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPredicatesClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionScope";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsCalls";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodCalls";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodCallsWithSearchService";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/functional/utils/SpringMvcFunctionalSearchers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodCallsByPattern";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethods";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedDefinitionScope";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findRouterFunctionsNestExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMethodCallsByPattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUCallExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPathExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRequestPredicatesClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findMethods";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRouterFunctionsNestMethod";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsNestMethod";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRouterFunctionsBuilderNestMethod";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsBuilderNestMethod";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRouterFunctionsRouteMethod";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsRouteMethod";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRouterPredicateNestMethod";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findRouterPredicateNestMethod";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionDslNestMethods";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRequestPredicatesMethod";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findRequestPredicatesMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findRequestPredicatesPathMethod";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRequestPredicatesPathMethod";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedDefinitionScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsNestExpressions";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsBuilderNestExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

