/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.ide.util.PackageUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinDestinationFolderComboBox;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;

public class CreateKotlinClassDialog
extends DialogWrapper {
    private final JLabel myInformationLabel;
    private final JLabel myPackageLabel;
    private final ReferenceEditorComboWithBrowseButton myPackageComponent;
    private final JTextField myTfClassName;
    private final Project myProject;
    private PsiDirectory myTargetDirectory;
    private final String myClassName;
    private final boolean myClassNameEditable;
    private final Module myModule;
    private final KotlinDestinationFolderComboBox myDestinationCB;
    @NonNls
    private static final String RECENTS_KEY = "CreateKotlinClassDialog.RecentsKey";

    public CreateKotlinClassDialog(@NotNull Project project2, @NotNull @NlsContexts.DialogTitle String title, @NotNull String targetClassName, @NotNull String targetPackageName, @NotNull ClassKind kind, boolean classNameEditable, @Nullable Module defaultModule) {
        if (project2 == null) {
            CreateKotlinClassDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            CreateKotlinClassDialog.$$$reportNull$$$0(1);
        }
        if (targetClassName == null) {
            CreateKotlinClassDialog.$$$reportNull$$$0(2);
        }
        if (targetPackageName == null) {
            CreateKotlinClassDialog.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            CreateKotlinClassDialog.$$$reportNull$$$0(4);
        }
        super(project2, true);
        this.myInformationLabel = new JLabel("#");
        this.myPackageLabel = new JLabel(JavaBundle.message((String)"dialog.create.class.destination.package.label", (Object[])new Object[0]));
        this.myTfClassName = new MyTextField();
        this.myDestinationCB = new KotlinDestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return CreateKotlinClassDialog.this.myPackageComponent.getText().trim();
            }

            @Override
            protected boolean reportBaseInTestSelectionInSource() {
                return CreateKotlinClassDialog.this.reportBaseInTestSelectionInSource();
            }

            @Override
            protected boolean reportBaseInSourceSelectionInTest() {
                return CreateKotlinClassDialog.this.reportBaseInSourceSelectionInTest();
            }
        };
        this.myClassNameEditable = classNameEditable;
        this.myModule = defaultModule;
        this.myClassName = targetClassName;
        this.myProject = project2;
        this.myPackageComponent = new PackageNameReferenceEditorCombo(targetPackageName, this.myProject, RECENTS_KEY, JavaBundle.message((String)"dialog.create.class.package.chooser.title", (Object[])new Object[0]));
        this.myPackageComponent.setTextFieldPreferredWidth(40);
        this.init();
        if (!this.myClassNameEditable) {
            this.setTitle(JavaBundle.message((String)"dialog.create.class.name", (Object[])new Object[]{StringUtil.capitalize((String)kind.getDescription()), targetClassName}));
        } else {
            this.myInformationLabel.setText(JavaBundle.message((String)"dialog.create.class.label", (Object[])new Object[]{kind.getDescription()}));
            this.setTitle(title);
        }
        this.myTfClassName.setText(this.myClassName);
        this.myDestinationCB.setData(this.myProject, this.getBaseDir(targetPackageName), new Pass<String>(){

            public void pass(String s) {
                CreateKotlinClassDialog.this.setErrorText(s, (JComponent)((Object)CreateKotlinClassDialog.this.myDestinationCB));
            }
        }, (EditorComboBox)this.myPackageComponent.getChildComponent());
    }

    protected boolean reportBaseInTestSelectionInSource() {
        return false;
    }

    protected boolean reportBaseInSourceSelectionInTest() {
        return false;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            CreateKotlinClassDialog.$$$reportNull$$$0(5);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameEditable ? this.myTfClassName : this.myPackageComponent.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)8);
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        if (this.myClassNameEditable) {
            gbConstraints.weightx = 0.0;
            gbConstraints.gridwidth = 1;
            panel.add((Component)this.myInformationLabel, gbConstraints);
            gbConstraints.insets = JBUI.insets((int)4, (int)8);
            gbConstraints.gridx = 1;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridwidth = 1;
            gbConstraints.fill = 2;
            gbConstraints.anchor = 17;
            panel.add((Component)this.myTfClassName, gbConstraints);
            this.myTfClassName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    CreateKotlinClassDialog.this.getOKAction().setEnabled(PsiNameHelper.getInstance((Project)CreateKotlinClassDialog.this.myProject).isIdentifier(CreateKotlinClassDialog.this.myTfClassName.getText()));
                }
            });
            this.getOKAction().setEnabled(StringUtil.isNotEmpty((String)this.myClassName));
        }
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        panel.add((Component)this.myPackageLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                CreateKotlinClassDialog.this.myPackageComponent.getButton().doClick();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), this.myPackageComponent.getChildComponent());
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myPackageComponent, "Center");
        panel.add((Component)_panel, gbConstraints);
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 2;
        gbConstraints.insets.top = 12;
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        JBLabel label2 = new JBLabel(RefactoringBundle.message((String)"target.destination.folder"));
        panel.add((Component)label2, gbConstraints);
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets.top = 4;
        panel.add((Component)((Object)this.myDestinationCB), gbConstraints);
        boolean isMultipleSourceRoots = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(this.myProject).size() > 1;
        this.myDestinationCB.setVisible(isMultipleSourceRoots);
        label2.setVisible(isMultipleSourceRoots);
        label2.setLabelFor((Component)((Object)this.myDestinationCB));
        return panel;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    private String getPackageName() {
        String name2 = this.myPackageComponent.getText();
        return name2 != null ? name2.trim() : "";
    }

    protected void doOKAction() {
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, this.myPackageComponent.getText());
        String packageName = this.getPackageName();
        String[] errorString = new String[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName);
                MoveDestination destination = this.myDestinationCB.selectDirectory(targetPackage, false);
                if (destination == null) {
                    return;
                }
                this.myTargetDirectory = (PsiDirectory)WriteAction.compute(() -> {
                    PsiDirectory baseDir = this.getBaseDir(packageName);
                    if (baseDir == null && destination instanceof MultipleRootsMoveDestination) {
                        errorString[0] = KotlinBundle.message("destination.not.found.for.package.0", packageName);
                        return null;
                    }
                    return destination.getTargetDirectory(baseDir);
                });
                if (this.myTargetDirectory == null) {
                    return;
                }
                errorString[0] = RefactoringMessageUtil.checkCanCreateClass((PsiDirectory)this.myTargetDirectory, (String)this.getClassName());
            }
            catch (IncorrectOperationException e) {
                errorString[0] = e.getMessage();
            }
        }, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), null);
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)errorString[0], (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
            return;
        }
        super.doOKAction();
    }

    @Nullable
    protected PsiDirectory getBaseDir(String packageName) {
        return this.myModule == null ? null : PackageUtil.findPossiblePackageDirectoryInModule((Module)this.myModule, (String)packageName);
    }

    @NotNull
    public String getClassName() {
        if (this.myClassNameEditable) {
            String string = this.myTfClassName.getText();
            if (string == null) {
                CreateKotlinClassDialog.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myClassName;
        if (string == null) {
            CreateKotlinClassDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/ui/CreateKotlinClassDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/ui/CreateKotlinClassDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTextField
    extends JTextField {
        private MyTextField() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            size.width = fontMetrics.charWidth('a') * 40;
            return size;
        }
    }
}

