/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SelfReferenceConstructorParameterInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "selfReferenceParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "ConvertToNullableTypeFix", "kotlin.idea"})
public final class SelfReferenceConstructorParameterInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.primaryConstructorVisitor((Function1)((Function1)new Function1<KtPrimaryConstructor, Unit>(this, holder){
            final /* synthetic */ SelfReferenceConstructorParameterInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtPrimaryConstructor constructor2) {
                Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                KtParameterList ktParameterList = constructor2.getValueParameterList();
                if (ktParameterList == null || (ktParameterList = SelfReferenceConstructorParameterInspection.access$selfReferenceParameter(this.this$0, ktParameterList)) == null) {
                    return;
                }
                KtParameterList parameter = ktParameterList;
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                if (ktTypeReference == null || (ktTypeReference = ktTypeReference.getTextRange()) == null || (ktTypeReference = ktTypeReference.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)parameter)))) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"parameter.typeReference?\u2026er.startOffset) ?: return");
                KtTypeReference rangeInElement = ktTypeReference;
                this.$holder.registerProblem((PsiElement)parameter, (TextRange)rangeInElement, KotlinBundle.message("constructor.has.non.null.self.reference.parameter", new Object[0]), new LocalQuickFix[]{new ConvertToNullableTypeFix()});
            }
            {
                this.this$0 = selfReferenceConstructorParameterInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final KtParameter selfReferenceParameter(KtParameterList $this$selfReferenceParameter) {
        Object v5;
        KtClass containingClass;
        block9: {
            KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$selfReferenceParameter));
            if (ktClass2 == null) {
                return null;
            }
            containingClass = ktClass2;
            String string = containingClass.getName();
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containingClass.name ?: return null");
            String className = string;
            List list = $this$selfReferenceParameter.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.parameters");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtParameter it = (KtParameter)element$iv;
                boolean bl = false;
                KtParameter ktParameter = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"it");
                KtTypeReference ktTypeReference = ktParameter.getTypeReference();
                if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)className)) continue;
                v5 = element$iv;
                break block9;
            }
            v5 = null;
        }
        KtParameter ktParameter = v5;
        if (ktParameter == null) {
            return null;
        }
        KtParameter parameter = ktParameter;
        if (parameter.isVarArg()) {
            return null;
        }
        KtTypeReference ktTypeReference = parameter.getTypeReference();
        if (ktTypeReference == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"parameter.typeReference ?: return null");
        KtTypeReference typeReference = ktTypeReference;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)$this$selfReferenceParameter), (BodyResolveMode)BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (kotlinType == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context[BindingContext.T\u2026Reference] ?: return null");
        KotlinType type2 = kotlinType;
        if (KotlinTypeKt.isNullable((KotlinType)type2)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)type2.getConstructor().getDeclarationDescriptor(), (Object)((DeclarationDescriptor)context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)containingClass))) ^ true) {
            return null;
        }
        return parameter;
    }

    public static final /* synthetic */ KtParameter access$selfReferenceParameter(SelfReferenceConstructorParameterInspection $this, KtParameterList $this$access_u24selfReferenceParameter) {
        return $this.selfReferenceParameter($this$access_u24selfReferenceParameter);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SelfReferenceConstructorParameterInspection$ConvertToNullableTypeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class ConvertToNullableTypeFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("convert.to.nullable.type.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtParameter)) {
                psiElement2 = null;
            }
            KtParameter ktParameter = (KtParameter)psiElement2;
            if (ktParameter == null) {
                return;
            }
            KtParameter parameter = ktParameter;
            KtTypeReference ktTypeReference = parameter.getTypeReference();
            if (ktTypeReference == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"parameter.typeReference ?: return");
            KtTypeReference typeReference = ktTypeReference;
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)parameter), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
            if (kotlinType == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.analyze(BodyRe\u2026 typeReference] ?: return");
            KotlinType type2 = kotlinType;
            PsiModificationUtilsKt.setType$default((KtCallableDeclaration)((KtCallableDeclaration)parameter), (KotlinType)TypeUtilsKt.makeNullable((KotlinType)type2), (boolean)false, (int)2, null);
        }
    }
}

