/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantCompanionReferenceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "kotlin.idea"})
public final class RemoveRedundantCompanionReferenceFix
implements LocalQuickFix {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return KotlinBundle.message("remove.redundant.companion.reference.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtReferenceExpression)) {
            psiElement2 = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement2;
        if (ktReferenceExpression == null) {
            return;
        }
        KtReferenceExpression expression2 = ktReferenceExpression;
        Companion.removeRedundantCompanionReference(expression2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantCompanionReferenceFix$Companion;", "", "()V", "removeRedundantCompanionReference", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "kotlin.idea"})
    public static final class Companion {
        public final void removeRedundantCompanionReference(@NotNull KtReferenceExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            PsiElement psiElement2 = expression2.getParent();
            if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                psiElement2 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression parent2 = ktDotQualifiedExpression;
            KtExpression ktExpression = parent2.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selector = ktExpression;
            KtExpression receiver = parent2.getReceiverExpression();
            if (Intrinsics.areEqual((Object)expression2, (Object)receiver)) {
                parent2.replace((PsiElement)selector);
            } else {
                parent2.replace((PsiElement)receiver);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

