/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.PlatformVersion;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinFormatterUsageCollector;
import org.jetbrains.kotlin.idea.formatter.KotlinFormatterUsageCollector$Companion$WhenMappings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getVersion", "", "Companion", "KotlinFormatterKind", "kotlin.idea"})
public final class KotlinFormatterUsageCollector
extends ProjectUsagesCollector {
    private static final Lazy KOTLIN_OFFICIAL_CODE_STYLE$delegate;
    private static final Lazy KOTLIN_OBSOLETE_CODE_STYLE$delegate;
    public static final Companion Companion;

    @NotNull
    public String getGroupId() {
        return "kotlin.ide.formatter";
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (PlatformVersion.Companion.isAndroidStudio()) {
            return SetsKt.emptySet();
        }
        KotlinFormatterKind usedFormatter = Companion.getKotlinFormatterKind(project2);
        FeatureUsageData data = new FeatureUsageData().addData("kind", usedFormatter.name());
        return SetsKt.setOf((Object)MetricEventFactoryKt.newMetric((String)"settings", (FeatureUsageData)data));
    }

    static {
        Companion = new Companion(null);
        KOTLIN_OFFICIAL_CODE_STYLE$delegate = LazyKt.lazy((Function0)Companion.KOTLIN_OFFICIAL_CODE_STYLE.2.INSTANCE);
        KOTLIN_OBSOLETE_CODE_STYLE$delegate = LazyKt.lazy((Function0)Companion.KOTLIN_OBSOLETE_CODE_STYLE.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "", "(Ljava/lang/String;I)V", "IDEA_CUSTOM", "PROJECT_CUSTOM", "IDEA_OFFICIAL_KOTLIN", "PROJECT_OFFICIAL_KOTLIN", "IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM", "PROJECT_OFFICIAL_KOTLIN_WITH_CUSTOM", "IDEA_OBSOLETE_KOTLIN", "PROJECT_OBSOLETE_KOTLIN", "IDEA_OBSOLETE_KOTLIN_WITH_CUSTOM", "PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM", "kotlin.idea"})
    public static final class KotlinFormatterKind
    extends Enum<KotlinFormatterKind> {
        public static final /* enum */ KotlinFormatterKind IDEA_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_OFFICIAL_KOTLIN;
        public static final /* enum */ KotlinFormatterKind PROJECT_OFFICIAL_KOTLIN;
        public static final /* enum */ KotlinFormatterKind IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_OFFICIAL_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_OBSOLETE_KOTLIN;
        public static final /* enum */ KotlinFormatterKind PROJECT_OBSOLETE_KOTLIN;
        public static final /* enum */ KotlinFormatterKind IDEA_OBSOLETE_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM;
        private static final /* synthetic */ KotlinFormatterKind[] $VALUES;

        static {
            KotlinFormatterKind[] kotlinFormatterKindArray = new KotlinFormatterKind[10];
            KotlinFormatterKind[] kotlinFormatterKindArray2 = kotlinFormatterKindArray;
            kotlinFormatterKindArray[0] = IDEA_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[1] = PROJECT_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[2] = IDEA_OFFICIAL_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[3] = PROJECT_OFFICIAL_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[4] = IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[5] = PROJECT_OFFICIAL_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[6] = IDEA_OBSOLETE_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[7] = PROJECT_OBSOLETE_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[8] = IDEA_OBSOLETE_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[9] = PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            $VALUES = kotlinFormatterKindArray;
        }

        public static KotlinFormatterKind[] values() {
            return (KotlinFormatterKind[])$VALUES.clone();
        }

        public static KotlinFormatterKind valueOf(String string) {
            return Enum.valueOf(KotlinFormatterKind.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$Companion;", "", "()V", "KOTLIN_OBSOLETE_CODE_STYLE", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getKOTLIN_OBSOLETE_CODE_STYLE", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "KOTLIN_OBSOLETE_CODE_STYLE$delegate", "Lkotlin/Lazy;", "KOTLIN_OFFICIAL_CODE_STYLE", "getKOTLIN_OFFICIAL_CODE_STYLE", "KOTLIN_OFFICIAL_CODE_STYLE$delegate", "codeStylesIsEquals", "", "lhs", "rhs", "getKotlinFormatterKind", "Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "project", "Lcom/intellij/openapi/project/Project;", "paired", "kind", "isProject", "kotlin.idea"})
    public static final class Companion {
        private final CodeStyleSettings getKOTLIN_OFFICIAL_CODE_STYLE() {
            Lazy lazy = KOTLIN_OFFICIAL_CODE_STYLE$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (CodeStyleSettings)lazy.getValue();
        }

        private final CodeStyleSettings getKOTLIN_OBSOLETE_CODE_STYLE() {
            Lazy lazy = KOTLIN_OBSOLETE_CODE_STYLE$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (CodeStyleSettings)lazy.getValue();
        }

        private final boolean codeStylesIsEquals(CodeStyleSettings lhs, CodeStyleSettings rhs) {
            return Intrinsics.areEqual((Object)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)lhs), (Object)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)rhs)) && Intrinsics.areEqual((Object)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)lhs), (Object)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)rhs));
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final KotlinFormatterKind getKotlinFormatterKind(@NotNull Project project2) {
            KotlinFormatterKind kotlinFormatterKind;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            boolean isProject = CodeStyle.usesOwnSettings((Project)project2);
            CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"CodeStyle.getSettings(project)");
            CodeStyleSettings currentSettings = codeStyleSettings;
            String string = CodeStyleUtilsKt.kotlinCodeStyleDefaults((CodeStyleSettings)currentSettings);
            if (string != null) {
                switch (string) {
                    case "KOTLIN_OFFICIAL": {
                        if (this.codeStylesIsEquals(currentSettings, this.getKOTLIN_OFFICIAL_CODE_STYLE())) {
                            kotlinFormatterKind = this.paired(KotlinFormatterKind.IDEA_OFFICIAL_KOTLIN, isProject);
                            return kotlinFormatterKind;
                        }
                        kotlinFormatterKind = this.paired(KotlinFormatterKind.IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM, isProject);
                        return kotlinFormatterKind;
                    }
                    case "KOTLIN_OLD_DEFAULTS": {
                        if (this.codeStylesIsEquals(currentSettings, this.getKOTLIN_OBSOLETE_CODE_STYLE())) {
                            kotlinFormatterKind = this.paired(KotlinFormatterKind.IDEA_OBSOLETE_KOTLIN, isProject);
                            return kotlinFormatterKind;
                        }
                        kotlinFormatterKind = this.paired(KotlinFormatterKind.IDEA_OBSOLETE_KOTLIN_WITH_CUSTOM, isProject);
                        return kotlinFormatterKind;
                    }
                }
            }
            kotlinFormatterKind = this.paired(KotlinFormatterKind.IDEA_CUSTOM, isProject);
            return kotlinFormatterKind;
        }

        private final KotlinFormatterKind paired(KotlinFormatterKind kind, boolean isProject) {
            KotlinFormatterKind kotlinFormatterKind;
            if (!isProject) {
                return kind;
            }
            switch (KotlinFormatterUsageCollector$Companion$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_CUSTOM;
                    break;
                }
                case 2: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OFFICIAL_KOTLIN;
                    break;
                }
                case 3: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OFFICIAL_KOTLIN_WITH_CUSTOM;
                    break;
                }
                case 4: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OBSOLETE_KOTLIN;
                    break;
                }
                case 5: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM;
                    break;
                }
                default: {
                    kotlinFormatterKind = kind;
                }
            }
            return kotlinFormatterKind;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

