/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.wraptag;

import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class WrapTagDialog
extends BaseRefactoringDialog {
    private final JLabel wrappingTagNameLabel = new JLabel();
    private final JTextField wrappingTagNameField;
    private final XmlTag tag;

    WrapTagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.setModal(true);
        this.tag = tag;
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("dialog.title.wrap.tag", new Object[0]));
        this.wrappingTagNameLabel.setText(RefactorXBundle.message("label.text.name.for.wrapping.tag", new Object[0]));
        this.wrappingTagNameField = new JTextField("");
        Document document = this.wrappingTagNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.WrapTag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.wrappingTagNameField;
    }

    public String getWrappingTagName() {
        return this.wrappingTagNameField.getText().trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.text.wrap.tag.0", tagName));
        panel.add((Component)this.wrappingTagNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder(border);
        this.wrappingTagNameField.setEditable(true);
        box.add(this.wrappingTagNameField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String wrappingTagName = this.getWrappingTagName();
        return "<xsl:template match = \"" + tagName + "\">\n\t<" + wrappingTagName + ">\n\t\t<xsl:copy-of select = \".\"/>\n\t</" + wrappingTagName + ">\n</xsl:template>";
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getWrappingTagName();
        boolean tagNameEntered = XMLRefactoringUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.wrapTag";
    }
}

