/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.attributetotag.AttributeToTagIntention;
import com.sixrr.xrp.intention.Intention;
import com.sixrr.xrp.intention.PsiElementPredicate;
import com.sixrr.xrp.utils.RefactorXBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TagToAttributeIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            TagToAttributeIntention.$$$reportNull$$$0(0);
        }
        XmlTag tag = (XmlTag)element;
        XmlTag parent = tag.getParentTag();
        assert (parent != null);
        String text = TagToAttributeIntention.collectAndRemoveText(editor, tag, parent);
        if (AttributeToTagIntention.enforcePreserveWhitespaces(tag, text)) {
            text = text.trim();
        }
        String name = tag.getName();
        tag.delete();
        parent.setAttribute(name, text);
        ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(parent.getNode());
        if (end != null) {
            editor.getCaretModel().moveToOffset(end.getTextRange().getEndOffset());
        }
    }

    private static String collectAndRemoveText(Editor editor, XmlTag tag, XmlTag parent) {
        ASTNode start = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        ASTNode end = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
        if (end == null) {
            end = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parent.getNode());
        }
        if (start != null && end != null) {
            String text = editor.getDocument().getText().substring(start.getTextRange().getEndOffset(), end.getTextRange().getStartOffset());
            editor.getDocument().deleteString(start.getTextRange().getEndOffset(), end.getTextRange().getStartOffset());
            PsiDocumentManager.getInstance((Project)tag.getProject()).commitDocument(editor.getDocument());
            return text;
        }
        return "";
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = element -> {
            if (!(element instanceof XmlTag)) {
                return false;
            }
            if (((XmlTag)element).getParentTag() == null) {
                return false;
            }
            XmlAttribute type = (XmlAttribute)PsiTreeUtil.findChildOfType((PsiElement)element, XmlAttribute.class);
            if (type != null && !"xml:space".equals(type.getName())) {
                return false;
            }
            if (PsiTreeUtil.findChildOfType((PsiElement)element, XmlTag.class) != null) {
                return false;
            }
            ASTNode end = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element.getNode());
            if (end == null) {
                ASTNode current = element.getNode();
                do {
                    if ((current = current.getTreeNext()) == null || current.getElementType() != XmlElementType.XML_TAG) continue;
                    return false;
                } while (current != null);
            }
            return element.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && !element.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE);
        };
        if (psiElementPredicate == null) {
            TagToAttributeIntention.$$$reportNull$$$0(1);
        }
        return psiElementPredicate;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TagToAttributeIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RefactorXBundle.message("intention.family.name.convert.tag.to.attribute", new Object[0]);
        if (string == null) {
            TagToAttributeIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            TagToAttributeIntention.$$$reportNull$$$0(4);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/tagtoattribute/TagToAttributeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/tagtoattribute/TagToAttributeIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

