/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceTarget;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiArgsExpression
extends AopElementBase
implements PsiPointcutExpression {
    private static final AopParameterList.TypeArgumentMatcher ARGS_MATCHER = new AopParameterList.TypeArgumentMatcher(){

        @Override
        public PointcutMatchDegree matches(PsiParameter psiParameter, AopReferenceTarget target) {
            PsiType actualType = psiParameter.getType();
            if (target.accepts(actualType) == PointcutMatchDegree.TRUE || target.isAssignableFrom(actualType)) {
                return PointcutMatchDegree.TRUE;
            }
            String typeText = target.getQualifiedName();
            PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)typeText);
            if (primitiveType != null && !(actualType instanceof PsiPrimitiveType)) {
                if (primitiveType == PsiPrimitiveType.getUnboxedType((PsiType)actualType)) {
                    return PointcutMatchDegree.TRUE;
                }
            } else if (actualType instanceof PsiPrimitiveType) {
                return PointcutMatchDegree.valueOf(Objects.equals(((PsiPrimitiveType)actualType).getBoxedTypeName(), typeText) || "java.lang.Number".equals(typeText) || "java.lang.Object".equals(typeText));
            }
            return PointcutMatchDegree.FALSE;
        }
    };

    public PsiArgsExpression(@NotNull ASTNode node) {
        if (node == null) {
            PsiArgsExpression.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "PsiArgsExpression";
    }

    @Nullable
    public AopParameterList getParameterList() {
        return (AopParameterList)((Object)this.findChildByClass(AopParameterList.class));
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        if (member instanceof PsiMethod) {
            AopParameterList parameterList = this.getParameterList();
            PointcutMatchDegree pointcutMatchDegree = parameterList != null ? parameterList.matches(context, ((PsiMethod)member).getParameterList(), ARGS_MATCHER) : PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                PsiArgsExpression.$$$reportNull$$$0(1);
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
        if (pointcutMatchDegree == null) {
            PsiArgsExpression.$$$reportNull$$$0(2);
        }
        return pointcutMatchDegree;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        List<AopPsiTypePattern> list = Collections.singletonList(AopPsiTypePattern.TRUE);
        if (list == null) {
            PsiArgsExpression.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/psi/PsiArgsExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/psi/PsiArgsExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptsSubject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

