/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AndPsiTypePattern;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.PsiPrimitiveTypePattern;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AopPsiTypePatternsUtil {
    private static final List<Pair<Pair<Class, Class>, PairFunction>> ourAnders = new ArrayList<Pair<Pair<Class, Class>, PairFunction>>();

    private static <T extends AopPsiTypePattern, V extends AopPsiTypePattern> void addAnder(Class<T> first, Class<V> second, PairFunction<T, V, AopPsiTypePattern> function) {
        ourAnders.add((Pair<Pair<Class, Class>, PairFunction>)Pair.create((Object)Pair.create(first, second), function));
    }

    public static AopPsiTypePattern conjunctPatterns(AopPsiTypePattern pattern1, AopPsiTypePattern pattern2) {
        if (pattern1 == AopPsiTypePattern.FALSE || pattern2 == AopPsiTypePattern.FALSE) {
            return AopPsiTypePattern.FALSE;
        }
        if (pattern1 == AopPsiTypePattern.TRUE) {
            return pattern2;
        }
        if (pattern2 == AopPsiTypePattern.TRUE) {
            return pattern1;
        }
        for (Pair<Pair<Class, Class>, PairFunction> ander : ourAnders) {
            Pair pair = (Pair)ander.first;
            if (((Class)pair.first).isInstance(pattern1) && ((Class)pair.second).isInstance(pattern2)) {
                return (AopPsiTypePattern)((PairFunction)ander.second).fun((Object)pattern1, (Object)pattern2);
            }
            if (!((Class)pair.first).isInstance(pattern2) || !((Class)pair.second).isInstance(pattern1)) continue;
            return (AopPsiTypePattern)((PairFunction)ander.second).fun((Object)pattern2, (Object)pattern1);
        }
        throw new AssertionError();
    }

    static {
        AopPsiTypePatternsUtil.addAnder(PsiPrimitiveTypePattern.class, PsiPrimitiveTypePattern.class, (psiPrimitiveTypePattern, psiPrimitiveTypePattern1) -> psiPrimitiveTypePattern.accepts(psiPrimitiveTypePattern1.getType()) ? psiPrimitiveTypePattern : AopPsiTypePattern.FALSE);
        AopPsiTypePatternsUtil.addAnder(AopPsiTypePattern.class, AndPsiTypePattern.class, (aopPsiTypePattern, aopPsiTypePattern1) -> {
            AopPsiTypePattern[] patterns;
            HashSet<AopPsiTypePattern> result = new HashSet<AopPsiTypePattern>();
            for (AopPsiTypePattern pattern : patterns = aopPsiTypePattern1.getPatterns()) {
                AopPsiTypePattern pattern1 = AopPsiTypePatternsUtil.conjunctPatterns(pattern, aopPsiTypePattern);
                if (pattern1 instanceof AndPsiTypePattern) {
                    ContainerUtil.addAll(result, (Object[])((AndPsiTypePattern)pattern1).getPatterns());
                    continue;
                }
                result.add(pattern1);
            }
            return new AndPsiTypePattern(result.toArray(new AopPsiTypePattern[0]));
        });
        AopPsiTypePatternsUtil.addAnder(AopPsiTypePattern.class, AopPsiTypePattern.class, (aopPsiTypePattern, aopPsiTypePattern1) -> new AndPsiTypePattern((AopPsiTypePattern)aopPsiTypePattern, (AopPsiTypePattern)aopPsiTypePattern1));
    }
}

