/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPatternContainer;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopPsiTypePatternsUtil;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AopBinaryExpression
extends AopElementBase
implements PsiPointcutExpression,
AopTypeExpression {
    public AopBinaryExpression(@NotNull ASTNode node) {
        if (node == null) {
            AopBinaryExpression.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    public final Pair<AopPatternContainer, AopPatternContainer> getOperands() {
        AopPatternContainer[] containers = (AopPatternContainer[])this.findChildrenByClass(AopPatternContainer.class);
        if (containers.length != 2) {
            return null;
        }
        return Pair.create((Object)containers[0], (Object)containers[1]);
    }

    @NotNull
    public AopOperation getOperation() {
        AopOperation aopOperation = this.findChildByType(AopElementTypes.AOP_OR) != null ? AopOperation.OR : AopOperation.AND;
        if (aopOperation == null) {
            AopBinaryExpression.$$$reportNull$$$0(1);
        }
        return aopOperation;
    }

    @Nullable
    public PsiElement getOpToken() {
        PsiElement or = this.findChildByType(AopElementTypes.AOP_OR);
        return or != null ? or : this.findChildByType(AopElementTypes.AOP_AND);
    }

    public String toString() {
        return "AopBinaryExpression";
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        Pair<AopPatternContainer, AopPatternContainer> pair = this.getOperands();
        if (pair == null) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                AopBinaryExpression.$$$reportNull$$$0(2);
            }
            return pointcutMatchDegree;
        }
        if (!(pair.first instanceof PsiPointcutExpression) || !(pair.second instanceof PsiPointcutExpression)) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                AopBinaryExpression.$$$reportNull$$$0(3);
            }
            return pointcutMatchDegree;
        }
        PsiPointcutExpression leftOperand = (PsiPointcutExpression)pair.first;
        PsiPointcutExpression rightOperand = (PsiPointcutExpression)pair.second;
        boolean and = this.getOperation() == AopOperation.AND;
        PointcutMatchDegree leftResult = leftOperand.acceptsSubject(context, member);
        if (and && leftResult == PointcutMatchDegree.FALSE) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                AopBinaryExpression.$$$reportNull$$$0(4);
            }
            return pointcutMatchDegree;
        }
        if (!and && leftResult == PointcutMatchDegree.TRUE) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
            if (pointcutMatchDegree == null) {
                AopBinaryExpression.$$$reportNull$$$0(5);
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree rightResult = rightOperand.acceptsSubject(context, member);
        PointcutMatchDegree pointcutMatchDegree = and ? PointcutMatchDegree.and(leftResult, rightResult) : PointcutMatchDegree.or(leftResult, rightResult);
        if (pointcutMatchDegree == null) {
            AopBinaryExpression.$$$reportNull$$$0(6);
        }
        return pointcutMatchDegree;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        Pair<AopPatternContainer, AopPatternContainer> pair = this.getOperands();
        if (pair == null) {
            List<AopPsiTypePattern> list = Collections.emptyList();
            if (list == null) {
                AopBinaryExpression.$$$reportNull$$$0(7);
            }
            return list;
        }
        Collection<AopPsiTypePattern> leftPatterns = ((AopPatternContainer)pair.first).getPatterns();
        Collection<AopPsiTypePattern> rightPatterns = ((AopPatternContainer)pair.second).getPatterns();
        HashSet<AopPsiTypePattern> result = new HashSet<AopPsiTypePattern>();
        if (this.getOperation() == AopOperation.AND) {
            AopBinaryExpression.conjunctPatterns(leftPatterns, rightPatterns, result);
        } else {
            result.addAll(leftPatterns);
            result.addAll(rightPatterns);
        }
        HashSet<AopPsiTypePattern> hashSet = result;
        if (hashSet == null) {
            AopBinaryExpression.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    public String getTypePattern() {
        AopTypeExpression[] expressions = (AopTypeExpression[])this.findChildrenByClass(AopTypeExpression.class);
        if (expressions.length != 2) {
            return null;
        }
        String pattern0 = expressions[0].getTypePattern();
        String pattern1 = expressions[1].getTypePattern();
        if (pattern0 == null || pattern1 == null) {
            return null;
        }
        Pair<AopPatternContainer, AopPatternContainer> pair = this.getOperands();
        if (pair == null) {
            return null;
        }
        return "'_:[is(\"" + pattern0 + "\") " + (this.getOperation() == AopOperation.AND ? "&&" : "||") + " is(\"" + pattern1 + "\")]";
    }

    public static void conjunctPatterns(Collection<? extends AopPsiTypePattern> leftPatterns, Collection<? extends AopPsiTypePattern> rightPatterns, Collection<? super AopPsiTypePattern> result) {
        for (AopPsiTypePattern aopPsiTypePattern : leftPatterns) {
            for (AopPsiTypePattern aopPsiTypePattern2 : rightPatterns) {
                result.add(AopPsiTypePatternsUtil.conjunctPatterns(aopPsiTypePattern, aopPsiTypePattern2));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/psi/AopBinaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/psi/AopBinaryExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptsSubject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AopOperation {
        AND,
        OR;

    }
}

