/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdviceType;
import com.intellij.aop.AopBundle;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractArgNamesInspection;
import com.intellij.aop.jam.SetArgNamesQuickFix;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.PsiArgsExpression;
import com.intellij.aop.psi.PsiAtPointcutDesignator;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.aop.psi.PsiTargetExpression;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ArgNamesWarningsInspection
extends AbstractArgNamesInspection {
    @Override
    protected void checkAnnotation(PsiParameter[] parameters, ProblemsHolder holder, ArgNamesManipulator manipulator, PsiMethod method) {
        if (manipulator.getArgNames() == null && !ArgNamesWarningsInspection.canInferParameters(parameters, manipulator, method)) {
            holder.registerProblem(manipulator.getArgNamesProblemElement(), AopBundle.message("warning.argNames.should.be.defined", manipulator.getArgNamesAttributeName()), new LocalQuickFix[]{new SetArgNamesQuickFix(AopBundle.message("quickfix.name.define.attribute", manipulator.getArgNamesAttributeName()), true, manipulator, method)});
            return;
        }
        AopAdviceType adviceType = manipulator.getAdviceType();
        if (parameters.length > 0 && adviceType != null && adviceType != AopAdviceType.AROUND && parameters[0].getType().equalsToText("org.aspectj.lang.ProceedingJoinPoint")) {
            holder.registerProblem(manipulator.getArgNamesProblemElement(), AopBundle.message("error.pjp.not.allowed", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean canInferParameters(PsiParameter[] parameters, ArgNamesManipulator manipulator, PsiMethod method) {
        List primitives;
        if (parameters.length == 0) {
            return true;
        }
        HashSet<PsiParameter> set = new HashSet<PsiParameter>(Arrays.asList(parameters));
        if (LocalAopModel.isJoinPointParameter(parameters[0])) {
            set.remove(parameters[0]);
            if (set.isEmpty()) {
                return true;
            }
        }
        if (manipulator.getThrowingReference() != null && ArgNamesWarningsInspection.containsOnlyOneParameter(method, set, "java.lang.Throwable")) {
            return true;
        }
        Class<PsiAtPointcutDesignator> designatorClass = PsiAtPointcutDesignator.class;
        List<PsiParameter> shouldBeAnnos = ArgNamesWarningsInspection.findParametersUsedInPointcuts(set, designatorClass);
        if (shouldBeAnnos.size() == 1 && ArgNamesWarningsInspection.containsOnlyOneParameter(method, set, "java.lang.annotation.Annotation")) {
            return true;
        }
        if (manipulator.getReturningReference() != null) {
            return set.size() == 1;
        }
        List<PsiParameter> canBePrimitive = ArgNamesWarningsInspection.findParametersUsedInPointcuts(set, PsiArgsExpression.class);
        if (canBePrimitive.size() == 1 && (primitives = ContainerUtil.findAll(set, psiParameter -> psiParameter.getType() instanceof PsiPrimitiveType)).size() == 1) {
            set.removeAll(primitives);
            if (set.isEmpty()) {
                return true;
            }
        }
        if (set.size() == 1) {
            if (canBePrimitive.size() == 1) {
                return true;
            }
            if (ArgNamesWarningsInspection.findParametersUsedInPointcuts(set, PsiThisExpression.class).size() == 1) {
                return true;
            }
            if (ArgNamesWarningsInspection.findParametersUsedInPointcuts(set, PsiTargetExpression.class).size() == 1) {
                return true;
            }
        }
        return false;
    }

    private static List<PsiParameter> findParametersUsedInPointcuts(Set<PsiParameter> set, Class<?> designatorClass) {
        return ContainerUtil.findAll(set, psiParameter -> !ReferencesSearch.search((PsiElement)psiParameter).forEach(reference -> !(reference instanceof AopReferenceExpression) || !designatorClass.isInstance(PsiTreeUtil.getParentOfType((PsiElement)((AopReferenceExpression)reference), PsiPointcutExpression.class))));
    }

    private static boolean containsOnlyOneParameter(PsiMethod method, Set<PsiParameter> set, String className) {
        PsiClassType baseType = JavaPsiFacade.getInstance((Project)method.getManager().getProject()).getElementFactory().createTypeByFQClassName(className, method.getResolveScope());
        List instanceofs = ContainerUtil.findAll(set, psiParameter -> baseType.isAssignableFrom(psiParameter.getType()));
        if (instanceofs.size() == 1) {
            set.removeAll(instanceofs);
            if (set.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

