/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractArgNamesInspection;
import com.intellij.aop.jam.SetArgNamesQuickFix;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArgNamesErrorsInspection
extends AbstractArgNamesInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            ArgNamesErrorsInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkAnnotation(PsiParameter[] parameters, ProblemsHolder holder, ArgNamesManipulator manipulator, PsiMethod method) {
        PsiReference returningReference;
        String names = manipulator.getArgNames();
        if (names != null) {
            String[] strings = names.trim().split(",");
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i].trim();
            }
            List<String> actualNames = ArgNamesErrorsInspection.getGeneralArgumentNames(parameters);
            if (!actualNames.equals(Arrays.asList(strings))) {
                holder.registerProblem(manipulator.getArgNamesProblemElement(), AopBundle.message("error.argNames.should.match", manipulator.getArgNamesAttributeName()), new LocalQuickFix[]{new SetArgNamesQuickFix(AopBundle.message("quickfix.name.arg.names.correct", manipulator.getArgNamesAttributeName()), true, manipulator, method), new SetArgNamesQuickFix(AopBundle.message("quickfix.name.arg.names.remove", manipulator.getArgNamesAttributeName()), false, manipulator, method)});
                return;
            }
        }
        if ((returningReference = manipulator.getReturningReference()) != null && method != null && returningReference.resolve() == null) {
            ArgNamesErrorsInspection.addAnnoReferenceProblem(holder, returningReference);
            return;
        }
        PsiReference throwingReference = manipulator.getThrowingReference();
        if (throwingReference != null) {
            PsiManager psiManager;
            PsiClass throwableClass;
            PsiElement psiElement = throwingReference.resolve();
            if (method != null && psiElement == null) {
                ArgNamesErrorsInspection.addAnnoReferenceProblem(holder, throwingReference);
                return;
            }
            if (psiElement instanceof PsiParameter && (throwableClass = JavaPsiFacade.getInstance((Project)(psiManager = psiElement.getManager()).getProject()).findClass("java.lang.Throwable", GlobalSearchScope.allScope((Project)psiElement.getProject()))) != null && !JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(throwableClass).isAssignableFrom(((PsiParameter)psiElement).getType())) {
                holder.registerProblem(throwingReference.getElement(), AopBundle.message("error.throwable.expected", new Object[0]), new LocalQuickFix[0]);
                return;
            }
        }
        for (PsiParameter parameter : parameters) {
            boolean hasRef;
            if (LocalAopModel.isJoinPointParameter(parameter)) continue;
            boolean bl = hasRef = !ReferencesSearch.search((PsiElement)parameter).forEach(reference -> AopPointcutUtil.findHolder(reference.getElement()) == null);
            if (hasRef || parameter.equals(manipulator.getReturningParameter()) || parameter.equals(manipulator.getThrowingParameter())) continue;
            holder.registerProblem(manipulator.getArgNamesProblemElement(), AopBundle.message("unbound.pointcut.parameter", parameter.getName()), new LocalQuickFix[0]);
        }
    }

    private static void addAnnoReferenceProblem(ProblemsHolder holder, PsiReference returningReference) {
        PsiElement element = returningReference.getElement();
        TextRange range = returningReference.getRangeInElement();
        boolean emptyRange = range.isEmpty();
        if (emptyRange) {
            range = TextRange.from((int)range.getStartOffset(), (int)1);
        }
        String message = ((EmptyResolveMessageProvider)returningReference).getUnresolvedMessagePattern();
        ProblemHighlightType highlightType = emptyRange || !(element instanceof PsiLiteralExpression) && !(element instanceof XmlElement) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        holder.registerProblem(InspectionManager.getInstance((Project)element.getProject()).createProblemDescriptor(element, range, message, highlightType, holder.isOnTheFly(), new LocalQuickFix[0]));
    }

    public static List<String> getGeneralArgumentNames(PsiParameter[] parameters) {
        ArrayList<String> actualNames = new ArrayList<String>();
        for (PsiParameter parameter : parameters) {
            actualNames.add(parameter.getName());
        }
        return actualNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/ArgNamesErrorsInspection", "getDefaultLevel"));
    }
}

