/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.build;

import com.github.dockerjava.api.exception.DockerClientException;
import com.intellij.docker.agent.build.ContextFolderArchive;
import com.intellij.docker.agent.build.DockerIgnoreFile;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.TtySink;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/docker/agent/build/Dockerfile;", "", "dockerFile", "Ljava/io/File;", "baseDirectory", "(Ljava/io/File;Ljava/io/File;)V", "getBaseDirectory", "()Ljava/io/File;", "getDockerFile", "filesToTransfer", "", "getFilesToTransfer", "()Ljava/util/List;", "filesToTransfer$delegate", "Lkotlin/Lazy;", "ignoreFile", "Lcom/intellij/docker/agent/build/DockerIgnoreFile;", "getIgnoreFile", "()Lcom/intellij/docker/agent/build/DockerIgnoreFile;", "ignoreFile$delegate", "buildContextFolderArchive", "Lcom/intellij/docker/agent/build/ContextFolderArchive;", "tty", "Lcom/intellij/docker/agent/progress/TtySink;", "collectFilesInFolder", "", "rootFolder", "result", "", "isBaseDirectory", "directory", "intellij.clouds.docker.agent.impl.rt"})
public final class Dockerfile {
    private final Lazy ignoreFile$delegate;
    private final Lazy filesToTransfer$delegate;
    @NotNull
    private final File dockerFile;
    @NotNull
    private final File baseDirectory;

    private final DockerIgnoreFile getIgnoreFile() {
        Lazy lazy = this.ignoreFile$delegate;
        Dockerfile dockerfile = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DockerIgnoreFile)lazy.getValue();
    }

    private final List<File> getFilesToTransfer() {
        Lazy lazy = this.filesToTransfer$delegate;
        Dockerfile dockerfile = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final ContextFolderArchive buildContextFolderArchive(@NotNull TtySink tty) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tty, (String)"tty");
        DockerProgressDetailsFormat dockerProgressDetailsFormat = new DockerProgressDetailsFormat();
        boolean bl = false;
        boolean bl2 = false;
        DockerProgressDetailsFormat it = dockerProgressDetailsFormat;
        boolean bl3 = false;
        it.setUnits("files");
        DockerProgressDetailsFormat ttyFormat = dockerProgressDetailsFormat;
        int total = this.getFilesToTransfer().size();
        tty.ttyPrintln("Preparing build context archive...");
        tty.ttyPrintln(ttyFormat.toTtyString(0, total));
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        String archiveNameWithOutExtension = string;
        ContextFolderArchive archive = new ContextFolderArchive(this.baseDirectory, archiveNameWithOutExtension);
        archive.createArchiveWith((Function1<? super TarArchiveOutputStream, Unit>)((Function1)new Function1<TarArchiveOutputStream, Unit>(this, total, tty, ttyFormat, archive){
            final /* synthetic */ Dockerfile this$0;
            final /* synthetic */ int $total;
            final /* synthetic */ TtySink $tty;
            final /* synthetic */ DockerProgressDetailsFormat $ttyFormat;
            final /* synthetic */ ContextFolderArchive $archive;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TarArchiveOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int batch = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)(this.$total / 10), (int)1), (int)25);
                boolean bl = false;
                for (File nextFile : (Iterable)Dockerfile.access$getFilesToTransfer$p(this.this$0)) {
                    void idx;
                    if (idx % batch == false) {
                        this.$tty.ttyCursorUp(1);
                        this.$tty.ttyClearLine();
                        this.$tty.ttyPrintln(this.$ttyFormat.toTtyString((int)idx, this.$total));
                    }
                    this.$archive.addFileToTar(it, nextFile);
                    ++idx;
                }
            }
            {
                this.this$0 = dockerfile;
                this.$total = n;
                this.$tty = ttySink;
                this.$ttyFormat = dockerProgressDetailsFormat;
                this.$archive = contextFolderArchive;
                super(1);
            }
        }));
        tty.ttyCursorUp(1);
        tty.ttyClearLine();
        tty.ttyPrintln(ttyFormat.toTtyString(total, total));
        tty.ttyPrintln("Done");
        tty.ttyPrintln("");
        return archive;
    }

    private final boolean collectFilesInFolder(File rootFolder, List<File> result) {
        File[] files = rootFolder.listFiles();
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        boolean bl = false;
        if (fileArray.length == 0 && !this.isBaseDirectory(rootFolder)) {
            result.add(rootFolder);
        }
        boolean found = false;
        File[] fileArray2 = files;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File nextFile;
            File file = nextFile = fileArray2[i];
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nextFile");
            if (file.isDirectory()) {
                found = this.collectFilesInFolder(nextFile, result) || found;
                continue;
            }
            if (this.getIgnoreFile().isIgnored(nextFile)) continue;
            found = found || Intrinsics.areEqual((Object)nextFile, (Object)this.dockerFile);
            result.add(nextFile);
        }
        return found;
    }

    private final boolean isBaseDirectory(File directory) {
        return directory.compareTo(this.baseDirectory) == 0;
    }

    @NotNull
    public final File getDockerFile() {
        return this.dockerFile;
    }

    @NotNull
    public final File getBaseDirectory() {
        return this.baseDirectory;
    }

    public Dockerfile(@NotNull File dockerFile, @NotNull File baseDirectory) {
        Intrinsics.checkNotNullParameter((Object)dockerFile, (String)"dockerFile");
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        this.dockerFile = dockerFile;
        this.baseDirectory = baseDirectory;
        this.ignoreFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DockerIgnoreFile>(this){
            final /* synthetic */ Dockerfile this$0;

            @NotNull
            public final DockerIgnoreFile invoke() {
                return new DockerIgnoreFile(this.this$0.getBaseDirectory());
            }
            {
                this.this$0 = dockerfile;
                super(0);
            }
        }));
        this.filesToTransfer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(this){
            final /* synthetic */ Dockerfile this$0;

            @NotNull
            public final List<File> invoke() {
                if (this.this$0.getBaseDirectory().listFiles() == null) {
                    throw (Throwable)new DockerClientException("Failed to read build context directory: " + this.this$0.getBaseDirectory().getAbsolutePath());
                }
                boolean bl = false;
                List result = new ArrayList<E>();
                boolean dockerFileFound = Dockerfile.access$collectFilesInFolder(this.this$0, this.this$0.getBaseDirectory(), result);
                if (!dockerFileFound) {
                    result.add(this.this$0.getDockerFile());
                }
                return CollectionsKt.toList((Iterable)result);
            }
            {
                this.this$0 = dockerfile;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ List access$getFilesToTransfer$p(Dockerfile $this) {
        return $this.getFilesToTransfer();
    }

    public static final /* synthetic */ boolean access$collectFilesInFolder(Dockerfile $this, File rootFolder, List result) {
        return $this.collectFilesInFolder(rootFolder, result);
    }
}

