/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.build;

import com.github.dockerjava.core.util.FilePathUtil;
import com.google.common.io.ByteStreams;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.TtySink;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u001a\u0010\u000f\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0019\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/agent/build/ContextFolderArchive;", "", "baseDirectory", "Ljava/io/File;", "archiveNameWithOutExtension", "", "(Ljava/io/File;Ljava/lang/String;)V", "basePath", "Ljava/nio/file/Path;", "tarFile", "addFileToTar", "", "tar", "Lorg/apache/commons/compress/archivers/tar/TarArchiveOutputStream;", "file", "createArchiveWith", "operation", "Lkotlin/Function1;", "createInputStream", "Ljava/io/InputStream;", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "dispose", "pathRelativeToBase", "kotlin.jvm.PlatformType", "path", "Companion", "intellij.clouds.docker.agent.impl.rt"})
public final class ContextFolderArchive {
    private final Path basePath;
    private final File tarFile;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createArchiveWith(@NotNull Function1<? super TarArchiveOutputStream, Unit> operation) throws IOException {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.tarFile))));
        tos.setLongFileMode(2);
        Closeable closeable = (Closeable)tos;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Object object = operation.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void addFileToTar(@NotNull TarArchiveOutputStream tar, @NotNull File file) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter((Object)tar, (String)"tar");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path2 = path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        String string = this.pathRelativeToBase(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathRelativeToBase(path)");
        ContextFolderArchive.Companion.addFileToTar(tar, path2, string);
    }

    public final void dispose() {
        FileUtils.deleteQuietly((File)this.tarFile);
    }

    @NotNull
    public final InputStream createInputStream(@NotNull TtySink ttySink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        DockerProgressDetailsFormat formatter = new DockerProgressDetailsFormat();
        FileInputStream tarInputStream = FileUtils.openInputStream((File)this.tarFile);
        long sizeInBytes = this.tarFile.exists() ? this.tarFile.length() : 0L;
        long batch = RangesKt.coerceAtMost((long)RangesKt.coerceAtLeast((long)(sizeInBytes / (long)20), (long)100000L), (long)5000000L);
        return new InputStream(this, tarInputStream, ttySink, formatter, sizeInBytes, batch){
            private long nextReportAt;
            private long readSoFar;
            final /* synthetic */ ContextFolderArchive this$0;
            final /* synthetic */ FileInputStream $tarInputStream;
            final /* synthetic */ TtySink $ttySink;
            final /* synthetic */ DockerProgressDetailsFormat $formatter;
            final /* synthetic */ long $sizeInBytes;
            final /* synthetic */ long $batch;

            public int available() {
                return this.$tarInputStream.available();
            }

            public int read() {
                int result = this.$tarInputStream.read();
                if (result >= 0) {
                    this.streamAdvanced(1);
                }
                return result;
            }

            public int read(@NotNull byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                int result = this.$tarInputStream.read(b, off, len);
                if (result > 0) {
                    this.streamAdvanced(result);
                }
                return result;
            }

            public void close() {
                IOUtils.closeQuietly((InputStream)this.$tarInputStream);
                this.this$0.dispose();
            }

            private final void streamAdvanced(int bytes) {
                if (this.readSoFar <= 0L) {
                    this.$ttySink.ttyPrintln("Sending build context to Docker daemon...");
                    this.$ttySink.ttyPrintln(this.$formatter.toTtyString(0L, this.$sizeInBytes));
                }
                this.readSoFar += (long)bytes;
                if (this.readSoFar >= this.nextReportAt || this.readSoFar >= this.$sizeInBytes) {
                    this.$ttySink.ttyCursorUp(1);
                    this.$ttySink.ttyClearLine();
                    long l = this.readSoFar;
                    long l2 = this.$sizeInBytes;
                    boolean bl = false;
                    this.$ttySink.ttyPrintln(this.$formatter.toTtyString(Math.min(l, l2), this.$sizeInBytes));
                }
                if (this.readSoFar >= this.$sizeInBytes) {
                    this.$ttySink.ttyPrintln("Done");
                    this.$ttySink.ttyPrintln("");
                }
                while (this.nextReportAt <= this.readSoFar) {
                    this.nextReportAt += this.$batch;
                }
            }
            {
                this.this$0 = this$0;
                this.$tarInputStream = $captured_local_variable$1;
                this.$ttySink = $captured_local_variable$2;
                this.$formatter = $captured_local_variable$3;
                this.$sizeInBytes = $captured_local_variable$4;
                this.$batch = $captured_local_variable$5;
            }
        };
    }

    public final String pathRelativeToBase(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilePathUtil.relativize((Path)this.basePath, (Path)path);
    }

    public ContextFolderArchive(@NotNull File baseDirectory, @NotNull String archiveNameWithOutExtension) {
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        Intrinsics.checkNotNullParameter((Object)archiveNameWithOutExtension, (String)"archiveNameWithOutExtension");
        Path path = baseDirectory.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"baseDirectory.toPath()");
        this.basePath = path;
        this.tarFile = new File(FileUtils.getTempDirectoryPath(), archiveNameWithOutExtension + ".tar");
        this.tarFile.deleteOnExit();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/build/ContextFolderArchive$Companion;", "", "()V", "addFileToTar", "", "Lorg/apache/commons/compress/archivers/tar/TarArchiveOutputStream;", "file", "Ljava/nio/file/Path;", "entryName", "", "intellij.clouds.docker.agent.impl.rt"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addFileToTar(TarArchiveOutputStream $this$addFileToTar, Path file, String entryName) throws IOException {
            if (Files.isSymbolicLink(file)) {
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(entryName, 50);
                tarArchiveEntry.setLinkName(((Object)Files.readSymbolicLink(file)).toString());
                $this$addFileToTar.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
            } else {
                ArchiveEntry archiveEntry = $this$addFileToTar.createArchiveEntry(file.toFile(), entryName);
                if (archiveEntry == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.apache.commons.compress.archivers.tar.TarArchiveEntry");
                }
                TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)archiveEntry;
                if (file.toFile().canExecute()) {
                    tarArchiveEntry.setMode(tarArchiveEntry.getMode() | 0x1ED);
                }
                $this$addFileToTar.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                File file2 = file.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.toFile()");
                if (file2.isFile()) {
                    Closeable closeable = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        BufferedInputStream input = (BufferedInputStream)closeable;
                        boolean bl3 = false;
                        long l = ByteStreams.copy((InputStream)input, (OutputStream)((OutputStream)$this$addFileToTar));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
            $this$addFileToTar.closeArchiveEntry();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

