/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.auth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.AuthConfig;
import com.intellij.docker.agent.auth.DockerAuthProvider;
import com.intellij.docker.agent.auth.DockerHelperRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0002 !B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0003J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bJ\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider;", "", "configFolderPath", "", "(Ljava/lang/String;)V", "cachedErrorGetOutputs", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "runner", "Lcom/intellij/docker/agent/auth/DockerHelperRunner;", "doLaunchHelperGet", "helperName", "host", "doLaunchHelperList", "getAuthConfig", "Lcom/github/dockerjava/api/model/AuthConfig;", "getAuthFromHelper", "config", "Lcom/fasterxml/jackson/databind/JsonNode;", "getAuthFromStore", "helperExecutable", "listAllSupportedHosts", "", "listSupportedHostsAndUsers", "", "parseDockerConfig", "parseHelperGetOutput", "Companion", "HelperCredentials", "intellij.clouds.docker.agent.impl.rt"})
public final class DockerAuthProvider {
    private final List<String> cachedErrorGetOutputs;
    private final DockerHelperRunner runner;
    private final Lazy objectMapper$delegate;
    private final String configFolderPath;
    private static final String CRED_HELPERS_NODE = "credHelpers";
    private static final String CRED_STORE_NODE = "credsStore";
    private static final Lazy LOG$delegate;
    public static final Companion Companion;

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        DockerAuthProvider dockerAuthProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    @Nullable
    public final AuthConfig getAuthConfig(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (StringsKt.isBlank((CharSequence)host)) {
            return null;
        }
        JsonNode jsonNode = this.parseDockerConfig();
        if (jsonNode == null) {
            return null;
        }
        JsonNode configNode = jsonNode;
        AuthConfig authConfig = this.getAuthFromHelper(configNode, host);
        if (authConfig == null) {
            authConfig = this.getAuthFromStore(configNode, host);
        }
        return authConfig;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> listAllSupportedHosts() {
        List list;
        Object object = this.parseDockerConfig();
        if (object != null && (object = DockerAuthProvider.Companion.allHelpersAndStores(object)) != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)object;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.listSupportedHostsAndUsers(it).keySet();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final AuthConfig getAuthFromHelper(JsonNode config, String host) {
        String string = DockerAuthProvider.Companion.credHelperForHost(config, host);
        if (string == null) {
            return null;
        }
        String helperForHost = string;
        return this.parseHelperGetOutput(helperForHost, host);
    }

    private final AuthConfig getAuthFromStore(JsonNode config, String host) {
        String string = DockerAuthProvider.Companion.credStore(config);
        if (string == null) {
            return null;
        }
        String defaultHelperName = string;
        return this.parseHelperGetOutput(defaultHelperName, host);
    }

    private final Map<String, String> listSupportedHostsAndUsers(String helperName) {
        String output = null;
        try {
            output = this.doLaunchHelperList(helperName);
        }
        catch (IOException e) {
            DockerAuthProvider.Companion.getLOG().error((Object)("Can't launch `" + helperName + " list`"), (Throwable)e);
            return MapsKt.emptyMap();
        }
        try {
            Object object = this.getObjectMapper().readValue(output, Map.class);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            }
            return (Map)object;
        }
        catch (IOException e) {
            DockerAuthProvider.Companion.getLOG().error((Object)("Can't parse helper `list` response from " + helperName + ": `" + output + '`'), (Throwable)e);
            return MapsKt.emptyMap();
        }
    }

    private final AuthConfig parseHelperGetOutput(String helperName, String host) {
        String output = null;
        try {
            output = this.doLaunchHelperGet(helperName, host);
        }
        catch (IOException e) {
            DockerAuthProvider.Companion.getLOG().error((Object)("Can't launch `" + helperName + " get` for host: " + host), (Throwable)e);
            return null;
        }
        if (this.cachedErrorGetOutputs.contains(output)) {
            return null;
        }
        try {
            HelperCredentials helperCredentials = (HelperCredentials)this.getObjectMapper().readValue(output, HelperCredentials.class);
            return helperCredentials != null ? helperCredentials.toAuthConfig() : null;
        }
        catch (IOException e) {
            DockerAuthProvider.Companion.getLOG().error((Object)("Can't parse helper `get` response from " + helperName + " for host: " + host + ": `" + output + '`'), (Throwable)e);
            this.cachedErrorGetOutputs.add(output);
            return null;
        }
    }

    private final String doLaunchHelperGet(String helperName, String host) throws IOException {
        return this.runner.runProcess$intellij_clouds_docker_agent_impl_rt(host, this.helperExecutable(helperName), "get");
    }

    private final String doLaunchHelperList(String helperName) throws IOException {
        return this.runner.runProcess$intellij_clouds_docker_agent_impl_rt(null, this.helperExecutable(helperName), "list");
    }

    private final String helperExecutable(String helperName) {
        return "docker-credential-" + helperName;
    }

    /*
     * Unable to fully structure code
     */
    private final JsonNode parseDockerConfig() {
        v0 = this.configFolderPath;
        if (v0 == null) ** GOTO lbl-1000
        var2_1 = v0;
        var3_3 = false;
        var4_4 = false;
        it = var2_1;
        $i$a$-let-DockerAuthProvider$parseDockerConfig$configFile$1 = false;
        var2_1 = new File((String)it);
        var3_3 = false;
        var4_4 = false;
        it = var2_1;
        $i$a$-takeIf-DockerAuthProvider$parseDockerConfig$configFile$2 = false;
        v0 = (it.exists() != false && it.isDirectory() != false) != false ? var2_1 : null;
        if (v0 != null) {
            var2_1 = v0;
            var3_3 = false;
            var4_4 = false;
            it = var2_1;
            $i$a$-let-DockerAuthProvider$parseDockerConfig$configFile$3 = false;
            var2_1 = new File((File)it, "config.json");
            var3_3 = false;
            var4_4 = false;
            it = var2_1;
            $i$a$-takeIf-DockerAuthProvider$parseDockerConfig$configFile$4 = false;
            v1 = it.exists() != false && it.isFile() != false ? var2_1 : null;
        } else lbl-1000:
        // 2 sources

        {
            v1 = configFile = null;
        }
        if (configFile == null) {
            com.intellij.docker.agent.auth.DockerAuthProvider$Companion.access$getLOG$p(DockerAuthProvider.Companion).error((Object)("Can't access config file in folder: " + this.configFolderPath));
            return null;
        }
        try {
            return this.getObjectMapper().readTree(configFile);
        }
        catch (IOException e) {
            com.intellij.docker.agent.auth.DockerAuthProvider$Companion.access$getLOG$p(DockerAuthProvider.Companion).error((Object)("Can't read config file at " + configFile), (Throwable)e);
            return null;
        }
    }

    public DockerAuthProvider(@Nullable String configFolderPath) {
        this.configFolderPath = configFolderPath;
        boolean bl = false;
        this.cachedErrorGetOutputs = new ArrayList();
        this.runner = new DockerHelperRunner();
        this.objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR \u0010\f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider$HelperCredentials;", "", "()V", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "secret", "getSecret", "setSecret", "username", "getUsername", "setUsername", "toAuthConfig", "Lcom/github/dockerjava/api/model/AuthConfig;", "intellij.clouds.docker.agent.impl.rt"})
    public static final class HelperCredentials {
        @JsonProperty(value="ServerURL")
        @Nullable
        private String host;
        @JsonProperty(value="Username")
        @Nullable
        private String username;
        @JsonProperty(value="Secret")
        @Nullable
        private String secret;

        @Nullable
        public final String getHost() {
            return this.host;
        }

        public final void setHost(@Nullable String string) {
            this.host = string;
        }

        @Nullable
        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(@Nullable String string) {
            this.username = string;
        }

        @Nullable
        public final String getSecret() {
            return this.secret;
        }

        public final void setSecret(@Nullable String string) {
            this.secret = string;
        }

        @NotNull
        public final AuthConfig toAuthConfig() {
            AuthConfig result = new AuthConfig().withRegistryAddress(this.host).withUsername(this.username);
            if (Intrinsics.areEqual((Object)this.username, (Object)"<token>")) {
                result.withIdentityToken(this.secret);
            } else {
                result.withPassword(this.secret);
            }
            AuthConfig authConfig = result;
            Intrinsics.checkNotNullExpressionValue((Object)authConfig, (String)"result");
            return authConfig;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r*\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0004*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0004*\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider$Companion;", "", "()V", "CRED_HELPERS_NODE", "", "CRED_STORE_NODE", "LOG", "Lorg/apache/log4j/Logger;", "getLOG", "()Lorg/apache/log4j/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "allHelpersAndStores", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "credHelperForHost", "host", "credStore", "safeAsText", "intellij.clouds.docker.agent.impl.rt"})
    public static final class Companion {
        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        private final String credHelperForHost(JsonNode $this$credHelperForHost, String host) {
            JsonNode jsonNode = $this$credHelperForHost.get(DockerAuthProvider.CRED_HELPERS_NODE);
            return jsonNode != null && (jsonNode = jsonNode.get(host)) != null ? this.safeAsText(jsonNode) : null;
        }

        private final String credStore(JsonNode $this$credStore) {
            JsonNode jsonNode = $this$credStore.get(DockerAuthProvider.CRED_STORE_NODE);
            return jsonNode != null ? this.safeAsText(jsonNode) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> allHelpersAndStores(JsonNode $this$allHelpersAndStores) {
            boolean bl = false;
            List result = new ArrayList();
            result.add(this.credStore($this$allHelpersAndStores));
            JsonNode jsonNode = $this$allHelpersAndStores.get(DockerAuthProvider.CRED_HELPERS_NODE);
            if (jsonNode != null) {
                JsonNode jsonNode2 = jsonNode;
                boolean bl2 = false;
                boolean bl3 = false;
                JsonNode groupNode = jsonNode2;
                boolean bl4 = false;
                int n = 0;
                int n2 = groupNode.size();
                if (n <= n2) {
                    while (true) {
                        void i;
                        Object object;
                        if ((object = groupNode.get((int)i)) != null && (object = Companion.safeAsText((JsonNode)object)) != null) {
                            Object object2 = object;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            Object it = object2;
                            boolean bl7 = false;
                            result.add(it);
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
            }
            return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)result));
        }

        private final String safeAsText(JsonNode $this$safeAsText) {
            JsonNode jsonNode = $this$safeAsText;
            boolean bl = false;
            boolean bl2 = false;
            JsonNode it = jsonNode;
            boolean bl3 = false;
            Object object = !it.isMissingNode() && it.isTextual() ? jsonNode : null;
            return object != null ? object.asText() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

