/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.OngoingProcessResultCallbackBase;
import com.intellij.docker.agent.ResponseItemAggregator;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushImageResultCallbackImpl
extends OngoingProcessResultCallbackBase<PushResponseItem> {
    private static final String PUSH_COMPLETE_STATUS = "Pushed";
    private final ResponseItemAggregator myProgressAggregator = new ResponseItemAggregator();
    private final StatusAggregator myStatusAggregator = new StatusAggregator();
    private final String myQualifiedImageReference;

    public PushImageResultCallbackImpl(DockerAgentProgressCallback callback, CloudAgentLogger logger, String qualifiedImageReference) {
        super(callback, logger);
        this.myQualifiedImageReference = qualifiedImageReference;
    }

    @Override
    protected void ongoingProcessDelegateCancelled() {
        this.setSuccessMessage("Push cancelled");
    }

    public void onNext(PushResponseItem item) {
        String status = item.getStatus();
        String id = item.getId();
        if (item.isErrorIndicated()) {
            this.setErrorMessage(item.getErrorDetail().getMessage());
        } else {
            ResponseItem.AuxDetail aux = item.getAux();
            if (aux != null && aux.getDigest() != null) {
                this.myStatusAggregator.setOverallStatus(MessageFormat.format("{0} pushed successfully", this.myQualifiedImageReference));
            }
        }
        if (status == null) {
            return;
        }
        ResponseItemAggregator.ProgressInfo aggregatedProgress = null;
        if (id == null) {
            this.myStatusAggregator.addGeneralStatus(status);
        } else if (PushImageResultCallbackImpl.hasProgressDetails(item)) {
            aggregatedProgress = this.updateAggregatedProgress(item, status, id);
        } else {
            this.myStatusAggregator.addLayerStatus(id, status);
        }
        if (aggregatedProgress != null) {
            this.getAgentCallback().step(status, aggregatedProgress.getCurrent(), aggregatedProgress.getTotal());
        } else {
            this.getAgentCallback().step(status, 0L, 0L);
        }
    }

    @Nullable
    private ResponseItemAggregator.ProgressInfo updateAggregatedProgress(@NotNull PushResponseItem item, @NotNull String status, @NotNull String id) {
        if (item == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(0);
        }
        if (status == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(1);
        }
        if (id == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(2);
        }
        if (PUSH_COMPLETE_STATUS.equals(status)) {
            this.myProgressAggregator.completeProgress(id);
        } else {
            this.myProgressAggregator.updateProgress((ResponseItem)item);
        }
        return this.myProgressAggregator.computeAggregatedProgress();
    }

    private static boolean hasProgressDetails(@NotNull PushResponseItem item) {
        ResponseItem.ProgressDetail detail;
        if (item == null) {
            PushImageResultCallbackImpl.$$$reportNull$$$0(3);
        }
        return (detail = item.getProgressDetail()) != null && detail.getTotal() != null && detail.getCurrent() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/PushImageResultCallbackImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAggregatedProgress";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProgressDetails";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class StatusAggregator {
        private int ourNextId;
        private static final String AUX_PREFIX = "\u0000_";
        private final LinkedHashMap<String, String> myStatuses = new LinkedHashMap();
        private String myOverallStatus;

        private StatusAggregator() {
        }

        private String nextAuxId() {
            return AUX_PREFIX + this.ourNextId++;
        }

        private boolean isAuxId(String text) {
            return text != null && text.startsWith(AUX_PREFIX);
        }

        public void setOverallStatus(@NotNull String status) {
            if (status == null) {
                StatusAggregator.$$$reportNull$$$0(0);
            }
            this.myOverallStatus = status;
            this.updateSuccessMessage();
        }

        public void addLayerStatus(@NotNull String id, @NotNull String status) {
            if (id == null) {
                StatusAggregator.$$$reportNull$$$0(1);
            }
            if (status == null) {
                StatusAggregator.$$$reportNull$$$0(2);
            }
            this.myStatuses.put(id, status);
            this.updateSuccessMessage();
        }

        public void addGeneralStatus(@NotNull String status) {
            if (status == null) {
                StatusAggregator.$$$reportNull$$$0(3);
            }
            this.myStatuses.put(this.nextAuxId(), status);
            this.updateSuccessMessage();
        }

        @NotNull
        public List<String> toList() {
            LinkedList<CallSite> result = new LinkedList<CallSite>();
            if (this.myOverallStatus != null) {
                result.add((CallSite)((Object)("<b>" + this.myOverallStatus + "</b><br/>")));
            }
            List list = this.myStatuses.entrySet().stream().map(kv -> this.isAuxId((String)kv.getKey()) ? (String)kv.getValue() : (String)kv.getKey() + ": " + (String)kv.getValue()).collect(Collectors.toCollection(() -> result));
            if (list == null) {
                StatusAggregator.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public String toAggregatedStatus() {
            String string = String.join((CharSequence)"<br/>", this.toList());
            if (string == null) {
                StatusAggregator.$$$reportNull$$$0(5);
            }
            return string;
        }

        private void updateSuccessMessage() {
            if (!this.isEmpty()) {
                PushImageResultCallbackImpl.this.setSuccessMessage(this.toAggregatedStatus());
            }
        }

        public boolean isEmpty() {
            return this.myStatuses.isEmpty() && this.myOverallStatus == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/PushImageResultCallbackImpl$StatusAggregator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/PushImageResultCallbackImpl$StatusAggregator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toList";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toAggregatedStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setOverallStatus";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addLayerStatus";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addGeneralStatus";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

