/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.BuildImageCmdWithCleanup;
import com.intellij.docker.agent.BuildLogTerminalPipe;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentApplicationBase;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImpl;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.DockerErrorUtil;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.DockerRunCliParser;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.VolumeMapper;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.DockerResponseItemTtyHandler;
import com.intellij.docker.agent.progress.ResponseItemCallbackTemplate;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentDeploymentImpl
extends DockerAgentApplicationBase
implements DockerAgentDeployment {
    private static final String[] NO_TAGS = new String[0];
    private final DockerAgentDeploymentConfig myConfig;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private final TtySink myBuildLogTtySink;
    private final TerminalListener myBuildLogCloser;
    private final VolumeMapper myVolumeMapper;
    private volatile String myImageId;
    private volatile String myImageTag;

    public DockerAgentDeploymentImpl(@NotNull DockerAgentContext context, @NotNull DockerAgentDeploymentConfig config, @NotNull CloudAgentLoggingHandler loggingHandler, @NotNull DockerAgentPathMapper pathMapper) {
        if (context == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(0);
        }
        if (config == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(1);
        }
        if (loggingHandler == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(2);
        }
        if (pathMapper == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(3);
        }
        super(context);
        this.myConfig = config;
        this.myLoggingHandler = loggingHandler;
        context.getLogger().debug("DockerAgentDeploymentImpl:<init>: " + this);
        if (loggingHandler.isTtySupported()) {
            BuildLogTerminalPipe buildLogPipe = new BuildLogTerminalPipe(this.toString() + ":buildLog");
            this.myBuildLogTtySink = buildLogPipe;
            TerminalListener closer = loggingHandler.createTerminal("Build Log", buildLogPipe.getTerminalInput(), buildLogPipe.getTerminalOutput(), null);
            this.myBuildLogCloser = Optional.ofNullable(closer).orElse(TerminalListener.NULL);
        } else {
            this.myBuildLogTtySink = TtySink.wrapNonTty(arg_0 -> ((CloudAgentLoggingHandler)loggingHandler).println(arg_0));
            this.myBuildLogCloser = TerminalListener.NULL;
        }
        this.myVolumeMapper = new VolumeMapper(pathMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerAgentApplication.ContainerUpdateResult deploy(@NotNull String displayName) {
        if (displayName == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(4);
        }
        CloudAgentErrorHandler ttySinkBeforeReporting = error -> {
            this.myBuildLogTtySink.coloredTtyPrintln("Failed to deploy '" + displayName + "': " + error, TtySink.Colors.RED);
            this.getErrorHandler().onError(error);
        };
        try {
            this.myBuildLogTtySink.coloredTtyPrintln("Deploying '" + displayName + "'...", TtySink.Colors.BLUE);
            DockerAgentApplication.ContainerUpdateResult result = this.doDeploy(ttySinkBeforeReporting);
            if (result != null) {
                this.myBuildLogTtySink.coloredTtyPrintln("'" + displayName + "' has been deployed successfully.", TtySink.Colors.GREEN);
            }
            DockerAgentApplication.ContainerUpdateResult containerUpdateResult = result;
            return containerUpdateResult;
        }
        finally {
            DockerAgentDeploymentImpl.printWithThreadSleep(() -> this.myBuildLogTtySink.ttyPrintln(""));
            this.myBuildLogCloser.close();
        }
    }

    private DockerAgentApplication.ContainerUpdateResult doDeploy(CloudAgentErrorHandler errorHandler) {
        return (DockerAgentApplication.ContainerUpdateResult)new ApiTaskBase<DockerAgentApplication.ContainerUpdateResult>(errorHandler){

            @Override
            protected DockerAgentApplication.ContainerUpdateResult doPerform() throws IOException, ApiTaskException {
                DockerAgentSourceType sourceType = DockerAgentSourceType.valueOf((String)DockerAgentDeploymentImpl.this.myConfig.sourceType());
                return new SingleDeployTask(sourceType).deploy();
            }
        }.perform();
    }

    @Override
    protected Bind[] prepareBinds(Bind[] binds) {
        return this.myVolumeMapper.expandPath(binds);
    }

    private void buildImage(@NotNull ResponseItemCallbackTemplate<BuildResponseItem> buildCallback) throws IOException, ApiTaskException {
        if (buildCallback == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(5);
        }
        if (!this.getAgent().isConnected()) {
            throw new ApiTaskException("Not connected to docker");
        }
        this.myBuildLogTtySink.coloredTtyPrintln("Building image...", TtySink.Colors.BLUE);
        BuildImageCmdWithCleanup buildImageCmd = BuildImageCmdWithCleanup.forConfig(this.getClient(), this.myConfig);
        buildImageCmd.withTtySink(this.myBuildLogTtySink);
        try {
            buildImageCmd.execBuildImage(buildCallback);
        }
        catch (InterruptedException e) {
            this.getLogger().debugEx((Exception)e);
        }
    }

    @Override
    public void showLog(CloudAgentLoggingHandler loggingHandler) {
        super.showLog(this.useOwnHandlerForHostProject(loggingHandler));
    }

    public void attach(CloudAgentLoggingHandler loggingHandler) {
        super.attach(this.useOwnHandlerForHostProject(loggingHandler));
    }

    private CloudAgentLoggingHandler useOwnHandlerForHostProject(CloudAgentLoggingHandler passedHandler) {
        if (passedHandler == null) {
            return this.myLoggingHandler;
        }
        if (passedHandler.getProjectHash().equals(this.myLoggingHandler.getProjectHash())) {
            return this.myLoggingHandler;
        }
        return passedHandler;
    }

    @Override
    public OngoingProcess exec(CloudAgentLoggingHandler loggingHandler, String[] command, String logName, boolean allowSystemPrint) {
        return super.exec(this.useOwnHandlerForHostProject(loggingHandler), command, logName, allowSystemPrint);
    }

    public String getContainerName() {
        return null;
    }

    public String getImageName() {
        throw new UnsupportedOperationException();
    }

    public String getImageId() {
        return this.myImageId;
    }

    public String[] getImageRepoTags() {
        String[] stringArray;
        if (this.myImageTag == null) {
            stringArray = NO_TAGS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.myImageTag;
        }
        return stringArray;
    }

    public String[] getContainerNames() {
        return null;
    }

    public String getImageParentId() {
        return null;
    }

    @Nullable
    public String getPresentableName() {
        return null;
    }

    @NotNull
    public String getUniqueName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getAgentApplicationStatus() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "$" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    protected void setupContainerConfig(CreateContainerCmd target) {
        super.setupContainerConfig(target);
        if (this.myImageId != null) {
            target.withImage(this.myImageId);
        }
    }

    private static Predicate<Container> withContainerName(@NotNull String name) {
        if (name == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(6);
        }
        Object searchPattern = name.startsWith("/") ? name : "/" + name;
        return arg_0 -> DockerAgentDeploymentImpl.lambda$withContainerName$2((String)searchPattern, arg_0);
    }

    private static Predicate<Container> withLabel(@NotNull String label, @NotNull String value) {
        if (label == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(7);
        }
        if (value == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(8);
        }
        return container -> {
            Map allLabels = container.getLabels();
            return allLabels != null && value.equals(allLabels.get(label));
        };
    }

    private static Predicate<Image> idStartsWith(@NotNull String idOrTag) {
        if (idOrTag == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(9);
        }
        return img -> img.getId() != null && DockerAgentDeploymentImpl.trimShaPrefix(img.getId()).startsWith(DockerAgentDeploymentImpl.trimShaPrefix(idOrTag));
    }

    private static String trimShaPrefix(@NotNull String imageId) {
        if (imageId == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(10);
        }
        return imageId.startsWith("sha256:") ? imageId.substring("sha256:".length()) : imageId;
    }

    private static boolean safeValueOf(@Nullable Boolean bool) {
        return bool != null && bool != false;
    }

    private static /* synthetic */ boolean lambda$withContainerName$2(String searchPattern, Container container) {
        String[] containerNames = container.getNames();
        return containerNames != null && Arrays.asList(containerNames).contains(searchPattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loggingHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildCallback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idOrTag";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/DockerAgentDeploymentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deploy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "buildImage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "withContainerName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "withLabel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "idStartsWith";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "trimShaPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class TtySinkCallback<RI extends ResponseItem>
    extends ResponseItemCallbackTemplate<RI> {
        private final DockerResponseItemTtyHandler myTtyHandler;
        private final TtySink myTtySink;
        private Closeable myCancel;

        TtySinkCallback(@NotNull TtySink ttySink) {
            if (ttySink == null) {
                TtySinkCallback.$$$reportNull$$$0(0);
            }
            this.myTtySink = ttySink;
            this.myTtyHandler = new DockerResponseItemTtyHandler(ttySink);
        }

        @Nullable
        Closeable getCancel() {
            return this.myCancel;
        }

        @NotNull
        protected final TtySink getTtySink() {
            TtySink ttySink = this.myTtySink;
            if (ttySink == null) {
                TtySinkCallback.$$$reportNull$$$0(1);
            }
            return ttySink;
        }

        @NotNull
        protected final DockerResponseItemTtyHandler getTtyHandler() {
            DockerResponseItemTtyHandler dockerResponseItemTtyHandler = this.myTtyHandler;
            if (dockerResponseItemTtyHandler == null) {
                TtySinkCallback.$$$reportNull$$$0(2);
            }
            return dockerResponseItemTtyHandler;
        }

        public void onStart(Closeable closeable) {
            this.myCancel = closeable;
        }

        public void onError(Throwable throwable) {
            this.ttyReportError(throwable);
            super.onError(throwable);
        }

        protected void ttyReportError(Throwable throwable) {
            if (throwable instanceof DockerException) {
                String message = DockerErrorUtil.userFriendlyMessage((DockerException)((DockerException)throwable));
                this.getTtySink().coloredTtyPrintln("Error response from daemon: " + message, TtySink.Colors.RED);
            } else {
                String message = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getName());
                this.getTtySink().coloredTtyPrintln("Internal error: " + message, TtySink.Colors.RED);
            }
        }

        public void onComplete() {
            super.onComplete();
        }

        protected void throwFirstError() {
            super.throwFirstError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ttySink";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/DockerAgentDeploymentImpl$TtySinkCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/DockerAgentDeploymentImpl$TtySinkCallback";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTtySink";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTtyHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SingleDeployTask
    extends DeployTask {
        private CreateContainerCmdConfig myContainerCmdConfig;
        private final DockerAgentSourceType mySourceType;

        SingleDeployTask(DockerAgentSourceType sourceType) {
            this.mySourceType = sourceType;
        }

        @Override
        protected String doPrepareDeploy() throws IOException, ApiTaskException {
            CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
            this.applyCustomRunCliOptions((CreateContainerCmd)cmdConfig);
            this.myContainerCmdConfig = cmdConfig;
            if (this.mySourceType == DockerAgentSourceType.IMAGE) {
                String[] allTags = DockerAgentDeploymentImpl.this.myConfig.getImageTags();
                if (allTags == null || allTags.length == 0) {
                    throw new ApiTaskException("Either image tag or id is required");
                }
                DockerAgentDeploymentImpl.this.myImageId = this.pullImageIfNeeded(allTags[0]);
                CharSequence[] implicitlyRequired = DockerAgentDeploymentImpl.this.myConfig.getImplicitlyRequiredImages();
                if (implicitlyRequired != null) {
                    DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Checking implicitly required image dependencies: " + String.join((CharSequence)", ", implicitlyRequired), TtySink.Colors.BLUE);
                    for (CharSequence next : implicitlyRequired) {
                        this.pullImageIfNeeded((String)next);
                    }
                }
            } else {
                BuildCallback buildCallback = new BuildCallback(DockerAgentDeploymentImpl.this.myBuildLogTtySink);
                DockerAgentDeploymentImpl.this.buildImage(buildCallback);
                DockerAgentDeploymentImpl.this.myImageId = buildCallback.getBuiltImageId();
                DockerAgentDeploymentImpl.this.myImageTag = buildCallback.getBuiltImageTag();
                if (DockerAgentDeploymentImpl.this.myImageId == null) {
                    throw new ApiTaskException("Can't retrieve image ID from build stream");
                }
            }
            return DockerAgentDeploymentImpl.this.myConfig.getContainerName();
        }

        private void applyCustomRunCliOptions(CreateContainerCmd cmd) throws ApiTaskException {
            String[] cliOptions = DockerAgentDeploymentImpl.this.myConfig.getCustomRunOptions();
            if (cliOptions == null) {
                return;
            }
            File context = DockerAgentDeploymentImpl.this.myConfig.getCustomContextFolder();
            if (context == null && DockerAgentDeploymentImpl.this.myConfig.getFile() != null) {
                context = DockerAgentDeploymentImpl.this.myConfig.getFile().getParentFile();
            }
            DockerRunCliParser parser = new DockerRunCliParser();
            if (context != null) {
                parser.setContextFolder(context);
            }
            parser.parse(cmd, cliOptions);
        }

        @Override
        protected CreateContainerCmdConfig getContainerCmdConfig() {
            return this.myContainerCmdConfig;
        }

        @Override
        protected DockerAgentContainerConfigImpl getPriorityConfig() {
            return new DockerAgentContainerConfigImpl((DockerAgentContainerConfig)DockerAgentDeploymentImpl.this.myConfig);
        }

        @Override
        protected void setContainerId(String containerId) {
            DockerAgentDeploymentImpl.this.setContainerId(containerId);
        }

        private String pullImageIfNeeded(@NotNull String imageTagOrId) throws ApiTaskException {
            DockerRepoTag tag;
            if (imageTagOrId == null) {
                SingleDeployTask.$$$reportNull$$$0(0);
            }
            Predicate<Image> filter = DockerAgentDeploymentImpl.idStartsWith(imageTagOrId);
            if (imageTagOrId.startsWith("sha256:")) {
                tag = null;
            } else {
                tag = DockerRepoTag.fromString((String)imageTagOrId);
                filter = filter.or(img -> tag.matchesOneOfRepoTags(img.getRepoTags()));
            }
            Image localImage = this.findImageLocally(filter);
            if (localImage != null) {
                return localImage.getId();
            }
            if (tag == null) {
                return imageTagOrId;
            }
            DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln(MessageFormat.format("Unable to find image ''{0}'' locally", tag.getFullyQualifiedReference()), TtySink.Colors.BLUE);
            DockerAgentRepositoryConfig endpoint = tag.toAgentRepositoryConfig();
            class PullCallback
            extends TtySinkCallback<PullResponseItem> {
                PullCallback(TtySink ttySink) {
                    super(ttySink);
                }

                public void onNext(PullResponseItem agentItem) {
                    DockerResponseItem.Impl wrappedItem = DockerResponseItem.fromAgentItem((ResponseItem)agentItem).build();
                    this.getTtyHandler().handleItem((DockerResponseItem)wrappedItem);
                }
            }
            try (PullCallback callback = new PullCallback(DockerAgentDeploymentImpl.this.myBuildLogTtySink);){
                DockerAgentImpl agentImpl = (DockerAgentImpl)DockerAgentDeploymentImpl.this.getAgent();
                agentImpl.preparePullImageCmd(endpoint).exec((ResultCallback)callback);
                callback.awaitCompletion();
            }
            catch (IOException | InterruptedException e) {
                throw new ApiTaskException(e);
            }
            localImage = this.findImageLocally(filter);
            if (localImage == null) {
                throw new ApiTaskException("No such image " + tag.getFullyQualifiedReference());
            }
            return localImage.getId();
        }

        private Image findImageLocally(Predicate<Image> filter) {
            List images = (List)DockerAgentDeploymentImpl.this.getClient().listImagesCmd().withShowAll(Boolean.TRUE).exec();
            if (images == null || images.isEmpty()) {
                return null;
            }
            return images.stream().filter(filter).findAny().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageTagOrId", "com/intellij/docker/agent/DockerAgentDeploymentImpl$SingleDeployTask", "pullImageIfNeeded"));
        }
    }

    private abstract class DeployTask {
        private DeployTask() {
        }

        public DockerAgentApplication.ContainerUpdateResult deploy() throws IOException, ApiTaskException {
            String containerName = this.doPrepareDeploy();
            DockerAgentApplicationBase.ContainerUpdateResultImpl deployResult = new DockerAgentApplicationBase.ContainerUpdateResultImpl(DockerAgentDeploymentImpl.this.myImageId);
            if (DockerAgentDeploymentImpl.this.myConfig.isBuildImageOnly()) {
                return deployResult;
            }
            if (!DockerAgentDeploymentImpl.this.getAgent().isConnected()) {
                return deployResult;
            }
            String oldContainerId = this.findPreviousContainer();
            if (oldContainerId != null) {
                DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Existing container found: " + oldContainerId + ", removing...", TtySink.Colors.BLUE);
                DockerAgentDeploymentImpl.this.getClient().removeContainerCmd(oldContainerId).withForce(Boolean.TRUE).exec();
                deployResult.setRemovedContainerId(oldContainerId);
            }
            DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Creating container...", TtySink.Colors.BLUE);
            CreateContainerCmd createContainerCmd = DockerAgentDeploymentImpl.this.getClient().createContainerCmd(DockerAgentDeploymentImpl.this.myImageId);
            if (containerName != null) {
                createContainerCmd.withName(containerName);
            }
            CreateContainerCmdConfig cmdConfig = this.getContainerCmdConfig();
            CreateContainerCmdValueTransfers.createMergeForDeploy(binds -> DockerAgentDeploymentImpl.this.prepareBinds((Bind[])binds)).mergeWithPriority(this.getPriorityConfig(), cmdConfig, createContainerCmd);
            DockerAgentDeploymentImpl.this.setupContainerConfig(createContainerCmd);
            if (DockerAgentDeploymentImpl.this.myLoggingHandler.isTtySupported()) {
                createContainerCmd.withTty(Boolean.TRUE);
            }
            CreateContainerResponse createContainerResponse = createContainerCmd.exec();
            String containerId = createContainerResponse.getId();
            this.setContainerId(containerId);
            String[] warnings = createContainerResponse.getWarnings();
            if (warnings != null) {
                for (String warning : warnings) {
                    DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Warning: " + warning, TtySink.Colors.ORANGE);
                }
            }
            if (DockerAgentDeploymentImpl.this.getAgent().isConnected() && !DockerAgentDeploymentImpl.this.myConfig.isCreateContainerOnly()) {
                boolean attach = DockerAgentDeploymentImpl.safeValueOf(cmdConfig.isAttachStdin()) && DockerAgentDeploymentImpl.safeValueOf(cmdConfig.isStdinOpen());
                this.startContainer(containerId, containerName, attach);
            }
            return deployResult;
        }

        private void startContainer(@NotNull String containerId, @Nullable String containerName, boolean attach) throws IOException, ApiTaskException {
            InspectContainerResponse inspectResponse;
            if (containerId == null) {
                DeployTask.$$$reportNull$$$0(0);
            }
            DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Container Id: " + containerId, TtySink.Colors.BLUE);
            if ((containerName == null || containerName.isEmpty()) && (inspectResponse = DockerAgentDeploymentImpl.this.getClient().inspectContainerCmd(containerId).exec()) != null && inspectResponse.getName() != null) {
                containerName = inspectResponse.getName();
            }
            String containerMessageSuffix = this.safeQuote(containerName);
            DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Container name: " + containerMessageSuffix, TtySink.Colors.BLUE);
            if (attach) {
                DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Attaching to container " + containerMessageSuffix + "...", TtySink.Colors.BLUE);
                DockerAgentDeploymentImpl.this.doAttach(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler, true);
            } else {
                DockerAgentDeploymentImpl.this.doShowLog(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler);
            }
            DockerAgentDeploymentImpl.this.myBuildLogTtySink.coloredTtyPrintln("Starting container " + containerMessageSuffix, TtySink.Colors.BLUE);
            StartContainerCmd startContainerCmd = DockerAgentDeploymentImpl.this.getClient().startContainerCmd(containerId);
            startContainerCmd.exec();
        }

        @Nullable
        private String findPreviousContainer() {
            Predicate condition = null;
            String containerName = DockerAgentDeploymentImpl.this.myConfig.getContainerName();
            if (containerName != null && containerName.length() > 0) {
                condition = DockerAgentDeploymentImpl.withContainerName(containerName);
            } else if (DockerAgentDeploymentImpl.this.myConfig.getLabels() != null) {
                condition = Stream.of(DockerAgentDeploymentImpl.this.myConfig.getLabels()).filter(l -> "com.intellij.docker.source.run.configuration".equals(l.getKey())).findAny().map(label -> DockerAgentDeploymentImpl.withLabel("com.intellij.docker.source.run.configuration", label.getValue())).orElse(null);
            }
            if (condition == null) {
                return null;
            }
            return ((List)DockerAgentDeploymentImpl.this.getClient().listContainersCmd().withShowAll(Boolean.TRUE).exec()).stream().filter(condition).findAny().map(Container::getId).orElse(null);
        }

        protected abstract void setContainerId(String var1);

        protected abstract String doPrepareDeploy() throws IOException, ApiTaskException;

        protected abstract CreateContainerCmdConfig getContainerCmdConfig();

        protected abstract DockerAgentContainerConfigImpl getPriorityConfig();

        private String safeQuote(String text) {
            return text == null ? "" : "'" + text + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerId", "com/intellij/docker/agent/DockerAgentDeploymentImpl$DeployTask", "startContainer"));
        }
    }

    private static class BuildCallback
    extends TtySinkCallback<BuildResponseItem> {
        private String myImageId;
        private String myImageTag;

        BuildCallback(TtySink ttySink) {
            super(ttySink);
        }

        public void onNext(BuildResponseItem item) {
            DockerResponseItem.Impl wrappedItem = DockerResponseItem.fromAgentBuildItem((BuildResponseItem)item).build();
            this.getTtyHandler().handleItem((DockerResponseItem)wrappedItem);
            DockerResponseItem.AuxDetail aux = wrappedItem.getAux();
            if (aux != null) {
                if (aux.getTag() != null) {
                    this.myImageTag = aux.getTag();
                }
                if (aux.getDigest() != null) {
                    this.myImageId = aux.getDigest();
                }
            }
        }

        @Nullable
        String getBuiltImageId() {
            return this.myImageId;
        }

        @Nullable
        String getBuiltImageTag() {
            return this.myImageTag;
        }
    }
}

