/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.command.CreateContainerCmdImpl;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.settings.DockerLabel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CreateContainerCmdValueTransfers {
    public static ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmdConfig, CreateContainerCmd> createMergeForDeploy(Function<Bind[], Bind[]> bindsAdjuster) {
        return CreateContainerCmdValueTransfers.doCreateMerge(false, bindsAdjuster);
    }

    public static ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmdConfig, CreateContainerCmd> createMergeForUpdate(Function<Bind[], Bind[]> bindsAdjuster) {
        return CreateContainerCmdValueTransfers.doCreateMerge(true, bindsAdjuster);
    }

    private static ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmdConfig, CreateContainerCmd> doCreateMerge(boolean replaceNotCombineArrays, Function<Bind[], Bind[]> bindsAdjuster) {
        return new ValueTransfer.ValuesMerge<DockerAgentContainerConfigImpl, CreateContainerCmdConfig, CreateContainerCmd>(new FromUiValuesTransfer(replaceNotCombineArrays, bindsAdjuster), CreateContainerCmdValueTransfers.createContainerCmdValueTransfer(bindsAdjuster));
    }

    public static ValueTransfer<CreateContainerCmdConfig, CreateContainerCmd> createContainerCmdValueTransfer(Function<Bind[], Bind[]> bindsAdjuster) {
        return new CreateContainerCmdTransfer(bindsAdjuster);
    }

    static class CreateContainerCmdTransfer
    extends ValueTransfer.CompositeTransfer<CreateContainerCmdConfig, CreateContainerCmd> {
        private final ValueTransfer<HostConfig, HostConfig> myHostConfigTransfer;

        CreateContainerCmdTransfer(Function<Bind[], Bind[]> bindsAdjuster) {
            this.myHostConfigTransfer = new HostConfigValueTransfer(bindsAdjuster);
            this.mapIfNotNull(CreateContainerCmdImpl::getHostName, CreateContainerCmd::withHostName);
            this.mapIfNotNull(CreateContainerCmdImpl::getDomainName, CreateContainerCmd::withDomainName);
            this.mapIfNotNull(CreateContainerCmdImpl::getUser, CreateContainerCmd::withUser);
            this.mapIfNotNull(CreateContainerCmdImpl::isAttachStdin, CreateContainerCmd::withAttachStdin);
            this.mapIfNotNull(CreateContainerCmdImpl::isAttachStdout, CreateContainerCmd::withAttachStdout);
            this.mapIfNotNull(CreateContainerCmdImpl::isAttachStderr, CreateContainerCmd::withAttachStderr);
            this.mapIfNotNull(CreateContainerCmdImpl::getPortSpecs, CreateContainerCmd::withPortSpecs);
            this.mapIfNotNull(CreateContainerCmdImpl::isTty, CreateContainerCmd::withTty);
            this.mapIfNotNull(CreateContainerCmdImpl::isStdinOpen, CreateContainerCmd::withStdinOpen);
            this.mapIfNotNull(CreateContainerCmdImpl::isStdInOnce, CreateContainerCmd::withStdInOnce);
            this.mapIfNotNull(CreateContainerCmdImpl::getEnv, CreateContainerCmd::withEnv);
            this.mapIfNotNull(CreateContainerCmdImpl::getCmd, CreateContainerCmd::withCmd);
            this.mapIfNotNull(CreateContainerCmdImpl::getHealthcheck, CreateContainerCmd::withHealthcheck);
            this.mapIfNotNull(CreateContainerCmdImpl::getArgsEscaped, CreateContainerCmd::withArgsEscaped);
            this.mapIfNotNull(CreateContainerCmdImpl::getEntrypoint, CreateContainerCmd::withEntrypoint);
            this.mapIfNotNull(CreateContainerCmdImpl::getImage, CreateContainerCmd::withImage);
            this.mapIfNotNull(CreateContainerCmdImpl::getVolumes, CreateContainerCmd::withVolumes);
            this.mapIfNotNull(CreateContainerCmdImpl::getWorkingDir, CreateContainerCmd::withWorkingDir);
            this.mapIfNotNull(CreateContainerCmdImpl::getMacAddress, CreateContainerCmd::withMacAddress);
            this.mapIfNotNull(CreateContainerCmdImpl::getOnBuild, CreateContainerCmd::withOnBuild);
            this.mapIfNotNull(CreateContainerCmdImpl::isNetworkDisabled, CreateContainerCmd::withNetworkDisabled);
            this.mapIfNotNull(CreateContainerCmdImpl::getExposedPorts, CreateContainerCmd::withExposedPorts);
            this.mapIfNotNull(CreateContainerCmdImpl::getStopSignal, CreateContainerCmd::withStopSignal);
            this.mapIfNotNull(CreateContainerCmdImpl::getStopTimeout, CreateContainerCmd::withStopTimeout);
            this.mapIfNotNull(CreateContainerCmdImpl::getHostConfig, (cmd, hostConfig) -> {
                if (hostConfig != null) {
                    HostConfig copy = new HostConfig();
                    this.myHostConfigTransfer.transferFromTo((HostConfig)hostConfig, copy);
                    cmd.withHostConfig(copy);
                }
            });
            this.addValueTransfer(new ValueTransfer<CreateContainerCmdConfig, CreateContainerCmd>(){

                @Override
                public void transferFromTo(CreateContainerCmdConfig source, CreateContainerCmd target) {
                    Map sourceLabels = source.getLabels();
                    if (sourceLabels == null) {
                        return;
                    }
                    HashMap targetLabels = target.getLabels();
                    if (targetLabels == null) {
                        targetLabels = new HashMap();
                    }
                    targetLabels.putAll(sourceLabels);
                    target.withLabels(targetLabels);
                }
            });
            this.mapIfNotNull(CreateContainerCmdImpl::getIpv4Address, CreateContainerCmd::withIpv4Address);
            this.mapIfNotNull(CreateContainerCmdImpl::getIpv6Address, CreateContainerCmd::withIpv6Address);
            this.mapIfNotNull(CreateContainerCmdImpl::getAliases, CreateContainerCmd::withAliases);
        }
    }

    static class FromUiValuesTransfer
    extends ValueTransfer.CompositeTransfer<DockerAgentContainerConfigImpl, CreateContainerCmd> {
        FromUiValuesTransfer(boolean replaceNotCombineArrays, Function<Bind[], Bind[]> bindsAdjuster) {
            bindsAdjuster = bindsAdjuster == null ? Function.identity() : bindsAdjuster;
            Function<DockerAgentContainerConfigImpl, Bind[]> createCmdVolumeBindings = DockerAgentContainerConfigImpl::createCmdVolumeBindings;
            this.mergeHostConfigArrays(replaceNotCombineArrays, Bind.class, createCmdVolumeBindings.andThen(bindsAdjuster), HostConfig::getBinds, HostConfig::withBinds);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getUser, CreateContainerCmd::withUser);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getCommand, CreateContainerCmd::withCmd);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getEntrypoint, CreateContainerCmd::withEntrypoint);
            this.mergeArrays(replaceNotCombineArrays, String.class, DockerAgentContainerConfigImpl::createCmdEnvVars, CreateContainerCmd::getEnv, CreateContainerCmd::withEnv);
            this.mergeHostConfigArrays(replaceNotCombineArrays, String.class, DockerAgentContainerConfigImpl::getExtraHosts, HostConfig::getExtraHosts, HostConfig::withExtraHosts);
            this.mergeHostConfigArrays(replaceNotCombineArrays, Link.class, DockerAgentContainerConfigImpl::createCmdLinks, HostConfig::getLinks, HostConfig::withLinks);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getNetworkDisabled, CreateContainerCmd::withNetworkDisabled);
            this.mapFromHostConfig(DockerAgentContainerConfigImpl::getNetworkMode, HostConfig::withNetworkMode);
            this.mergeArrays(replaceNotCombineArrays, PortBinding.class, DockerAgentContainerConfigImpl::createCmdPortBindingsArray, FromUiValuesTransfer::getPortBindingsArray, (cmd, array) -> FromUiValuesTransfer.findOrCreateHostConfig(cmd).withPortBindings(array));
            this.mergeArrays(replaceNotCombineArrays, ExposedPort.class, DockerAgentContainerConfigImpl::createCmdExposedPorts, CreateContainerCmd::getExposedPorts, CreateContainerCmd::withExposedPorts);
            this.mapFromHostConfig(DockerAgentContainerConfigImpl::getPublishAllPorts, HostConfig::withPublishAllPorts);
            this.mergeArrays(replaceNotCombineArrays, Volume.class, DockerAgentContainerConfigImpl::createCmdVolumes, CreateContainerCmd::getVolumes, CreateContainerCmd::withVolumes);
            this.mergeHostConfigArrays(replaceNotCombineArrays, VolumesFrom.class, DockerAgentContainerConfigImpl::createCmdVolumesFrom, HostConfig::getVolumesFrom, HostConfig::withVolumesFrom);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getWorkingDir, CreateContainerCmd::withWorkingDir);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getContainerName, CreateContainerCmd::withName);
            this.mapIfNotNull(DockerAgentContainerConfigImpl::getStdinOnce, CreateContainerCmd::withStdInOnce);
            this.addValueTransfer(new ValueTransfer<DockerAgentContainerConfigImpl, CreateContainerCmd>(){

                @Override
                public void transferFromTo(DockerAgentContainerConfigImpl source, CreateContainerCmd target) {
                    DockerLabel[] sourceLabels = source.getLabels();
                    if (sourceLabels == null) {
                        return;
                    }
                    HashMap<String, String> targetLabels = target.getLabels();
                    if (targetLabels == null) {
                        targetLabels = new HashMap<String, String>();
                    }
                    for (DockerLabel next : sourceLabels) {
                        if (next.getKey() == null) continue;
                        targetLabels.put(next.getKey(), next.getValue());
                    }
                    target.withLabels(targetLabels);
                }
            });
        }

        private static HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
            if (cmd.getHostConfig() == null) {
                cmd.withHostConfig(new HostConfig());
            }
            return cmd.getHostConfig();
        }

        public <V> void mapFromHostConfig(Function<? super DockerAgentContainerConfigImpl, V> getter, BiConsumer<HostConfig, V> setter) {
            this.mapIfNotNull(getter, (cmd, value) -> setter.accept(FromUiValuesTransfer.findOrCreateHostConfig(cmd), value));
        }

        private <V> void mergeHostConfigArrays(boolean replaceNotCombine, Class<? extends V> valueClass, Function<? super DockerAgentContainerConfigImpl, V[]> sourceGetter, Function<HostConfig, V[]> hostConfigGetter, BiConsumer<HostConfig, V[]> hostConfigSetter) {
            this.mergeArrays(replaceNotCombine, valueClass, sourceGetter, cmd -> Optional.ofNullable(cmd.getHostConfig()).map(hostConfigGetter).orElse(null), (cmd, array) -> hostConfigSetter.accept(FromUiValuesTransfer.findOrCreateHostConfig(cmd), (V[])array));
        }

        private static PortBinding[] getPortBindingsArray(CreateContainerCmd cmd) {
            Ports ports = Optional.ofNullable(cmd.getHostConfig()).map(HostConfig::getPortBindings).orElse(null);
            if (ports == null) {
                return null;
            }
            LinkedList<PortBinding> result = new LinkedList<PortBinding>();
            for (Map.Entry entry : ports.getBindings().entrySet()) {
                ExposedPort port = (ExposedPort)entry.getKey();
                Ports.Binding[] bindings = (Ports.Binding[])entry.getValue();
                if (bindings == null) continue;
                for (Ports.Binding next : bindings) {
                    result.add(new PortBinding(next, port));
                }
            }
            return result.toArray(new PortBinding[0]);
        }
    }

    static class HostConfigValueTransfer
    extends ValueTransfer.CompositeTransfer<HostConfig, HostConfig> {
        HostConfigValueTransfer(Function<Bind[], Bind[]> bindsAdjuster) {
            if (bindsAdjuster == null) {
                bindsAdjuster = Function.identity();
            }
            Function<HostConfig, Bind[]> getBinds = HostConfig::getBinds;
            this.mapIfNotNull(getBinds.andThen(bindsAdjuster), HostConfig::setBinds);
            this.mapIfNotNull(HostConfig::getBlkioWeight, HostConfig::withBlkioWeight);
            this.mapIfNotNull(HostConfig::getBlkioWeightDevice, HostConfig::withBlkioWeightDevice);
            this.mapIfNotNull(HostConfig::getBlkioDeviceReadBps, HostConfig::withBlkioDeviceReadBps);
            this.mapIfNotNull(HostConfig::getBlkioDeviceWriteBps, HostConfig::withBlkioDeviceWriteBps);
            this.mapIfNotNull(HostConfig::getBlkioDeviceReadIOps, HostConfig::withBlkioDeviceReadIOps);
            this.mapIfNotNull(HostConfig::getBlkioDeviceWriteIOps, HostConfig::withBlkioDeviceWriteIOps);
            this.mapIfNotNull(HostConfig::getMemorySwappiness, HostConfig::withMemorySwappiness);
            this.mapIfNotNull(HostConfig::getNanoCPUs, HostConfig::withNanoCPUs);
            this.mapIfNotNull(HostConfig::getCapAdd, HostConfig::withCapAdd);
            this.mapIfNotNull(HostConfig::getCapDrop, HostConfig::withCapDrop);
            this.mapIfNotNull(HostConfig::getContainerIDFile, HostConfig::withContainerIDFile);
            this.mapIfNotNull(HostConfig::getCpuPeriod, HostConfig::withCpuPeriod);
            this.mapIfNotNull(HostConfig::getCpuRealtimePeriod, HostConfig::withCpuRealtimePeriod);
            this.mapIfNotNull(HostConfig::getCpuRealtimeRuntime, HostConfig::withCpuRealtimeRuntime);
            this.mapIfNotNull(HostConfig::getCpuShares, HostConfig::withCpuShares);
            this.mapIfNotNull(HostConfig::getCpuQuota, HostConfig::withCpuQuota);
            this.mapIfNotNull(HostConfig::getCpusetCpus, HostConfig::withCpusetCpus);
            this.mapIfNotNull(HostConfig::getCpusetMems, HostConfig::withCpusetMems);
            this.mapIfNotNull(HostConfig::getDevices, HostConfig::withDevices);
            this.mapIfNotNull(HostConfig::getDeviceCgroupRules, HostConfig::withDeviceCgroupRules);
            this.mapIfNotNull(HostConfig::getDeviceRequests, HostConfig::withDeviceRequests);
            this.mapIfNotNull(HostConfig::getDiskQuota, HostConfig::withDiskQuota);
            this.mapIfNotNull(HostConfig::getDns, HostConfig::withDns);
            this.mapIfNotNull(HostConfig::getDnsOptions, HostConfig::withDnsOptions);
            this.mapIfNotNull(HostConfig::getDnsSearch, HostConfig::withDnsSearch);
            this.mapIfNotNull(HostConfig::getExtraHosts, HostConfig::withExtraHosts);
            this.mapIfNotNull(HostConfig::getGroupAdd, HostConfig::withGroupAdd);
            this.mapIfNotNull(HostConfig::getIpcMode, HostConfig::withIpcMode);
            this.mapIfNotNull(HostConfig::getCgroup, HostConfig::withCgroup);
            this.mapIfNotNull(HostConfig::getLinks, HostConfig::setLinks);
            this.mapIfNotNull(HostConfig::getLogConfig, HostConfig::withLogConfig);
            this.mapIfNotNull(HostConfig::getLxcConf, HostConfig::withLxcConf);
            this.mapIfNotNull(HostConfig::getMemory, HostConfig::withMemory);
            this.mapIfNotNull(HostConfig::getMemorySwap, HostConfig::withMemorySwap);
            this.mapIfNotNull(HostConfig::getMemoryReservation, HostConfig::withMemoryReservation);
            this.mapIfNotNull(HostConfig::getKernelMemory, HostConfig::withKernelMemory);
            this.mapIfNotNull(HostConfig::getNetworkMode, HostConfig::withNetworkMode);
            this.mapIfNotNull(HostConfig::getOomKillDisable, HostConfig::withOomKillDisable);
            this.mapIfNotNull(HostConfig::getInit, HostConfig::withInit);
            this.mapIfNotNull(HostConfig::getAutoRemove, HostConfig::withAutoRemove);
            this.mapIfNotNull(HostConfig::getOomScoreAdj, HostConfig::withOomScoreAdj);
            this.mapIfNotNull(HostConfig::getPortBindings, HostConfig::withPortBindings);
            this.mapIfNotNull(HostConfig::getPrivileged, HostConfig::withPrivileged);
            this.mapIfNotNull(HostConfig::getPublishAllPorts, HostConfig::withPublishAllPorts);
            this.mapIfNotNull(HostConfig::getReadonlyRootfs, HostConfig::withReadonlyRootfs);
            this.mapIfNotNull(HostConfig::getRestartPolicy, HostConfig::withRestartPolicy);
            this.mapIfNotNull(HostConfig::getUlimits, HostConfig::withUlimits);
            this.mapIfNotNull(HostConfig::getCpuCount, HostConfig::withCpuCount);
            this.mapIfNotNull(HostConfig::getCpuPercent, HostConfig::withCpuPercent);
            this.mapIfNotNull(HostConfig::getIoMaximumIOps, HostConfig::withIoMaximumIOps);
            this.mapIfNotNull(HostConfig::getIoMaximumBandwidth, HostConfig::withIoMaximumBandwidth);
            this.mapIfNotNull(HostConfig::getVolumesFrom, HostConfig::withVolumesFrom);
            this.mapIfNotNull(HostConfig::getMounts, HostConfig::withMounts);
            this.mapIfNotNull(HostConfig::getPidMode, HostConfig::withPidMode);
            this.mapIfNotNull(HostConfig::getIsolation, HostConfig::withIsolation);
            this.mapIfNotNull(HostConfig::getSecurityOpts, HostConfig::withSecurityOpts);
            this.mapIfNotNull(HostConfig::getStorageOpt, HostConfig::withStorageOpt);
            this.mapIfNotNull(HostConfig::getCgroupParent, HostConfig::withCgroupParent);
            this.mapIfNotNull(HostConfig::getVolumeDriver, HostConfig::withVolumeDriver);
            this.mapIfNotNull(HostConfig::getShmSize, HostConfig::withShmSize);
            this.mapIfNotNull(HostConfig::getPidsLimit, HostConfig::withPidsLimit);
            this.mapIfNotNull(HostConfig::getRuntime, HostConfig::withRuntime);
            this.mapIfNotNull(HostConfig::getTmpFs, HostConfig::withTmpFs);
            this.mapIfNotNull(HostConfig::getUtSMode, HostConfig::withUtSMode);
            this.mapIfNotNull(HostConfig::getUsernsMode, HostConfig::withUsernsMode);
            this.mapIfNotNull(HostConfig::getSysctls, HostConfig::withSysctls);
            this.mapIfNotNull(HostConfig::getConsoleSize, HostConfig::withConsoleSize);
        }
    }
}

