/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.Animator;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FadeInFadeOut
extends JComponent {
    public static final Integer LAYER = new Integer(JLayeredPane.POPUP_LAYER + 1);
    public static final int TOTAL_FRAMES = 10;
    @NotNull
    private final Component myComponent;
    private final BufferedImage myComponentImage;
    private Rectangle myComponentBounds;
    @Nullable
    private final Component myIcon;
    private Rectangle myIconBounds;
    private final boolean myFadeIn;
    private boolean myTriggered;
    private double myRatio;
    private final Animator myAnimator;
    private Runnable myOnDone;

    public FadeInFadeOut(@NotNull Component component, int timeToComplete, boolean fadeIn, @Nullable Component icon) {
        if (component == null) {
            FadeInFadeOut.$$$reportNull$$$0(0);
        }
        this.myTriggered = false;
        this.myRatio = 0.0;
        this.myOnDone = null;
        this.setFocusable(false);
        this.myComponent = component;
        this.myFadeIn = fadeIn;
        this.myRatio = this.myFadeIn ? 0.0 : 1.0;
        this.myIcon = icon;
        this.myComponentImage = UIUtil.createImage((Component)this.myComponent, (int)this.myComponent.getWidth(), (int)this.myComponent.getHeight(), (int)2);
        Graphics2D graphics = this.myComponentImage.createGraphics();
        this.myComponent.paint(graphics);
        graphics.dispose();
        this.myAnimator = new Animator("FadeInFadeOut", 10, timeToComplete, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                double linearProgress = Math.max(0.0, Math.min(1.0, (double)frame / (double)totalFrames));
                if (!FadeInFadeOut.this.myFadeIn) {
                    linearProgress = 1.0 - linearProgress;
                }
                FadeInFadeOut.this.myRatio = (1.0 - Math.cos(Math.PI * linearProgress)) / 2.0;
                FadeInFadeOut.this.paintImmediately(0, 0, FadeInFadeOut.this.getWidth(), FadeInFadeOut.this.getHeight());
            }

            @Override
            protected void paintCycleEnd() {
                super.paintCycleEnd();
                if (FadeInFadeOut.this.myOnDone != null) {
                    FadeInFadeOut.this.myOnDone.run();
                }
            }
        };
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        if (!this.myTriggered) {
            this.myComponentBounds = SwingUtilities.convertRectangle(this.myComponent.getParent(), this.myComponent.getBounds(), this);
            this.myIconBounds = this.myIcon == null ? this.myComponentBounds : SwingUtilities.convertRectangle(this.myIcon.getParent(), this.myIcon.getBounds(), this);
        }
    }

    public void doAnimation(Runnable onDone) {
        this.myOnDone = onDone;
        if (this.myTriggered || !this.isShowing()) {
            return;
        }
        this.myTriggered = true;
        this.myAnimator.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paint(Graphics g_) {
        int x = (int)((double)this.myIconBounds.x * (1.0 - this.myRatio) + (double)this.myComponentBounds.x * this.myRatio);
        int y = (int)((double)this.myIconBounds.y * (1.0 - this.myRatio) + (double)this.myComponentBounds.y * this.myRatio);
        int width = (int)((double)this.myIconBounds.width * (1.0 - this.myRatio) + (double)this.myComponentBounds.width * this.myRatio);
        int height = (int)((double)this.myIconBounds.height * (1.0 - this.myRatio) + (double)this.myComponentBounds.height * this.myRatio);
        Graphics2D g = (Graphics2D)g_.create();
        try {
            g.setComposite(AlphaComposite.getInstance(3, 0.5f + (float)(this.myRatio / 2.0)));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g.drawImage(this.myComponentImage, x, y, width, height, this);
        }
        finally {
            g.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/FadeInFadeOut", "<init>"));
    }
}

