/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BaseBusConnection;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.annotations.NotNull;

final class MessageBusConnectionImpl
extends BaseBusConnection
implements MessageBusConnection {
    private MessageHandler defaultHandler;

    MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(0);
        }
        super(bus);
    }

    public <L> void subscribe(@NotNull Topic<L> topic) throws IllegalStateException {
        MessageHandler defaultHandler;
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(1);
        }
        if ((defaultHandler = this.defaultHandler) == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        if (topic.getListenerClass().isInstance(defaultHandler)) {
            throw new IllegalStateException("Can't subscribe to the topic '" + topic + "'. Default handler has incompatible type - expected: '" + topic.getListenerClass() + "', actual: '" + defaultHandler.getClass() + "'");
        }
        this.subscribe(topic, defaultHandler);
    }

    public void setDefaultHandler(MessageHandler handler) {
        this.defaultHandler = handler;
    }

    public void dispose() {
        MessageBusImpl bus = this.bus;
        if (bus == null) {
            return;
        }
        this.bus = null;
        this.defaultHandler = null;
        bus.notifyConnectionTerminated(this.subscriptions.getAndSet(ArrayUtilRt.EMPTY_OBJECT_ARRAY));
    }

    @Override
    public void disconnect() {
        Disposer.dispose((Disposable)this);
    }

    public void deliverImmediately() {
        this.bus.deliverImmediately(this);
    }

    static boolean removeHandlersFromJob(@NotNull Message<?> job, Object @NotNull [] topicAndHandlerPairs) {
        if (job == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(2);
        }
        if (topicAndHandlerPairs == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(3);
        }
        return job.handlers.removeIf(handler -> {
            for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
                if (job.topic != topicAndHandlerPairs[i] || handler != topicAndHandlerPairs[i + 1]) continue;
                return true;
            }
            return false;
        });
    }

    <L> boolean isMyHandler(@NotNull Topic<L> topic, @NotNull L handler) {
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(4);
        }
        if (handler == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(5);
        }
        if (this.defaultHandler == handler) {
            return true;
        }
        Object[] topicAndHandlerPairs = (Object[])this.subscriptions.get();
        int n = topicAndHandlerPairs.length;
        for (int i = 0; i < n; i += 2) {
            if (topic != topicAndHandlerPairs[i] || handler != topicAndHandlerPairs[i + 1]) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topicAndHandlerPairs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/messages/impl/MessageBusConnectionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribe";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHandlersFromJob";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

