/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.usages.UsageView;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

abstract class Node
extends DefaultMutableTreeNode {
    private int myCachedTextHash;
    private byte myCachedFlags;
    private static final byte CACHED_INVALID_MASK = 1;
    private static final byte CACHED_READ_ONLY_MASK = 2;
    private static final byte READ_ONLY_COMPUTED_MASK = 4;
    static final byte EXCLUDED_MASK = 8;
    private static final byte UPDATED_MASK = 16;
    private static final byte FORCE_UPDATE_REQUESTED_MASK = 32;
    private static final byte STRUCTURAL_CHANGE_DETECTED_IN_PATH_MASK = 64;

    private synchronized boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet((byte)this.myCachedFlags, (byte)mask);
    }

    private synchronized void setFlag(@FlagConstant byte mask, boolean value) {
        this.myCachedFlags = BitUtil.set((byte)this.myCachedFlags, (byte)mask, (boolean)value);
    }

    Node() {
    }

    @TestOnly
    abstract String tree2string(int var1, @NotNull String var2);

    protected abstract boolean isDataValid();

    protected abstract boolean isDataReadOnly();

    protected abstract boolean isDataExcluded();

    protected void updateCachedPresentation() {
    }

    @NotNull
    protected abstract String getText(@NotNull UsageView var1);

    final boolean isValid() {
        return !this.isFlagSet((byte)1);
    }

    final boolean isReadOnly() {
        boolean result;
        boolean computed = this.isFlagSet((byte)4);
        if (computed) {
            result = this.isFlagSet((byte)2);
        } else {
            result = this.isDataReadOnly();
            this.setFlag((byte)4, true);
            this.setFlag((byte)2, result);
        }
        return result;
    }

    final boolean isExcluded() {
        return this.isFlagSet((byte)8);
    }

    final void update(@NotNull UsageView view, @NotNull Consumer<? super Node> edtFireTreeNodesChangedQueue) {
        if (view == null) {
            Node.$$$reportNull$$$0(0);
        }
        if (edtFireTreeNodesChangedQueue == null) {
            Node.$$$reportNull$$$0(1);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        boolean isDataValid = this.isDataValid();
        boolean isReadOnly = this.isDataReadOnly();
        String text = this.getText(view);
        this.updateCachedPresentation();
        this.doUpdate(isDataValid, isReadOnly, text, edtFireTreeNodesChangedQueue);
    }

    private synchronized void doUpdate(boolean isDataValid, boolean isReadOnly, @NotNull String text, @NotNull Consumer<? super Node> edtFireTreeNodesChangedQueue) {
        if (text == null) {
            Node.$$$reportNull$$$0(2);
        }
        if (edtFireTreeNodesChangedQueue == null) {
            Node.$$$reportNull$$$0(3);
        }
        boolean cachedValid = this.isValid();
        boolean cachedReadOnly = this.isFlagSet((byte)2);
        if (isDataValid != cachedValid || isReadOnly != cachedReadOnly || this.myCachedTextHash != text.hashCode() || this.isFlagSet((byte)32)) {
            this.setFlag((byte)1, !isDataValid);
            this.setFlag((byte)2, isReadOnly);
            this.setFlag((byte)32, false);
            this.myCachedTextHash = text.hashCode();
            this.updateNotify();
            edtFireTreeNodesChangedQueue.consume((Object)this);
        }
        this.setFlag((byte)16, true);
    }

    void markNeedUpdate() {
        this.setFlag((byte)16, false);
    }

    boolean needsUpdate() {
        return !this.isFlagSet((byte)16);
    }

    void forceUpdate() {
        this.setFlag((byte)32, true);
    }

    protected void updateNotify() {
    }

    void insertNewNode(@NotNull Node newChild, int childIndex) {
        if (newChild == null) {
            Node.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    void setExcluded(boolean excluded, @NotNull Consumer<? super Node> edtFireTreeNodesChangedQueue) {
        if (edtFireTreeNodesChangedQueue == null) {
            Node.$$$reportNull$$$0(5);
        }
        this.setFlag((byte)8, excluded);
        edtFireTreeNodesChangedQueue.consume((Object)this);
    }

    public boolean isStructuralChangeDetected() {
        return this.isFlagSet((byte)64);
    }

    public void setStructuralChangeDetected(boolean valid) {
        this.setFlag((byte)64, valid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtFireTreeNodesChangedQueue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/Node";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertNewNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setExcluded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static @interface FlagConstant {
    }
}

