/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public final class ScrollPaneFactory
implements ScrollPaneConstants {
    private ScrollPaneFactory() {
    }

    @NotNull
    public static JScrollPane createScrollPane() {
        return new JBScrollPane();
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view) {
        return new JBScrollPane(view);
    }

    @NotNull
    public static JScrollPane createScrollPane(@JdkConstants.VerticalScrollBarPolicy int vsbPolicy, @JdkConstants.HorizontalScrollBarPolicy int hsbPolicy) {
        return new JBScrollPane(vsbPolicy, hsbPolicy);
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view, @JdkConstants.VerticalScrollBarPolicy int vsbPolicy, @JdkConstants.HorizontalScrollBarPolicy int hsbPolicy) {
        return new JBScrollPane(view, vsbPolicy, hsbPolicy);
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view, boolean withoutBorder) {
        JBScrollPane scrollPane = new JBScrollPane(view);
        if (withoutBorder) {
            scrollPane.setBorder((Border)JBUI.Borders.empty());
            scrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        }
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            ScrollPaneFactory.$$$reportNull$$$0(0);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view, int borders) {
        JBScrollPane scrollPane = new JBScrollPane(view);
        scrollPane.setBorder(IdeBorderFactory.createBorder(borders));
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            ScrollPaneFactory.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ScrollPaneFactory", "createScrollPane"));
    }
}

