/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContent
extends DiffContent {
    @NotNull
    private final VirtualFile myFile;
    private Document myDocument;
    private final Project myProject;
    private final FileType myType;

    public FileContent(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            FileContent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myFile = file;
        this.myType = file.getFileType();
    }

    @Override
    public Document getDocument() {
        if (this.myDocument == null && DiffContentUtil.isTextFile(this.myFile)) {
            this.myDocument = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(this.myFile));
        }
        return this.myDocument;
    }

    @Override
    public Navigatable getOpenFileDescriptor(int offset) {
        return PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myFile, offset);
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            FileContent.$$$reportNull$$$0(1);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        return this.myType;
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        return this.myFile.contentsToByteArray();
    }

    @Override
    public boolean isBinary() {
        return !this.myFile.isDirectory() && this.myType.isBinary();
    }

    @Override
    @NotNull
    public LineSeparator getLineSeparator() {
        LineSeparator lineSeparator = LineSeparator.fromString((String)FileDocumentManager.getInstance().getLineSeparator(this.myFile, this.myProject));
        if (lineSeparator == null) {
            FileContent.$$$reportNull$$$0(2);
        }
        return lineSeparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/FileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/FileContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

