/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.MutableVariableWithConstraints$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.model.OnlyInputTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\tJ*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\t2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J!\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0%H\u0000\u00a2\u0006\u0002\b&J!\u0010'\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0%H\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020*H\u0016J\f\u0010+\u001a\u00020\u001b*\u00020\tH\u0002J\u0014\u0010,\u001a\u00020\u001b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\u000e*\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u000e*\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0018\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0\u000e*\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\t0\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/model/MutableVariableWithConstraints;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "(Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;)V", "other", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;)V", "constraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "(Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;Ljava/util/List;)V", "getConstraints", "()Ljava/util/List;", "mutableConstraints", "Lorg/jetbrains/kotlin/utils/SmartList;", "kotlin.jvm.PlatformType", "projectedInputCallTypes", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "getProjectedInputCallTypes", "()Ljava/util/Collection;", "simplifiedConstraints", "getTypeVariable", "()Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "addConstraint", "constraint", "isUsefulConstraint", "", "equalityConstraints", "", "", "newConstraintIsUseless", "old", "new", "removeConstrains", "", "shouldRemove", "Lkotlin/Function1;", "removeConstrains$resolution", "removeLastConstraints", "removeLastConstraints$resolution", "toString", "", "isLowerAndFlexibleTypeWithDefNotNullLowerBound", "isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound", "simplifyConstraints", "simplifyEqualityConstraints", "simplifyLowerConstraints", "resolution"})
public final class MutableVariableWithConstraints
implements VariableWithConstraints {
    private final SmartList<Constraint> mutableConstraints;
    private SmartList<Constraint> simplifiedConstraints;
    @NotNull
    private final TypeVariableMarker typeVariable;

    @Override
    @NotNull
    public List<Constraint> getConstraints() {
        if (this.simplifiedConstraints == null) {
            this.simplifiedConstraints = this.simplifyConstraints(this.mutableConstraints);
        }
        SmartList<Constraint> smartList = this.simplifiedConstraints;
        Intrinsics.checkNotNull(smartList);
        return smartList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<UnwrappedType> getProjectedInputCallTypes() {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Iterable iterable = this.mutableConstraints;
        Collection destination$iv = new SmartList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            UnwrappedType unwrappedType;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Constraint it = (Constraint)element$iv;
            boolean bl2 = false;
            if (it.getPosition().getFrom() instanceof OnlyInputTypeConstraintPosition || it.getInputTypePositionBeforeIncorporation() != null) {
                KotlinTypeMarker kotlinTypeMarker = it.getType();
                if (kotlinTypeMarker == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.types.KotlinType");
                }
                unwrappedType = TypeUtilsKt.unCapture((KotlinType)kotlinTypeMarker).unwrap();
            } else {
                unwrappedType = null;
            }
            if (unwrappedType == null) continue;
            UnwrappedType unwrappedType2 = unwrappedType;
            boolean bl3 = false;
            boolean bl4 = false;
            UnwrappedType it$iv = unwrappedType2;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        return var2_2;
    }

    @Nullable
    public final Constraint addConstraint(@NotNull Constraint constraint) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        boolean isLowerAndFlexibleTypeWithDefNotNullLowerBound = this.isLowerAndFlexibleTypeWithDefNotNullLowerBound(constraint);
        for (Constraint previousConstraint : this.getConstraints()) {
            if (previousConstraint.getTypeHashCode() == constraint.getTypeHashCode() && Intrinsics.areEqual((Object)previousConstraint.getType(), (Object)constraint.getType()) && previousConstraint.isNullabilityConstraint() == constraint.isNullabilityConstraint()) {
                boolean bl;
                if (this.newConstraintIsUseless(previousConstraint, constraint)) {
                    return null;
                }
                switch (MutableVariableWithConstraints$WhenMappings.$EnumSwitchMapping$0[previousConstraint.getKind().ordinal()]) {
                    case 1: {
                        bl = constraint.getKind().isUpper();
                        break;
                    }
                    case 2: {
                        bl = constraint.getKind().isLower();
                        break;
                    }
                    case 3: {
                        bl = true;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean isMatchingForSimplification = bl;
                if (isMatchingForSimplification) {
                    Constraint actualConstraint = new Constraint(ConstraintKind.EQUALITY, constraint.getType(), constraint.getPosition(), constraint.getTypeHashCode(), constraint.getDerivedFrom(), false, null, 64, null);
                    this.mutableConstraints.add(actualConstraint);
                    this.simplifiedConstraints = null;
                    return actualConstraint;
                }
            }
            if (!isLowerAndFlexibleTypeWithDefNotNullLowerBound || !this.isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound(previousConstraint, constraint)) continue;
            return null;
        }
        this.mutableConstraints.add(constraint);
        if (this.simplifiedConstraints != null && this.simplifiedConstraints != this.mutableConstraints) {
            SmartList<Constraint> smartList = this.simplifiedConstraints;
            Intrinsics.checkNotNull(smartList);
            smartList.add(constraint);
        }
        if (this.simplifiedConstraints != null && isLowerAndFlexibleTypeWithDefNotNullLowerBound) {
            this.simplifiedConstraints = null;
        }
        return constraint;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeLastConstraints$resolution(@NotNull Function1<? super Constraint, Boolean> shouldRemove2) {
        int n;
        List list2;
        block2: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter(shouldRemove2, (String)"shouldRemove");
            List list3 = this.mutableConstraints;
            list2 = this.mutableConstraints;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Constraint it = (Constraint)iterator$iv.previous();
                boolean bl = false;
                Constraint constraint = it;
                Intrinsics.checkNotNullExpressionValue((Object)constraint, (String)"it");
                if (!((Boolean)shouldRemove2.invoke((Object)constraint) == false)) continue;
                n = iterator$iv.nextIndex();
                break block2;
            }
            n = -1;
        }
        int n2 = n;
        InferenceUtilsKt.trimToSize(list2, n2 + 1);
        if (this.simplifiedConstraints != this.mutableConstraints) {
            this.simplifiedConstraints = null;
        }
    }

    public final void removeConstrains$resolution(@NotNull Function1<? super Constraint, Boolean> shouldRemove2) {
        Intrinsics.checkNotNullParameter(shouldRemove2, (String)"shouldRemove");
        CollectionsKt.removeAll((List)this.mutableConstraints, shouldRemove2);
        if (this.simplifiedConstraints != this.mutableConstraints) {
            this.simplifiedConstraints = null;
        }
    }

    private final boolean newConstraintIsUseless(Constraint old, Constraint constraint) {
        boolean bl;
        if (old.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition && !(constraint.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition)) {
            return false;
        }
        switch (MutableVariableWithConstraints$WhenMappings.$EnumSwitchMapping$1[old.getKind().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = constraint.getKind().isLower();
                break;
            }
            case 3: {
                bl = constraint.getKind().isUpper();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final SmartList<Constraint> simplifyConstraints(SmartList<Constraint> $this$simplifyConstraints) {
        return this.simplifyEqualityConstraints(this.simplifyLowerConstraints($this$simplifyConstraints));
    }

    private final SmartList<Constraint> simplifyLowerConstraints(SmartList<Constraint> $this$simplifyLowerConstraints) {
        SmartList<Constraint> usefulConstraints = new SmartList<Constraint>();
        Iterator<Constraint> iterator2 = $this$simplifyLowerConstraints.iterator();
        while (iterator2.hasNext()) {
            boolean thereIsStrongerConstraint;
            boolean bl;
            Constraint constraint;
            block5: {
                Constraint constraint2 = constraint = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)constraint2, (String)"constraint");
                if (!this.isLowerAndFlexibleTypeWithDefNotNullLowerBound(constraint2)) {
                    usefulConstraints.add(constraint);
                    continue;
                }
                Iterable $this$any$iv = $this$simplifyLowerConstraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint it = (Constraint)element$iv;
                        boolean bl2 = false;
                        Constraint constraint3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)constraint3, (String)"it");
                        if (!this.isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound(constraint3, constraint)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (thereIsStrongerConstraint = bl) continue;
            usefulConstraints.add(constraint);
        }
        return usefulConstraints;
    }

    private final boolean isLowerAndFlexibleTypeWithDefNotNullLowerBound(Constraint $this$isLowerAndFlexibleTypeWithDefNotNullLowerBound) {
        return $this$isLowerAndFlexibleTypeWithDefNotNullLowerBound.getKind() == ConstraintKind.LOWER && $this$isLowerAndFlexibleTypeWithDefNotNullLowerBound.getType() instanceof FlexibleType && SpecialTypesKt.isDefinitelyNotNullType(((FlexibleType)$this$isLowerAndFlexibleTypeWithDefNotNullLowerBound.getType()).getLowerBound());
    }

    private final boolean isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound(Constraint $this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound, Constraint other) {
        if ($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound == other) {
            return false;
        }
        if ($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getTypeHashCode() != other.getTypeHashCode() || $this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getKind() == ConstraintKind.UPPER) {
            return false;
        }
        if (!($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getType() instanceof FlexibleType)) {
            return false;
        }
        KotlinTypeMarker kotlinTypeMarker = other.getType();
        if (!(kotlinTypeMarker instanceof FlexibleType)) {
            kotlinTypeMarker = null;
        }
        FlexibleType flexibleType = (FlexibleType)kotlinTypeMarker;
        if (flexibleType == null) {
            return false;
        }
        FlexibleType otherFlexibleType = flexibleType;
        SimpleType simpleType2 = otherFlexibleType.getLowerBound();
        if (!(simpleType2 instanceof DefinitelyNotNullType)) {
            simpleType2 = null;
        }
        DefinitelyNotNullType definitelyNotNullType = (DefinitelyNotNullType)simpleType2;
        if (definitelyNotNullType == null) {
            return false;
        }
        DefinitelyNotNullType otherLowerBound = definitelyNotNullType;
        SimpleType otherUpperBound = otherFlexibleType.getUpperBound();
        return Intrinsics.areEqual((Object)((FlexibleType)$this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getType()).getLowerBound(), (Object)otherLowerBound.getOriginal()) && Intrinsics.areEqual((Object)((FlexibleType)$this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getType()).getUpperBound(), (Object)otherUpperBound);
    }

    /*
     * WARNING - void declaration
     */
    private final SmartList<Constraint> simplifyEqualityConstraints(SmartList<Constraint> $this$simplifyEqualityConstraints) {
        SmartList smartList;
        void $this$groupByTo$iv$iv;
        Constraint it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$simplifyEqualityConstraints;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ConstraintKind.EQUALITY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getTypeHashCode();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object equalityConstraints = destination$iv$iv;
        if (equalityConstraints.isEmpty()) {
            smartList = $this$simplifyEqualityConstraints;
        } else {
            void $this$filterTo$iv;
            $this$groupBy$iv = $this$simplifyEqualityConstraints;
            Collection destination$iv = new SmartList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv : $this$filterTo$iv) {
                Constraint it2 = (Constraint)element$iv;
                boolean bl = false;
                Constraint constraint = it2;
                Intrinsics.checkNotNullExpressionValue((Object)constraint, (String)"it");
                if (!this.isUsefulConstraint(constraint, (Map<Integer, ? extends List<Constraint>>)equalityConstraints)) continue;
                destination$iv.add(element$iv);
            }
            smartList = (SmartList)destination$iv;
        }
        return smartList;
    }

    private final boolean isUsefulConstraint(Constraint constraint, Map<Integer, ? extends List<Constraint>> equalityConstraints) {
        boolean bl;
        block6: {
            if (constraint.getKind() == ConstraintKind.EQUALITY) {
                return true;
            }
            List<Constraint> list2 = equalityConstraints.get(constraint.getTypeHashCode());
            if (list2 != null) {
                Iterable $this$none$iv = list2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Constraint it = (Constraint)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)constraint.getType())) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "Constraints for " + this.getTypeVariable();
    }

    @Override
    @NotNull
    public TypeVariableMarker getTypeVariable() {
        return this.typeVariable;
    }

    private MutableVariableWithConstraints(TypeVariableMarker typeVariable2, List<Constraint> constraints) {
        this.typeVariable = typeVariable2;
        this.mutableConstraints = constraints == null ? new SmartList() : new SmartList(constraints);
        this.simplifiedConstraints = this.mutableConstraints;
    }

    public MutableVariableWithConstraints(@NotNull TypeVariableMarker typeVariable2) {
        Intrinsics.checkNotNullParameter((Object)typeVariable2, (String)"typeVariable");
        this(typeVariable2, null);
    }

    public MutableVariableWithConstraints(@NotNull VariableWithConstraints other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this(other.getTypeVariable(), other.getConstraints());
    }
}

