/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt$configureStandardLibs$2;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt$configureStandardLibs$3;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\r\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0004*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0015"}, d2={"addModularRootIfNotNull", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "isModularJava", "", "moduleName", "", "file", "Ljava/io/File;", "configureAdvancedJvmOptions", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configureExplicitContentRoots", "configureJdkHome", "configureKlibPaths", "configureStandardLibs", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "registerJavacIfNeeded", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setupJvmSpecificArguments", "cli"})
public final class JvmArgumentsKt {
    public static final void setupJvmSpecificArguments(@NotNull CompilerConfiguration $receiver, @NotNull K2JVMCompilerArguments arguments2) {
        JvmDefaultMode jvmDefaultMode;
        JvmTarget jvmTarget;
        JvmTarget jvmTarget2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        MessageCollector messageCollector = $receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        $receiver.put(JVMConfigurationKeys.INCLUDE_RUNTIME, arguments2.getIncludeRuntime());
        Object[] objectArray = arguments2.getFriendPaths();
        $receiver.putIfNotNull(JVMConfigurationKeys.FRIEND_PATHS, objectArray != null ? ArraysKt.asList((Object[])objectArray) : null);
        if (arguments2.getJvmTarget() != null) {
            String string2 = arguments2.getJvmTarget();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if ((jvmTarget2 = JvmTarget.Companion.fromString(string2)) != null) {
                $receiver.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget2);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + arguments2.getJvmTarget() + '\n' + "Supported versions: " + ArraysKt.joinToString$default((Object[])JvmTarget.values(), null, null, null, (int)0, null, (Function1)setupJvmSpecificArguments.1.INSTANCE, (int)31, null), null, 4, null);
            }
        }
        if ((jvmTarget = $receiver.get(JVMConfigurationKeys.JVM_TARGET)) == null) {
            jvmTarget = jvmTarget2 = JvmTarget.DEFAULT;
        }
        if (jvmTarget2.getBytecodeVersion() < JvmTarget.JVM_1_8.getBytecodeVersion() && (jvmDefaultMode = CommonConfigurationKeysKt.getLanguageVersionSettings($receiver).getFlag(JvmAnalysisFlags.getJvmDefaultMode())).getForAllMethodsWithBody()) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "'-Xjvm-default=" + jvmDefaultMode.getDescription() + "' is only supported since JVM target 1.8. Recompile with '-jvm-target 1.8'", null, 4, null);
        }
        Object[] objectArray2 = arguments2.getAdditionalJavaModules();
        $receiver.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, objectArray2 != null ? ArraysKt.asList((Object[])objectArray2) : null);
    }

    public static final boolean configureJdkHome(@NotNull CompilerConfiguration $receiver, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        MessageCollector messageCollector = $receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getNoJdk()) {
            $receiver.put(JVMConfigurationKeys.NO_JDK, true);
            if (arguments2.getJdkHome() != null) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
            }
            return true;
        }
        if (arguments2.getJdkHome() != null) {
            File jdkHome = new File(arguments2.getJdkHome());
            if (!jdkHome.exists()) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "JDK home directory does not exist: " + jdkHome, null, 4, null);
                return false;
            }
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "Using JDK home directory " + jdkHome, null, 4, null);
            $receiver.put(JVMConfigurationKeys.JDK_HOME, jdkHome);
        }
        return true;
    }

    public static final void configureExplicitContentRoots(@NotNull CompilerConfiguration $receiver, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getJavaModulePath();
        List list2 = string2 != null ? StringsKt.split$default((CharSequence)string2, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null) : null;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        for (String modularRoot : list3) {
            $receiver.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
        }
        if (arguments2.getBuildFile() != null) {
            return;
        }
        String string3 = arguments2.getClasspath();
        list2 = string3 != null ? StringsKt.split$default((CharSequence)string3, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null) : null;
        bl = false;
        List list4 = list2;
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        for (String path2 : list4) {
            $receiver.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path2)));
        }
    }

    public static final void configureStandardLibs(@NotNull CompilerConfiguration $receiver, @Nullable KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        MessageCollector messageCollector = $receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        boolean isModularJava = JvmArgumentsKt.isModularJava($receiver);
        Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit> $fun$addRoot$1 = new Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit>($receiver, isModularJava, paths, messageCollector){
            final /* synthetic */ CompilerConfiguration receiver$0;
            final /* synthetic */ boolean $isModularJava;
            final /* synthetic */ KotlinPaths $paths;
            final /* synthetic */ MessageCollector $messageCollector;

            public final void invoke(@NotNull String moduleName, @NotNull String libraryName2, @NotNull Function1<? super KotlinPaths, ? extends File> getLibrary, @NotNull String noLibraryArgument) {
                Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
                Intrinsics.checkParameterIsNotNull((Object)libraryName2, (String)"libraryName");
                Intrinsics.checkParameterIsNotNull(getLibrary, (String)"getLibrary");
                Intrinsics.checkParameterIsNotNull((Object)noLibraryArgument, (String)"noLibraryArgument");
                MessageCollector messageCollector = this.$messageCollector;
                Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector, (String)"messageCollector");
                JvmArgumentsKt.addModularRootIfNotNull(this.receiver$0, this.$isModularJava, moduleName, UtilsKt.getLibraryFromHome(this.$paths, getLibrary, libraryName2, messageCollector, noLibraryArgument));
            }
            {
                this.receiver$0 = compilerConfiguration;
                this.$isModularJava = bl;
                this.$paths = kotlinPaths;
                this.$messageCollector = messageCollector;
                super(4);
            }
        };
        if (!arguments2.getNoStdlib()) {
            $fun$addRoot$1.invoke("kotlin.stdlib", "kotlin-stdlib.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)JvmArgumentsKt$configureStandardLibs$2.INSTANCE), "'-no-stdlib'");
            $fun$addRoot$1.invoke("kotlin.script.runtime", "kotlin-script-runtime.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)JvmArgumentsKt$configureStandardLibs$3.INSTANCE), "'-no-stdlib'");
        }
        if (!arguments2.getNoReflect() && !arguments2.getNoStdlib()) {
            $fun$addRoot$1.invoke("kotlin.reflect", "kotlin-reflect.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)configureStandardLibs.4.INSTANCE), "'-no-reflect' or '-no-stdlib'");
        }
    }

    public static final boolean isModularJava(@NotNull CompilerConfiguration $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        File file2 = $receiver.get(JVMConfigurationKeys.JDK_HOME);
        if (file2 != null) {
            File file3 = file2;
            boolean bl2 = false;
            boolean bl3 = false;
            File it = file3;
            boolean bl4 = false;
            File file4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it");
            bl = CoreJrtFileSystem.Companion.isModularJdk(file4);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final void addModularRootIfNotNull(@NotNull CompilerConfiguration $receiver, boolean isModularJava, @NotNull String moduleName, @Nullable File file2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        if (file2 != null) {
            if (isModularJava) {
                $receiver.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file2));
                $receiver.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
            } else {
                $receiver.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file2));
            }
        }
    }

    public static final boolean registerJavacIfNeeded(@NotNull KotlinCoreEnvironment $receiver, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        if (arguments2.getUseJavac()) {
            $receiver.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments2.getCompileJava()) {
                $receiver.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default($receiver, null, null, arguments2.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureAdvancedJvmOptions(@NotNull CompilerConfiguration $receiver, @NotNull K2JVMCompilerArguments arguments2) {
        block7: {
            JVMAssertionsMode jVMAssertionsMode;
            JVMAssertionsMode assertionsMode;
            JVMConstructorCallNormalizationMode constructorCallNormalizationMode;
            String string2;
            Collection<String> collection;
            JVMAssertionsMode[] $this$mapTo$iv$iv;
            String string3;
            MessageCollector messageCollector;
            CompilerMessageSeverity compilerMessageSeverity;
            StringBuilder stringBuilder2;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
            $receiver.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments2.getJavaParameters());
            $receiver.put(JVMConfigurationKeys.IR, arguments2.getUseIR() && !arguments2.getNoUseIR());
            $receiver.put(JVMConfigurationKeys.IS_IR_WITH_STABLE_ABI, arguments2.isIrWithStableAbi());
            $receiver.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.getNoCallAssertions());
            $receiver.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments2.getNoReceiverAssertions());
            $receiver.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.getNoParamAssertions());
            $receiver.put(JVMConfigurationKeys.NO_EXCEPTION_ON_EXPLICIT_EQUALS_FOR_BOXED_NULL, arguments2.getNoExceptionOnExplicitEqualsForBoxedNull());
            $receiver.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.getNoOptimize());
            $receiver.put(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS, arguments2.getEmitJvmTypeAnnotations());
            $receiver.put(JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES, arguments2.getNoOptimizedCallableReferences());
            $receiver.put(JVMConfigurationKeys.NO_KOTLIN_NOTHING_VALUE_EXCEPTION, arguments2.getNoKotlinNothingValueException());
            $receiver.put(JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS, arguments2.getNoUnifiedNullChecks());
            if (!JVMConstructorCallNormalizationMode.Companion.isSupportedValue(arguments2.getConstructorCallNormalizationMode())) {
                void $this$map$iv;
                JVMConstructorCallNormalizationMode[] jVMConstructorCallNormalizationModeArray = JVMConstructorCallNormalizationMode.values();
                stringBuilder2 = new StringBuilder().append("Unknown constructor call normalization mode: ").append(arguments2.getConstructorCallNormalizationMode()).append(", ").append("supported modes: ");
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                messageCollector = $receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                boolean $i$f$map = false;
                string3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                JVMAssertionsMode[] jVMAssertionsModeArray = $this$mapTo$iv$iv;
                int n = jVMAssertionsModeArray.length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    JVMAssertionsMode item$iv$iv;
                    JVMAssertionsMode jVMAssertionsMode2 = item$iv$iv = jVMAssertionsModeArray[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    string2 = it.getDescription();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                MessageCollector.DefaultImpls.report$default(messageCollector, compilerMessageSeverity, stringBuilder2.append(collection).toString(), null, 4, null);
            }
            if ((constructorCallNormalizationMode = JVMConstructorCallNormalizationMode.Companion.fromStringOrNull(arguments2.getConstructorCallNormalizationMode())) != null) {
                $receiver.put(JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE, constructorCallNormalizationMode);
            }
            if ((assertionsMode = JVMAssertionsMode.Companion.fromStringOrNull(arguments2.getAssertionsMode())) == null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                $this$mapTo$iv$iv = JVMAssertionsMode.values();
                stringBuilder2 = new StringBuilder().append("Unknown assertions mode: ").append(arguments2.getAssertionsMode()).append(", ").append("supported modes: ");
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                messageCollector = $receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                boolean $i$f$map = false;
                void $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo2 = false;
                void var9_17 = $this$mapTo$iv$iv2;
                int n = ((void)var9_17).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_26 = item$iv$iv = var9_17[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    string2 = it.getDescription();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                MessageCollector.DefaultImpls.report$default(messageCollector, compilerMessageSeverity, stringBuilder2.append(collection).toString(), null, 4, null);
            }
            if ((jVMAssertionsMode = assertionsMode) == null) {
                jVMAssertionsMode = JVMAssertionsMode.DEFAULT;
            }
            $receiver.put(JVMConfigurationKeys.ASSERTIONS_MODE, jVMAssertionsMode);
            $receiver.put(JVMConfigurationKeys.USE_TYPE_TABLE, arguments2.getUseTypeTable());
            $receiver.put(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK, arguments2.getSkipRuntimeVersionCheck());
            $receiver.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, arguments2.getUseOldClassFilesReading());
            if (arguments2.getUseOldClassFilesReading()) {
                MessageCollector.DefaultImpls.report$default($receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
            }
            $receiver.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
            $receiver.put(JVMConfigurationKeys.USE_SINGLE_MODULE, arguments2.getSingleModule());
            String string4 = arguments2.getDeclarationsOutputPath();
            if (string4 == null) break block7;
            string3 = string4;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            $receiver.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKlibPaths(@NotNull CompilerConfiguration $receiver, @NotNull K2JVMCompilerArguments arguments2) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
            boolean bl = arguments2.getUseIR() || arguments2.getKlibLibraries() == null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = false;
                String $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = "Klib libraries can only be used with IR backend";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmArgumentsKt$configureKlibPaths$22));
            }
            String[] stringArray = arguments2.getKlibLibraries();
            if (stringArray == null) break block5;
            Object object = (CharSequence)stringArray;
            String string2 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
            String string3 = string2;
            int $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = 0;
            string3 = new Regex(string3);
            $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = 0;
            boolean bl3 = false;
            stringArray = string3.split((CharSequence)object, $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22);
            if (stringArray != null) {
                String[] $this$toTypedArray$iv = stringArray;
                boolean $i$f$toTypedArray = false;
                String[] thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                stringArray = stringArray2;
                if (stringArray2 != null) {
                    void $this$filterNotTo$iv$iv;
                    String[] $this$filterNot$iv = stringArray;
                    boolean $i$f$filterNot = false;
                    thisCollection$iv = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    void var7_15 = $this$filterNotTo$iv$iv;
                    int n = ((void)var7_15).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = var7_15[i];
                        boolean bl4 = false;
                        CharSequence charSequence = (CharSequence)it;
                        boolean bl5 = false;
                        if (charSequence.length() == 0) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Object it = object;
                    boolean bl8 = false;
                    $receiver.put(JVMConfigurationKeys.KLIB_PATHS, it);
                }
            }
        }
    }
}

