/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tJ\u001c\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\tJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\tH\u0014J\f\u0010\u0014\u001a\u00020\u000e*\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "globalDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;)V", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "table", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "computeSignatureByDeclaration", "declaration", "isExportedDeclaration", "", "privateDeclarationSignature", "builder", "Lkotlin/Function0;", "signatureByDeclaration", "tryComputeBackendSpecificSignature", "isLocalDeclaration", "ir.serialization.common"})
public class DeclarationTable {
    private final Map<IrDeclaration, IdSignature> table;
    private final IdSignatureSerializer signaturer;
    private final GlobalDeclarationTable globalDeclarationTable;

    private final boolean isLocalDeclaration(IrDeclaration $this$isLocalDeclaration) {
        return !this.isExportedDeclaration($this$isLocalDeclaration);
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.globalDeclarationTable.isExportedDeclaration(declaration);
    }

    @Nullable
    protected IdSignature tryComputeBackendSpecificSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return null;
    }

    private final IdSignature computeSignatureByDeclaration(IrDeclaration declaration) {
        IdSignature idSignature;
        IdSignature idSignature2 = this.tryComputeBackendSpecificSignature(declaration);
        if (idSignature2 != null) {
            IdSignature idSignature3 = idSignature2;
            boolean bl = false;
            boolean bl2 = false;
            IdSignature it = idSignature3;
            boolean bl3 = false;
            return it;
        }
        if (this.isLocalDeclaration(declaration)) {
            IdSignature idSignature4;
            Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
            boolean $i$f$getOrPut = false;
            IdSignature value$iv = $this$getOrPut$iv.get(declaration);
            if (value$iv == null) {
                boolean bl = false;
                IdSignature answer$iv = this.signaturer.composeFileLocalIdSignature(declaration);
                $this$getOrPut$iv.put(declaration, answer$iv);
                idSignature4 = answer$iv;
            } else {
                idSignature4 = value$iv;
            }
            idSignature = idSignature4;
        } else {
            idSignature = this.globalDeclarationTable.computeSignatureByDeclaration(declaration);
        }
        return idSignature;
    }

    @NotNull
    public final IdSignature privateDeclarationSignature(@NotNull IrDeclaration declaration, @NotNull Function0<? extends IdSignature> builder) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        boolean bl = this.isLocalDeclaration(declaration);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        IdSignature value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl5 = false;
            IdSignature answer$iv = (IdSignature)builder.invoke();
            $this$getOrPut$iv.put(declaration, answer$iv);
            idSignature = answer$iv;
        } else {
            idSignature = value$iv;
        }
        return idSignature;
    }

    @NotNull
    public final IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.computeSignatureByDeclaration(declaration);
    }

    /*
     * WARNING - void declaration
     */
    public DeclarationTable(@NotNull GlobalDeclarationTable globalDeclarationTable) {
        void it;
        Intrinsics.checkNotNullParameter((Object)globalDeclarationTable, (String)"globalDeclarationTable");
        this.globalDeclarationTable = globalDeclarationTable;
        boolean bl = false;
        this.table = new LinkedHashMap();
        IdSignatureSerializer idSignatureSerializer = this.globalDeclarationTable.getSignaturer();
        boolean bl2 = false;
        boolean bl3 = false;
        IdSignatureSerializer idSignatureSerializer2 = idSignatureSerializer;
        DeclarationTable declarationTable = this;
        boolean bl4 = false;
        it.reset();
        it.setTable(this);
        Unit unit = Unit.INSTANCE;
        declarationTable.signaturer = idSignatureSerializer;
    }
}

