/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.engine.DockerNetworkUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.target.DockerEnvironmentFactory;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.DeferredRemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DockerEnvironment
extends TargetEnvironment {
    private static final Logger LOG = Logger.getInstance(DockerEnvironment.class);
    private final DockerEnvironmentFactory myRunner;
    private final RemoteDockerApplicationRuntime myImage;
    @NotNull
    private final Collection<DockerVolumeBinding> myVolumeBindings;
    @NotNull
    private final List<DockerRemoteRequest.BoundPortValue> myPortBindings;
    @NotNull
    private final String myRunCliOptions;
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    private final Map<TargetEnvironment.TargetPortBinding, Integer> myTargetPortBindings;
    private final Map<TargetEnvironment.LocalPortBinding, HostPort> myLocalPortBindings;

    DockerEnvironment(@NotNull DockerEnvironmentFactory runner, @NotNull RemoteDockerApplicationRuntime image, @NotNull DockerRemoteRequest request, @NotNull String options, @NotNull Collection<DockerVolumeBinding> volumeBindings, @NotNull List<DockerRemoteRequest.BoundPortValue> ports) {
        if (runner == null) {
            DockerEnvironment.$$$reportNull$$$0(0);
        }
        if (image == null) {
            DockerEnvironment.$$$reportNull$$$0(1);
        }
        if (request == null) {
            DockerEnvironment.$$$reportNull$$$0(2);
        }
        if (options == null) {
            DockerEnvironment.$$$reportNull$$$0(3);
        }
        if (volumeBindings == null) {
            DockerEnvironment.$$$reportNull$$$0(4);
        }
        if (ports == null) {
            DockerEnvironment.$$$reportNull$$$0(5);
        }
        super((TargetEnvironmentRequest)request);
        this.myUploadVolumes = new HashMap<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume>();
        this.myDownloadVolumes = new HashMap<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume>();
        this.myTargetPortBindings = new HashMap<TargetEnvironment.TargetPortBinding, Integer>();
        this.myLocalPortBindings = new HashMap<TargetEnvironment.LocalPortBinding, HostPort>();
        this.myRunner = runner;
        this.myImage = image;
        this.myRunCliOptions = options;
        this.myVolumeBindings = volumeBindings;
        this.myPortBindings = ports;
    }

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map = Collections.unmodifiableMap(this.myUploadVolumes);
        if (map == null) {
            DockerEnvironment.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map = Collections.unmodifiableMap(this.myDownloadVolumes);
        if (map == null) {
            DockerEnvironment.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, Integer> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, Integer> map = Collections.unmodifiableMap(this.myTargetPortBindings);
        if (map == null) {
            DockerEnvironment.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, HostPort> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, HostPort> map = Collections.unmodifiableMap(this.myLocalPortBindings);
        if (map == null) {
            DockerEnvironment.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myRunner.getTargetPlatform();
        if (targetPlatform == null) {
            DockerEnvironment.$$$reportNull$$$0(10);
        }
        return targetPlatform;
    }

    public void shutdown() {
    }

    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (commandLine == null) {
            DockerEnvironment.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            DockerEnvironment.$$$reportNull$$$0(12);
        }
        try {
            final String[] resolvedCommand = ArrayUtil.toStringArray((Collection)commandLine.collectCommandsSynchronously());
            String inputFilePath = commandLine.getInputFilePath();
            if (inputFilePath != null) {
                // empty if block
            }
            final String workingDirectory = StringUtil.nullize((String)commandLine.getWorkingDirectory());
            final List<DockerPortBinding> portBindings = this.getPortBindings();
            Map actualPortMappings = portBindings.stream().collect(Collectors.toMap(DockerPortBinding::getContainerPort, binding -> binding, (oldValue, newValue) -> newValue, () -> new HashMap()));
            final Map environmentVariables = commandLine.getEnvironmentVariables();
            DockerAgentDeploymentConfig.Adapter deployConfig2 = new DockerAgentDeploymentConfig.Adapter(){

                public String[] getImageTags() {
                    return new String[]{DockerEnvironment.this.myImage.getAgentApplication().getImageId()};
                }

                public DockerPortBinding[] getPortBindings() {
                    DockerPortBinding[] result = (DockerPortBinding[])portBindings.toArray(DockerPortBinding[]::new);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ports: " + Stream.of(result).map(next -> (DockerPortBindingImpl)ObjectUtils.tryCast((Object)next, DockerPortBindingImpl.class)).filter(Objects::nonNull).map(DockerPortBindingImpl::toCommandLineString).map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining(",\n\t")));
                    }
                    return result;
                }

                public DockerEnvVar[] getEnvVars() {
                    return (DockerEnvVar[])environmentVariables.entrySet().stream().map(e -> new DockerEnvVarImpl((String)e.getKey(), (String)e.getValue())).toArray(DockerEnvVar[]::new);
                }

                public String getWorkingDir() {
                    return workingDirectory;
                }

                public DockerVolumeBinding[] getVolumeBindings() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("volumes: " + DockerEnvironment.this.myVolumeBindings.stream().map(next -> ((DockerVolumeBindingImpl)next).toCommandLineString()).map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining(",\n\t")));
                    }
                    return DockerEnvironment.this.myVolumeBindings.toArray(new DockerVolumeBinding[0]);
                }

                public String[] getCommand() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("command: " + Stream.of(resolvedCommand).map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining()));
                    }
                    return resolvedCommand;
                }

                public String sourceType() {
                    return DockerAgentSourceType.IMAGE.name();
                }

                public String[] getCustomRunOptions() {
                    ArrayList<String> result = new ArrayList<String>();
                    result.add("--security-opt=seccomp:unconfined");
                    String runCliOptions = DockerEnvironment.this.myRunCliOptions;
                    if (!StringUtil.isEmptyOrSpaces((String)runCliOptions)) {
                        result.addAll(ParametersListUtil.parse((String)runCliOptions));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("cli options: " + result.stream().map(x$0 -> DockerEnvironment.quote(x$0)).collect(Collectors.joining(",\n\t")));
                    }
                    return ArrayUtil.toStringArray(result);
                }

                public boolean isCreateContainerOnly() {
                    return true;
                }
            };
            AsyncPromise promise = new AsyncPromise();
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.lambda$createProcess$4((DockerAgentDeploymentConfig)deployConfig2, promise, actualPortMappings));
            return new DeferredRemoteProcess((Promise)promise);
        }
        catch (RemoteSdkException | IOException e) {
            throw new ExecutionException(DockerBundle.message((String)"DockerEnvironment.cant.run.process", (Object[])new Object[]{e.getMessage()}), e);
        }
    }

    private static String quote(String text) {
        return "`" + text + "`";
    }

    private List<DockerPortBinding> getPortBindings() throws IOException {
        if (this.myPortBindings.isEmpty()) {
            return Collections.emptyList();
        }
        int[] localPorts = NetUtils.findAvailableSocketPorts((int)this.myPortBindings.size());
        int idx = 0;
        ArrayList<DockerPortBinding> result = new ArrayList<DockerPortBinding>(localPorts.length);
        for (DockerRemoteRequest.BoundPortValue nextPortRequest : this.myPortBindings) {
            DockerPortBindingImpl nextBinding = nextPortRequest.asDockerPortBinding();
            if (nextBinding.getHostPort() == null) {
                nextBinding.setHostPort(Integer.valueOf(localPorts[idx]));
            }
            result.add((DockerPortBinding)nextBinding);
            ++idx;
        }
        return result;
    }

    static DockerEnvironment create(@NotNull DockerEnvironmentFactory runner, @NotNull RemoteDockerApplicationRuntime image, @NotNull DockerRemoteRequest request, @NotNull String options, @NotNull Collection<DockerVolumeBinding> volumeBindings, @NotNull List<DockerRemoteRequest.BoundPortValue> ports) throws IOException {
        if (runner == null) {
            DockerEnvironment.$$$reportNull$$$0(13);
        }
        if (image == null) {
            DockerEnvironment.$$$reportNull$$$0(14);
        }
        if (request == null) {
            DockerEnvironment.$$$reportNull$$$0(15);
        }
        if (options == null) {
            DockerEnvironment.$$$reportNull$$$0(16);
        }
        if (volumeBindings == null) {
            DockerEnvironment.$$$reportNull$$$0(17);
        }
        if (ports == null) {
            DockerEnvironment.$$$reportNull$$$0(18);
        }
        DockerEnvironment dockerEnvironment = new DockerEnvironment(runner, image, request, options, volumeBindings, ports);
        for (TargetEnvironment.UploadRoot uploadRoot : request.getUploadVolumes()) {
            Object targetRootPath;
            if (uploadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent) {
                targetRootPath = ((TargetEnvironment.TargetPath.Persistent)uploadRoot.getTargetRootPath()).getAbsolutePath();
            } else {
                assert (uploadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Temporary);
                targetRootPath = "/tmp/" + UUID.randomUUID();
            }
            volumeBindings.add(DockerRemoteRequest.safeVolumeBinding((String)targetRootPath, uploadRoot.getLocalRootPath().toAbsolutePath().toString()));
            dockerEnvironment.myUploadVolumes.put(uploadRoot, new DockerVolume(uploadRoot.getLocalRootPath(), (String)targetRootPath));
        }
        for (TargetEnvironment.DownloadRoot downloadRoot : request.getDownloadVolumes()) {
            Object targetRootPath;
            Path localRootPath = downloadRoot.getLocalRootPath() != null ? downloadRoot.getLocalRootPath().toAbsolutePath() : FileUtil.createTempDirectory((String)"intellij-target.", (String)"", (boolean)true).toPath();
            if (downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent) {
                targetRootPath = ((TargetEnvironment.TargetPath.Persistent)downloadRoot.getTargetRootPath()).getAbsolutePath();
            } else {
                assert (downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Temporary);
                targetRootPath = "/tmp/" + UUID.randomUUID();
            }
            volumeBindings.add(DockerRemoteRequest.safeVolumeBinding((String)targetRootPath, localRootPath.toString()));
            dockerEnvironment.myDownloadVolumes.put(downloadRoot, new DockerVolume(localRootPath, (String)targetRootPath));
        }
        for (final TargetEnvironment.TargetPortBinding targetPortBinding : request.getTargetPortBindings()) {
            final int localPort = targetPortBinding.getLocal() == null ? NetUtils.findAvailableSocketPort() : targetPortBinding.getLocal();
            ports.add(new DockerRemoteRequest.BoundPortValue(targetPortBinding.getTarget()){

                @Override
                int getContainerPort() {
                    return targetPortBinding.getTarget();
                }

                @Override
                DockerPortBindingImpl asDockerPortBinding() {
                    DockerPortBindingImpl result = super.asDockerPortBinding();
                    result.setHostPort(Integer.valueOf(localPort));
                    return result;
                }

                public Promise<Integer> getLocalValue() {
                    return Promises.resolvedPromise((Object)localPort);
                }
            });
            dockerEnvironment.myTargetPortBindings.put(targetPortBinding, localPort);
        }
        if (!request.getLocalPortBindings().isEmpty()) {
            DockerCloudConfiguration dockerCloudConfiguration = image.getDockerRuntime().getAccount();
            String hostAddress = DockerNetworkUtil.getHostAddress((DockerCloudConfiguration)dockerCloudConfiguration);
            for (TargetEnvironment.LocalPortBinding localPortBinding : request.getLocalPortBindings()) {
                if (localPortBinding.getTarget() != null && localPortBinding.getTarget().intValue() != localPortBinding.getLocal()) {
                    throw new UnsupportedOperationException("TCP proxy is not implemented.");
                }
                int targetPort = localPortBinding.getLocal();
                dockerEnvironment.myLocalPortBindings.put(localPortBinding, new HostPort(hostAddress, targetPort));
            }
        }
        return dockerEnvironment;
    }

    private /* synthetic */ void lambda$createProcess$4(DockerAgentDeploymentConfig deployConfig2, AsyncPromise promise, Map actualPortMappings) {
        try {
            RemoteDockerApplicationRuntime myContainer = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)this.myRunner.getDocker(), (DockerAgentDeploymentConfig)deployConfig2);
            myContainer.startAndAttach();
            DockerExecProcess result = DockerExecProcess.Factory.newProcess(myContainer, false);
            promise.setResult((Object)result);
            this.myPortBindings.forEach(portValue -> portValue.localPortBound((DockerPortBinding)actualPortMappings.get(portValue.getContainerPort())));
        }
        catch (Throwable t) {
            promise.setError(t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeBindings";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUploadVolumes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadVolumes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPortBindings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPortBindings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DockerVolume
    implements TargetEnvironment.UploadableVolume,
    TargetEnvironment.DownloadableVolume {
        private final Path myLocalRoot;
        private final String myTargetRoot;

        private DockerVolume(@NotNull Path localRoot, @NotNull String targetRoot) {
            if (localRoot == null) {
                DockerVolume.$$$reportNull$$$0(0);
            }
            if (targetRoot == null) {
                DockerVolume.$$$reportNull$$$0(1);
            }
            this.myLocalRoot = localRoot;
            this.myTargetRoot = targetRoot;
        }

        @NotNull
        public Path getLocalRoot() {
            Path path = this.myLocalRoot;
            if (path == null) {
                DockerVolume.$$$reportNull$$$0(2);
            }
            return path;
        }

        @NotNull
        public String getTargetRoot() {
            String string = this.myTargetRoot;
            if (string == null) {
                DockerVolume.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String resolveTargetPath(@NotNull String relativePath) {
            if (relativePath == null) {
                DockerVolume.$$$reportNull$$$0(4);
            }
            String string = FileUtil.toCanonicalPath((String)(this.getTargetRoot() + "/" + relativePath), (char)'/');
            if (string == null) {
                DockerVolume.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void upload(@NotNull String relativePath, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator) {
            if (relativePath == null) {
                DockerVolume.$$$reportNull$$$0(6);
            }
            if (targetProgressIndicator == null) {
                DockerVolume.$$$reportNull$$$0(7);
            }
        }

        public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) {
            if (relativePath == null) {
                DockerVolume.$$$reportNull$$$0(8);
            }
            if (progressIndicator == null) {
                DockerVolume.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/remote/run/target/DockerEnvironment$DockerVolume";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProgressIndicator";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/remote/run/target/DockerEnvironment$DockerVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalRoot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveTargetPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveTargetPath";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "upload";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "download";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

