/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run;

import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.run.runtime.DockerAgentBuildImageConfig;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class DockerHelpersImageCreator {
    private final String myImageName;
    private final String myLabel;
    private final String myWorkingDirectory;
    private final String myWorkingDirectoryEnv;
    private final String myServiceName;

    public DockerHelpersImageCreator(@NotNull String imageName, @NotNull String label, @NotNull String workingDirectory, @NotNull String workingDirectoryEnv, @NotNull String serviceName) {
        if (imageName == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(0);
        }
        if (label == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(2);
        }
        if (workingDirectoryEnv == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(3);
        }
        if (serviceName == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(4);
        }
        this.myImageName = imageName;
        this.myLabel = label;
        this.myWorkingDirectory = workingDirectory;
        this.myWorkingDirectoryEnv = workingDirectoryEnv;
        this.myServiceName = serviceName;
    }

    protected void fillEnv(@NotNull Map<String, String> env) {
        if (env == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(5);
        }
    }

    public DockerVolumesFrom @NotNull [] getHelpersContainerVolumesFrom(@NotNull RemoteDockerRuntime dockerRuntime2) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(6);
        }
        String containerId = this.getHelpersContainer(dockerRuntime2).getContainerId();
        DockerVolumesFrom[] dockerVolumesFromArray = new DockerVolumesFrom[]{new DockerVolumesFromContainerId(containerId)};
        if (dockerVolumesFromArray == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(7);
        }
        return dockerVolumesFromArray;
    }

    @NotNull
    public SharedVolume getHelpersContainerSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime2) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(8);
        }
        String imageName = this.getImageName();
        String containerId = this.getHelpersContainer(dockerRuntime2).getContainerId();
        String volumeName = this.myServiceName + "_" + DockerHelpersImageCreator.getBuildVersion();
        return new SharedVolume(imageName, containerId, this.myWorkingDirectory, this.myServiceName, volumeName);
    }

    @NotNull
    public synchronized RemoteDockerApplicationRuntime getHelpersContainer(@NotNull RemoteDockerRuntime dockerRuntime2) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(9);
        }
        String helpersTag = DockerHelpersImageCreator.getBuildVersion();
        String imageName = this.myImageName + ":" + helpersTag;
        String containerName = this.myImageName + "_" + helpersTag;
        this.ensureHelpersImagePresent(dockerRuntime2, imageName, helpersTag);
        RemoteDockerApplicationRuntime applicationRuntime = dockerRuntime2.findContainerByName(containerName);
        if (applicationRuntime != null) {
            RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = applicationRuntime;
            if (remoteDockerApplicationRuntime == null) {
                DockerHelpersImageCreator.$$$reportNull$$$0(10);
            }
            return remoteDockerApplicationRuntime;
        }
        String[] command = DockerHelpersImageCreator.getShContainerCommand();
        HashMap<String, String> env = new HashMap<String, String>();
        this.fillEnv(env);
        DockerAgentDeploymentConfigImpl config = new DockerAgentDeploymentConfigImpl(imageName, null).withEnvs(env);
        config.withContainerName(containerName).withCommand(command);
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = RemoteDockerApplicationRuntime.createWithImageInitialization((RemoteDockerRuntime)dockerRuntime2, (DockerAgentDeploymentConfig)config, () -> this.buildHelpersImage(dockerRuntime2, imageName, helpersTag));
        if (remoteDockerApplicationRuntime == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(11);
        }
        return remoteDockerApplicationRuntime;
    }

    private void ensureHelpersImagePresent(@NotNull RemoteDockerRuntime runtime, @NotNull String imageName, @NotNull String tag) throws ServerRuntimeException, IOException {
        DockerAgentApplication image;
        if (runtime == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(12);
        }
        if (imageName == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(13);
        }
        if (tag == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(14);
        }
        if ((image = runtime.findImageByName(imageName)) == null) {
            this.buildHelpersImage(runtime, imageName, tag);
        }
    }

    @NotNull
    protected abstract List<File> getHelpersRoots() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHelpersImage(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull String imageName, @NotNull String helpersVersion) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(15);
        }
        if (imageName == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(16);
        }
        if (helpersVersion == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(17);
        }
        File dockerfile = FileUtil.createTempFile((String)(this.myImageName + "_"), (String)".dockerfile", (boolean)true);
        List<File> helpersDirs = this.getHelpersRoots();
        try (PrintWriter printWriter = new PrintWriter(dockerfile);){
            printWriter.println("FROM busybox");
            printWriter.println("LABEL " + this.myLabel + "=" + helpersVersion);
            printWriter.println("LABEL com.jetbrains.docker.helper.image=");
            printWriter.println("ENV " + this.myWorkingDirectoryEnv + " " + this.myWorkingDirectory);
            printWriter.println("WORKDIR ${" + this.myWorkingDirectoryEnv + "}");
            printWriter.println("COPY . ${" + this.myWorkingDirectoryEnv + "}");
            printWriter.println("VOLUME ${" + this.myWorkingDirectoryEnv + "}");
        }
        File dockerImageArchive = DockerProcessUtil.buildDockerImageArchive(dockerfile, helpersDirs.toArray(new File[0]));
        DockerAgentBuildImageConfig config = new DockerAgentBuildImageConfig(imageName, dockerImageArchive, true);
        RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime2, (DockerAgentDeploymentConfig)config);
    }

    public static String @NotNull [] getShContainerCommand() {
        String[] stringArray = new String[]{"/bin/sh"};
        if (stringArray == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    @NotNull
    private static String getBuildVersion() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        if (string == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private String getImageName() {
        String string = this.myImageName + ":" + DockerHelpersImageCreator.getBuildVersion();
        if (string == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectoryEnv";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/DockerHelpersImageCreator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/DockerHelpersImageCreator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersContainer";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getShContainerCommand";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersion";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillEnv";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainerSharedVolume";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainer";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ensureHelpersImagePresent";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildHelpersImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DockerVolumesFromContainerId
    implements DockerVolumesFrom {
        private final String myContainerId;

        DockerVolumesFromContainerId(String containerId) {
            this.myContainerId = containerId;
        }

        public String getContainerId() {
            return this.myContainerId;
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

