/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBase;
import com.intellij.docker.compose.configuration.beans.common.ServiceVolume;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.remote.DockerComposeMappingsCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerComposeConfigMappingCollector
implements DockerComposeConfiguration.Visitor<Boolean> {
    private static final Logger LOG = Logger.getInstance(DockerComposeMappingsCollector.class);
    private final Map<String, PathMappingSettings> myServiceMappings;
    @NotNull
    private final String myDockerComposeBaseDirectory;

    public DockerComposeConfigMappingCollector(@NotNull String dockerComposeBaseFile) {
        if (dockerComposeBaseFile == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(0);
        }
        this.myServiceMappings = new HashMap<String, PathMappingSettings>();
        this.myDockerComposeBaseDirectory = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)dockerComposeBaseFile));
    }

    public Boolean visit(@NotNull DockerComposeConfigurationV1 configuration) {
        if (configuration == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(1);
        }
        for (Map.Entry entry : configuration.getServices().entrySet()) {
            String serviceName = (String)entry.getKey();
            DockerComposeServiceV1 service = (DockerComposeServiceV1)entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, (DockerComposeServiceBase)service);
        }
        return true;
    }

    public Boolean visit(@NotNull DockerComposeConfigurationV2 configuration) {
        if (configuration == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(2);
        }
        for (Map.Entry entry : configuration.getServices().entrySet()) {
            String serviceName = (String)entry.getKey();
            DockerComposeServiceV2 service = (DockerComposeServiceV2)entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, (DockerComposeServiceBase)service);
        }
        return true;
    }

    private void collectVolumes(@NotNull String serviceName, @NotNull DockerComposeServiceBase service) {
        List volumes;
        if (serviceName == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(3);
        }
        if (service == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(4);
        }
        if ((volumes = service.getVolumes()) == null || volumes.isEmpty()) {
            return;
        }
        PathMappingSettings mappings = this.myServiceMappings.containsKey(serviceName) ? this.myServiceMappings.get(serviceName) : new PathMappingSettings();
        for (ServiceVolume volume : volumes) {
            boolean isAbsolutePath;
            if (!volume.isBind()) continue;
            String sourcePath = volume.getSource();
            String targetPath = volume.getTarget();
            if (sourcePath == null || targetPath == null || !(isAbsolutePath = FileUtil.isAbsolutePlatformIndependent((String)sourcePath)) && !StringUtil.startsWith((CharSequence)sourcePath, (CharSequence)".")) continue;
            String unifiedLocal = PathUtil.toSystemIndependentName((String)sourcePath);
            String absolute = isAbsolutePath ? unifiedLocal : this.myDockerComposeBaseDirectory + "/" + unifiedLocal;
            mappings.addMapping(FileUtil.toCanonicalPath((String)absolute, (char)'/'), targetPath);
        }
        if (!mappings.isEmpty()) {
            this.myServiceMappings.put(serviceName, mappings);
        }
    }

    @NotNull
    public PathMappingSettings collect(@NotNull String serviceName, @NotNull List<String> configurationFiles) {
        if (serviceName == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(5);
        }
        if (configurationFiles == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(6);
        }
        this.parse(configurationFiles);
        PathMappingSettings result = this.myServiceMappings.get(serviceName);
        return result != null ? result : new PathMappingSettings();
    }

    private void parse(@NotNull List<String> configFiles) {
        block5: {
            if (configFiles == null) {
                DockerComposeConfigMappingCollector.$$$reportNull$$$0(7);
            }
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                for (String configFile : configFiles) {
                    DockerComposeConfigurationParserUtil.saveDockerComposeFiles(Collections.singletonList(configFile));
                }
            }
            try {
                DockerComposeConfigurationParserUtil.defaultParserForUi().parseBean(configFiles).accept((DockerComposeConfiguration.Visitor)this);
            }
            catch (IOException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break block5;
                LOG.warn("Cannot read docker-compose file: " + configFiles, (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeBaseFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remote/DockerComposeConfigMappingCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectVolumes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

