/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.run.configuration;

import com.intellij.docker.DockerSettings;
import com.intellij.docker.compose.cli.DockerComposeCliCmd;
import com.intellij.docker.compose.cli.DockerComposeCliCommands;
import com.intellij.docker.compose.cli.DockerComposeCliParser;
import com.intellij.docker.compose.cli.DockerComposeCliSubCmd;
import com.intellij.docker.compose.run.configuration.DockerComposeSettings;
import com.intellij.docker.compose.run.configuration.DockerComposeSettingsEditor;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0002J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0007H\u0002J\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0017J\b\u0010%\u001a\u00020\u0015H\u0002J\"\u0010%\u001a\u00020\u00152\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/docker/compose/run/configuration/DockerComposeSettingsEditor;", "T", "Lcom/intellij/execution/configuration/AbstractRunConfiguration;", "Lcom/intellij/openapi/options/SettingsEditor;", "()V", "composeFilePaths", "", "", "dockerComposeCliExpandableField", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "dockerComposeCliPreviewField", "hideablePanel", "Ljavax/swing/JPanel;", "parseError", "previewSplitter", "Lcom/intellij/docker/compose/run/configuration/DockerComposeSettingsEditor$PreviewSplitter;", "previousCliOptions", "serviceName", "settings", "Lcom/intellij/docker/compose/run/configuration/DockerComposeSettings;", "applyEditorTo", "", "s", "(Lcom/intellij/execution/configuration/AbstractRunConfiguration;)V", "applyEditorToSettings", "buildCommandLinePreview", "configurationFiles", "cmdWithOptions", "createEditor", "Ljavax/swing/JComponent;", "getDockerComposePath", "getSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "runConfiguration", "(Lcom/intellij/execution/configuration/AbstractRunConfiguration;)Lcom/intellij/openapi/projectRoots/Sdk;", "resetDockerComposeAdditionalData", "resetEditorFrom", "updateDockerComposeCliPreviewField", "Companion", "PreviewSplitter", "intellij.clouds.docker.remoteRun"})
public abstract class DockerComposeSettingsEditor<T extends AbstractRunConfiguration>
extends SettingsEditor<T> {
    private final ExpandableTextField dockerComposeCliExpandableField = new ExpandableTextField((Function)dockerComposeCliExpandableField.1.INSTANCE, ParametersListUtil.DEFAULT_LINE_JOINER);
    private final PreviewSplitter previewSplitter = new PreviewSplitter(null, 1, null);
    private final ExpandableTextField dockerComposeCliPreviewField = new ExpandableTextField((Function)this.previewSplitter, ParametersListUtil.DEFAULT_LINE_JOINER);
    private final JPanel hideablePanel = new JPanel(new BorderLayout());
    private final DockerComposeSettings settings = new DockerComposeSettings();
    private List<String> composeFilePaths;
    private String serviceName;
    private String parseError;
    private String previousCliOptions;
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected abstract Sdk getSdk(@NotNull T var1);

    private final void updateDockerComposeCliPreviewField() {
        String cliOptions;
        String string = cliOptions = this.dockerComposeCliExpandableField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cliOptions");
        if (StringsKt.isBlank((CharSequence)string)) {
            this.updateDockerComposeCliPreviewField(this.composeFilePaths, DockerComposeSettingsEditor.Companion.getDefaultComposeCommand(this.serviceName));
            this.parseError = null;
        } else {
            try {
                DockerComposeCliParser dockerComposeCliParser = new DockerComposeCliParser();
                String[] stringArray = ParametersListUtil.parseToArray((String)cliOptions);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ParametersListUtil.parseToArray(cliOptions)");
                DockerComposeCliCmd cmd = dockerComposeCliParser.parse(stringArray);
                List<String> list = this.composeFilePaths;
                DockerComposeCliSubCmd dockerComposeCliSubCmd = cmd.getSubCmd();
                this.updateDockerComposeCliPreviewField(list != null ? CollectionsKt.plus((Collection)list, (Iterable)cmd.getFiles()) : null, dockerComposeCliSubCmd != null ? DockerComposeCliCommands.getSubcommandLineString((DockerComposeCliSubCmd)dockerComposeCliSubCmd) : null);
                this.parseError = null;
            }
            catch (Exception e) {
                String string2 = e.getLocalizedMessage();
                if (string2 == null) {
                    string2 = e.toString();
                }
                this.parseError = string2;
            }
        }
    }

    private final void updateDockerComposeCliPreviewField(List<String> configurationFiles, String cmdWithOptions) {
        List<String> commandLine = this.buildCommandLinePreview(configurationFiles, cmdWithOptions);
        this.previewSplitter.setLines(commandLine);
        String newValue = CollectionsKt.joinToString$default((Iterable)commandLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        if (Intrinsics.areEqual((Object)newValue, (Object)this.dockerComposeCliPreviewField.getText()) ^ true) {
            this.dockerComposeCliPreviewField.setText(newValue);
        }
    }

    private final List<String> buildCommandLinePreview(List<String> configurationFiles, String cmdWithOptions) {
        List cliPreviewBuilder;
        block2: {
            boolean bl = false;
            cliPreviewBuilder = new ArrayList();
            cliPreviewBuilder.add(this.getDockerComposePath());
            List<String> list = configurationFiles;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    cliPreviewBuilder.add("-f " + it);
                }
            }
            cliPreviewBuilder.add("-f <override configuration file>");
            String string = cmdWithOptions;
            if (string == null) break block2;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string2;
            boolean bl5 = false;
            cliPreviewBuilder.add(it);
        }
        return cliPreviewBuilder;
    }

    private final String getDockerComposePath() {
        DockerSettings dockerSettings = DockerSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dockerSettings, (String)"DockerSettings.getInstance()");
        String string = dockerSettings.getDockerComposePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerSettings.getInstance().dockerComposePath");
        return string;
    }

    protected void resetEditorFrom(@NotNull T s) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        DockerComposeSettings dockerComposeSettings = (DockerComposeSettings)s.getCopyableUserData(DockerComposeSettings.KEY);
        if (dockerComposeSettings == null) {
            dockerComposeSettings = new DockerComposeSettings();
        }
        DockerComposeSettings userDataSettings = dockerComposeSettings;
        this.settings.loadState(userDataSettings);
        this.resetDockerComposeAdditionalData(s);
        this.dockerComposeCliExpandableField.setText(this.settings.getCommandLine());
        this.updateDockerComposeCliPreviewField();
    }

    private final void resetDockerComposeAdditionalData(T s) {
        Sdk sdk = this.getSdk(s);
        Object object = sdk != null ? sdk.getSdkAdditionalData() : null;
        if (!(object instanceof RemoteSdkAdditionalData)) {
            object = null;
        }
        RemoteSdkAdditionalData remoteSdkAdditionalData = (RemoteSdkAdditionalData)object;
        if (remoteSdkAdditionalData == null) {
            return;
        }
        RemoteSdkAdditionalData sdkAdditionalData = remoteSdkAdditionalData;
        sdkAdditionalData.switchOnConnectionType(new CredentialsCase[]{new DockerComposeCredentialsCase(this){
            final /* synthetic */ DockerComposeSettingsEditor this$0;

            public void process(@NotNull DockerComposeCredentialsHolder credentials) {
                Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
                DockerComposeSettingsEditor.access$setComposeFilePaths$p(this.this$0, credentials.getComposeFilePaths());
                DockerComposeSettingsEditor.access$setServiceName$p(this.this$0, credentials.getComposeServiceName());
            }
            {
                this.this$0 = this$0;
            }
        }});
        StatusText statusText = this.dockerComposeCliExpandableField.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"dockerComposeCliExpandableField.emptyText");
        statusText.setText(DockerComposeSettingsEditor.Companion.getDefaultComposeCommand(this.serviceName));
    }

    protected void applyEditorTo(@NotNull T s) throws ConfigurationException {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        this.applyEditorToSettings();
        s.putCopyableUserData(DockerComposeSettings.KEY, (Object)DockerComposeSettingsEditor.Companion.nullize(this.settings));
    }

    private final void applyEditorToSettings() throws ConfigurationException {
        String cliOptions = this.dockerComposeCliExpandableField.getText();
        if (Intrinsics.areEqual((Object)cliOptions, (Object)this.previousCliOptions) ^ true) {
            this.previousCliOptions = cliOptions;
            this.updateDockerComposeCliPreviewField();
        }
        String string = this.parseError;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            throw (Throwable)new RuntimeConfigurationWarning(it);
        }
        String string3 = cliOptions;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cliOptions");
        this.settings.setCommandLine(string3);
    }

    @NotNull
    protected JComponent createEditor() {
        return this.hideablePanel;
    }

    /*
     * WARNING - void declaration
     */
    public DockerComposeSettingsEditor() {
        void $this$apply;
        this.dockerComposeCliExpandableField.setColumns(0);
        this.dockerComposeCliPreviewField.setEditable(false);
        this.dockerComposeCliPreviewField.setForeground(UIUtil.getInactiveTextColor());
        this.dockerComposeCliPreviewField.setColumns(0);
        JBLabel jBLabel = new JBLabel(DockerBundle.message((String)"DockerComposeSettingsEditor.form.command.preview", (Object[])new Object[0]));
        boolean bl = false;
        boolean bl2 = false;
        JBLabel jBLabel2 = jBLabel;
        FormBuilder formBuilder = new FormBuilder().addLabeledComponent(DockerBundle.message((String)"DockerComposeSettingsEditor.form.command", (Object[])new Object[0]), (JComponent)this.dockerComposeCliExpandableField);
        boolean bl3 = false;
        $this$apply.setEnabled(false);
        Unit unit = Unit.INSTANCE;
        FormBuilder formBuilder2 = formBuilder.addLabeledComponent((JComponent)jBLabel, (JComponent)this.dockerComposeCliPreviewField);
        Intrinsics.checkNotNullExpressionValue((Object)formBuilder2, (String)"FormBuilder()\n      .add\u2026erComposeCliPreviewField)");
        JPanel jPanel = formBuilder2.getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"FormBuilder()\n      .add\u2026reviewField)\n      .panel");
        JPanel mainPanel = jPanel;
        HideableDecorator decorator = new HideableDecorator(this.hideablePanel, DockerBundle.message((String)"DockerComposeSettingsEditor.form.name", (Object[])new Object[0]), false);
        decorator.setContentComponent((JComponent)mainPanel);
        decorator.setOn(true);
    }

    public static final /* synthetic */ List access$getComposeFilePaths$p(DockerComposeSettingsEditor $this) {
        return $this.composeFilePaths;
    }

    public static final /* synthetic */ void access$setComposeFilePaths$p(DockerComposeSettingsEditor $this, List list) {
        $this.composeFilePaths = list;
    }

    public static final /* synthetic */ String access$getServiceName$p(DockerComposeSettingsEditor $this) {
        return $this.serviceName;
    }

    public static final /* synthetic */ void access$setServiceName$p(DockerComposeSettingsEditor $this, String string) {
        $this.serviceName = string;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\b\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/compose/run/configuration/DockerComposeSettingsEditor$PreviewSplitter;", "Lcom/intellij/util/Function;", "", "", "lines", "(Ljava/util/List;)V", "getLines", "()Ljava/util/List;", "setLines", "fun", "param", "intellij.clouds.docker.remoteRun"})
    private static final class PreviewSplitter
    implements Function<String, List<? extends String>> {
        @NotNull
        private List<String> lines;

        @NotNull
        public List<String> fun(@NotNull String param) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            return this.lines;
        }

        @NotNull
        public final List<String> getLines() {
            return this.lines;
        }

        public final void setLines(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.lines = list;
        }

        public PreviewSplitter(@NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            this.lines = lines;
        }

        public /* synthetic */ PreviewSplitter(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        public PreviewSplitter() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\bJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/compose/run/configuration/DockerComposeSettingsEditor$Companion;", "", "()V", "createEditor", "Lcom/intellij/docker/compose/run/configuration/DockerComposeSettingsEditor;", "T", "Lcom/intellij/execution/configuration/AbstractRunConfiguration;", "getSdk", "Lkotlin/Function1;", "Lcom/intellij/openapi/projectRoots/Sdk;", "getDefaultComposeCommand", "", "serviceName", "hasDefaultValue", "", "Lcom/intellij/docker/compose/run/configuration/DockerComposeSettings;", "nullize", "intellij.clouds.docker.remoteRun"})
    public static final class Companion {
        private final String getDefaultComposeCommand(String serviceName) {
            return "up --exit-code-from " + serviceName + " --abort-on-container-exit " + serviceName;
        }

        private final DockerComposeSettings nullize(DockerComposeSettings $this$nullize) {
            return !this.hasDefaultValue($this$nullize) ? $this$nullize : null;
        }

        private final boolean hasDefaultValue(DockerComposeSettings $this$hasDefaultValue) {
            return StringsKt.isBlank((CharSequence)$this$hasDefaultValue.getCommandLine());
        }

        @NotNull
        public final <T extends AbstractRunConfiguration> DockerComposeSettingsEditor<T> createEditor(@NotNull Function1<? super T, ? extends Sdk> getSdk) {
            Intrinsics.checkNotNullParameter(getSdk, (String)"getSdk");
            return new DockerComposeSettingsEditor<T>(getSdk){
                final /* synthetic */ Function1 $getSdk;

                @Nullable
                protected Sdk getSdk(@NotNull T runConfiguration) {
                    Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
                    return (Sdk)this.$getSdk.invoke(runConfiguration);
                }
                {
                    this.$getSdk = $captured_local_variable$0;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

