/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.importers.ftrace;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.collections.SparseArray;
import trebuchet.importers.ImportFeedback;
import trebuchet.importers.ftrace.FtraceLine;
import trebuchet.importers.ftrace.FunctionRegistry;
import trebuchet.importers.ftrace.ImportData;
import trebuchet.importers.ftrace.ParseFunction;
import trebuchet.io.DataSlice;
import trebuchet.model.fragments.CpuModelFragment;
import trebuchet.model.fragments.ModelFragment;
import trebuchet.model.fragments.ProcessModelFragment;
import trebuchet.model.fragments.ThreadModelFragment;
import trebuchet.util.StringCache;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001a2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u000fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u001c\u0010&\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001a2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J$\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001a2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010'\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Ltrebuchet/importers/ftrace/FtraceImporterState;", "", "feedback", "Ltrebuchet/importers/ImportFeedback;", "(Ltrebuchet/importers/ImportFeedback;)V", "cpuMap", "Ltrebuchet/collections/SparseArray;", "Ltrebuchet/model/fragments/CpuModelFragment;", "handlers", "", "Ltrebuchet/io/DataSlice;", "Ltrebuchet/importers/ftrace/ParseFunction;", "importData", "Ltrebuchet/importers/ftrace/ImportData;", "modelFragment", "Ltrebuchet/model/fragments/ModelFragment;", "getModelFragment", "()Ltrebuchet/model/fragments/ModelFragment;", "pidMap", "Ltrebuchet/model/fragments/ThreadModelFragment;", "stringCache", "Ltrebuchet/util/StringCache;", "getStringCache", "()Ltrebuchet/util/StringCache;", "cpuFor", "cid", "", "createProcess", "tgid", "name", "", "createUnknownProcess", "Ltrebuchet/model/fragments/ProcessModelFragment;", "finish", "importLine", "", "line", "Ltrebuchet/importers/ftrace/FtraceLine;", "processFor", "threadFor", "pid", "task", "intellij.android.profilers.atrace"})
public final class FtraceImporterState {
    private final SparseArray<ThreadModelFragment> pidMap;
    private final SparseArray<CpuModelFragment> cpuMap;
    private final Map<DataSlice, ParseFunction> handlers;
    @NotNull
    private final ModelFragment modelFragment;
    @NotNull
    private final StringCache stringCache;
    private final ImportData importData;

    @NotNull
    public final ModelFragment getModelFragment() {
        return this.modelFragment;
    }

    @NotNull
    public final StringCache getStringCache() {
        return this.stringCache;
    }

    @NotNull
    public final ModelFragment finish() {
        return this.modelFragment;
    }

    public final void importLine(@NotNull FtraceLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.modelFragment.getGlobalStartTime() == 0.0) {
            this.modelFragment.setGlobalStartTime(line.getTimestamp());
        }
        this.modelFragment.setGlobalEndTime(line.getTimestamp());
        if (line.getHasTgid()) {
            this.threadFor(line);
        }
        ParseFunction parseFunction = this.handlers.get(line.getFunction());
        if (parseFunction == null) {
            return;
        }
        ParseFunction handler = parseFunction;
        handler.invoke(this.importData.wrap(line));
    }

    private final ThreadModelFragment createProcess(int tgid, String name) {
        ProcessModelFragment proc = new ProcessModelFragment(tgid, name, null, 4, null);
        this.modelFragment.getProcesses().add(proc);
        ThreadModelFragment thread2 = proc.threadFor(tgid, name);
        if (this.pidMap.get(tgid) != null) {
            new IllegalStateException("Unable to create process " + tgid + " - already exists!");
        }
        this.pidMap.put(tgid, thread2);
        return thread2;
    }

    static /* synthetic */ ThreadModelFragment createProcess$default(FtraceImporterState ftraceImporterState, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return ftraceImporterState.createProcess(n, string);
    }

    private final ProcessModelFragment processFor(int tgid, String name) {
        ThreadModelFragment threadModelFragment = this.pidMap.get(tgid);
        if (threadModelFragment == null) {
            threadModelFragment = this.createProcess(tgid, name);
        }
        ThreadModelFragment thread2 = threadModelFragment;
        thread2.getProcess().hint(tgid, name);
        return thread2.getProcess();
    }

    static /* synthetic */ ProcessModelFragment processFor$default(FtraceImporterState ftraceImporterState, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return ftraceImporterState.processFor(n, string);
    }

    private final ProcessModelFragment createUnknownProcess() {
        return new ProcessModelFragment(-1, null, (Function1)new Function1<ProcessModelFragment, Unit>(this){
            final /* synthetic */ FtraceImporterState this$0;

            public final void invoke(@NotNull ProcessModelFragment process) {
                boolean bl;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)process, (String)"process");
                    int tgid = process.getId();
                    ThreadModelFragment existing = (ThreadModelFragment)FtraceImporterState.access$getPidMap$p(this.this$0).get(tgid);
                    if (existing != null) {
                        existing.getProcess().merge(process);
                    } else {
                        FtraceImporterState.access$getPidMap$p(this.this$0).put(tgid, process.threadFor(tgid, process.getName()));
                    }
                    Iterable $this$none$iv = this.this$0.getModelFragment().getProcesses();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            ProcessModelFragment it = (ProcessModelFragment)element$iv;
                            boolean bl2 = false;
                            if (!(it.getId() == process.getId())) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.this$0.getModelFragment().getProcesses().add(process);
                }
            }
            {
                this.this$0 = ftraceImporterState;
                super(1);
            }
        }, 2, null);
    }

    @NotNull
    public final ThreadModelFragment threadFor(int pid, int tgid, @Nullable String task) {
        String processName;
        ThreadModelFragment thread2 = this.pidMap.get(pid);
        String string = processName = tgid == pid ? task : null;
        if (thread2 != null) {
            ThreadModelFragment.hint$default(thread2, 0, task, tgid, processName, 1, null);
            return thread2;
        }
        ProcessModelFragment process = tgid != -1 ? FtraceImporterState.processFor$default(this, tgid, null, 2, null) : this.createUnknownProcess();
        thread2 = process.threadFor(pid, task);
        ThreadModelFragment.hint$default(thread2, 0, null, 0, processName, 7, null);
        this.pidMap.put(pid, thread2);
        return thread2;
    }

    public static /* synthetic */ ThreadModelFragment threadFor$default(FtraceImporterState ftraceImporterState, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        if ((n3 & 4) != 0) {
            string = null;
        }
        return ftraceImporterState.threadFor(n, n2, string);
    }

    @NotNull
    public final ThreadModelFragment threadFor(@NotNull FtraceLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.threadFor(line.getPid(), line.getTgid(), line.getTask());
    }

    @NotNull
    public final CpuModelFragment cpuFor(int cid) {
        CpuModelFragment cpu = this.cpuMap.get(cid);
        if (cpu == null) {
            cpu = new CpuModelFragment(cid);
            this.modelFragment.getCpus().add(cpu);
        }
        this.cpuMap.put(cid, cpu);
        CpuModelFragment cpuModelFragment = this.cpuMap.get(cid);
        Intrinsics.checkNotNull((Object)cpuModelFragment);
        return cpuModelFragment;
    }

    public FtraceImporterState(@NotNull ImportFeedback feedback) {
        Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
        this.pidMap = new SparseArray(50);
        this.cpuMap = new SparseArray(6);
        this.handlers = FunctionRegistry.INSTANCE.create();
        this.modelFragment = new ModelFragment();
        this.stringCache = new StringCache();
        this.importData = new ImportData(this, feedback);
    }

    public static final /* synthetic */ SparseArray access$getPidMap$p(FtraceImporterState $this) {
        return $this.pidMap;
    }
}

