/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.android.tools.profilers.stacktrace.CodeLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StackFrameParser {
    @NotNull
    private final String myLine;

    public StackFrameParser(@NotNull String line) {
        if (line == null) {
            StackFrameParser.$$$reportNull$$$0(0);
        }
        this.myLine = line;
    }

    @Nullable
    public String getClassName() {
        int lastDot = this.getLastDot();
        if (lastDot == -1) {
            return null;
        }
        return this.myLine.substring(0, lastDot);
    }

    @Nullable
    public String getFileName() {
        int start = this.getOpenParen();
        int end = this.getLastColon();
        if (start == -1 || start >= end) {
            return null;
        }
        return this.myLine.substring(start + 1, end);
    }

    @Nullable
    public String getMethodName() {
        int start = this.getLastDot();
        int end = this.getOpenParen();
        if (start == -1 || start >= end) {
            return null;
        }
        return this.myLine.substring(start + 1, end);
    }

    public int getLineNumber() {
        int end;
        int start = this.getLastColon();
        if (start >= (end = this.getCloseParen()) || start == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(this.myLine.substring(start + 1, end));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getLastColon() {
        return this.myLine.lastIndexOf(58);
    }

    public int getLastDot() {
        return this.myLine.lastIndexOf(46, this.getOpenParen());
    }

    public int getOpenParen() {
        return this.myLine.indexOf(40);
    }

    public int getCloseParen() {
        return this.myLine.indexOf(41);
    }

    @NotNull
    public CodeLocation toCodeLocation() {
        String className = this.getClassName();
        if (className == null) {
            throw new IllegalStateException(String.format("Trying to create CodeLocation from an incomplete StackFrameParser. Line contents: '%s'", this.myLine));
        }
        CodeLocation codeLocation = new CodeLocation.Builder(className).setFileName(this.getFileName()).setMethodName(this.getMethodName()).setLineNumber(this.getLineNumber() - 1).build();
        if (codeLocation == null) {
            StackFrameParser.$$$reportNull$$$0(1);
        }
        return codeLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/stacktrace/StackFrameParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/stacktrace/StackFrameParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toCodeLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

