/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.menu.CommonDropDownButton;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureArtifactView;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.memory.HprofArtifactView;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsArtifactView;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionArtifactView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionItemView;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class SessionsView
extends AspectObserver {
    private static final String HIDE_STOP_PROMPT = "session.hide.stop.prompt";
    private static final String HIDE_RESTART_PROMPT = "session.hide.restart.prompt";
    private static final String CONFIRM_END_TITLE = "End Session";
    private static final String CONFIRM_END_MESSAGE = "Are you sure you want to end the current profiling session?";
    private static final String CONFIRM_RESTART_MESSAGE = "Selecting a different process stops the current profiler session and starts a new one. Do you want to continue?";
    private static final String CONFIRM_BUTTON_TEXT = "Yes";
    private static final String CANCEL_BUTTON_TEXT = "Cancel";
    public static final String SESSION_IS_COLLAPSED = "SESSION_IS_COLLAPSED";
    public static final String SESSION_EXPANDED_WIDTH = "SESSION_EXPANDED_WIDTH";
    @VisibleForTesting
    static final String NO_SUPPORTED_DEVICES = "No supported devices";
    @VisibleForTesting
    static final String NO_DEBUGGABLE_PROCESSES = "No debuggable processes";
    private static final int SESSIONS_COLLAPSED_MIN_WIDTH = JBUI.scale((int)32);
    private static final int SESSIONS_EXPANDED_MIN_WIDTH = JBUI.scale((int)200);
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final SessionsManager mySessionsManager;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final JButton myExpandButton;
    @NotNull
    private final JButton myCollapseButton;
    @NotNull
    private final JButton myStopProfilingButton;
    @NotNull
    private final CommonAction myProcessSelectionAction;
    @NotNull
    private final CommonDropDownButton myProcessSelectionDropDown;
    @NotNull
    private final JPanel mySessionsPanel;
    @NotNull
    ViewBinder<SessionArtifactView.ArtifactDrawInfo, SessionArtifact, SessionArtifactView> mySessionArtifactViewBinder;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    private boolean myIsCollapsed;

    public SessionsView(@NotNull StudioProfilers profilers, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (profilers == null) {
            SessionsView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            SessionsView.$$$reportNull$$$0(1);
        }
        this.myProfilers = profilers;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.mySessionsManager = this.myProfilers.getSessionsManager();
        this.myIsCollapsed = this.myProfilers.getIdeServices().getPersistentProfilerPreferences().getBoolean(SESSION_IS_COLLAPSED, false);
        this.myComponent = new JPanel(new BorderLayout());
        this.myComponent.setBorder(AdtUiUtils.DEFAULT_RIGHT_BORDER);
        this.myExpandButton = new CommonButton(StudioIcons.Profiler.Toolbar.EXPAND_SESSION);
        this.myExpandButton.setAlignmentX(0.5f);
        this.myExpandButton.setAlignmentY(0.5f);
        this.myExpandButton.setBorder(ProfilerLayout.TOOLBAR_ICON_BORDER);
        this.myExpandButton.setToolTipText("Expand the Sessions panel.");
        this.myExpandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionsView.this.myIsCollapsed = false;
                SessionsView.this.initializeUI();
                SessionsView.this.myProfilers.getIdeServices().getPersistentProfilerPreferences().setBoolean(SessionsView.SESSION_IS_COLLAPSED, SessionsView.this.myIsCollapsed);
            }
        });
        this.myCollapseButton = new CommonButton(StudioIcons.Profiler.Toolbar.COLLAPSE_SESSION);
        this.myCollapseButton.setAlignmentX(0.5f);
        this.myCollapseButton.setAlignmentY(0.5f);
        this.myCollapseButton.setBorder(ProfilerLayout.TOOLBAR_ICON_BORDER);
        this.myCollapseButton.setToolTipText("Collapse the Sessions panel.");
        this.myCollapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionsView.this.myIsCollapsed = true;
                SessionsView.this.initializeUI();
                SessionsView.this.myProfilers.getIdeServices().getPersistentProfilerPreferences().setBoolean(SessionsView.SESSION_IS_COLLAPSED, SessionsView.this.myIsCollapsed);
            }
        });
        this.myStopProfilingButton = new CommonButton(StudioIcons.Profiler.Toolbar.STOP_SESSION);
        this.myStopProfilingButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_SESSION));
        this.myStopProfilingButton.setAlignmentX(0.5f);
        this.myStopProfilingButton.setAlignmentY(0.5f);
        this.myStopProfilingButton.setBorder(ProfilerLayout.TOOLBAR_ICON_BORDER);
        this.myStopProfilingButton.setToolTipText("Stop the current profiling session.");
        this.myStopProfilingButton.setEnabled(false);
        this.myStopProfilingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean confirmed = true;
                if (!SessionsView.this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().getBoolean(SessionsView.HIDE_STOP_PROMPT, false)) {
                    confirmed = SessionsView.this.myIdeProfilerComponents.createUiMessageHandler().displayOkCancelMessage(SessionsView.CONFIRM_END_TITLE, SessionsView.CONFIRM_END_MESSAGE, SessionsView.CONFIRM_BUTTON_TEXT, SessionsView.CANCEL_BUTTON_TEXT, null, (Consumer<Boolean>)((Consumer)result -> SessionsView.this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(SessionsView.HIDE_STOP_PROMPT, (boolean)result)));
                }
                if (confirmed) {
                    SessionsView.this.stopProfilingSession();
                }
            }
        });
        this.myProcessSelectionAction = new CommonAction("", AllIcons.General.Add);
        this.myProcessSelectionAction.setAction(() -> this.myProfilers.getIdeServices().getFeatureTracker().trackSessionDropdownClicked());
        this.myProcessSelectionDropDown = new CommonDropDownButton(this.myProcessSelectionAction);
        this.myProcessSelectionDropDown.setToolTipText("Start a new profiling session.");
        this.myProcessSelectionDropDown.setAlignmentX(0.5f);
        this.myProcessSelectionDropDown.setAlignmentY(0.5f);
        this.myProcessSelectionDropDown.setBorder(ProfilerLayout.TOOLBAR_ICON_BORDER);
        this.myProfilers.addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, this::refreshProcessDropdown);
        this.mySessionsManager.addDependency(this).onChange((Enum)SessionAspect.SESSIONS, this::refreshSessions).onChange((Enum)SessionAspect.PROFILING_SESSION, () -> this.myStopProfilingButton.setEnabled(!Common.Session.getDefaultInstance().equals((Object)this.mySessionsManager.getProfilingSession())));
        this.mySessionsPanel = new JPanel();
        this.mySessionsPanel.setLayout((LayoutManager)new TabularLayout("*"));
        this.mySessionsPanel.setOpaque(false);
        this.myScrollPane = new JBScrollPane((Component)this.mySessionsPanel);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        this.mySessionArtifactViewBinder = new ViewBinder();
        this.mySessionArtifactViewBinder.bind(SessionItem.class, SessionItemView::new);
        this.mySessionArtifactViewBinder.bind(HprofSessionArtifact.class, HprofArtifactView::new);
        this.mySessionArtifactViewBinder.bind(LegacyAllocationsSessionArtifact.class, LegacyAllocationsArtifactView::new);
        this.mySessionArtifactViewBinder.bind(CpuCaptureSessionArtifact.class, CpuCaptureArtifactView::new);
        this.initializeUI();
        this.refreshProcessDropdown();
    }

    @NotNull
    public StudioProfilers getProfilers() {
        StudioProfilers studioProfilers = this.myProfilers;
        if (studioProfilers == null) {
            SessionsView.$$$reportNull$$$0(2);
        }
        return studioProfilers;
    }

    @NotNull
    public IdeProfilerComponents getIdeProfilerComponents() {
        IdeProfilerComponents ideProfilerComponents = this.myIdeProfilerComponents;
        if (ideProfilerComponents == null) {
            SessionsView.$$$reportNull$$$0(3);
        }
        return ideProfilerComponents;
    }

    @NotNull
    public static Dimension getComponentMinimizeSize(boolean isExpanded) {
        return isExpanded ? new Dimension(SESSIONS_EXPANDED_MIN_WIDTH, 0) : new Dimension(SESSIONS_COLLAPSED_MIN_WIDTH, 0);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            SessionsView.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @VisibleForTesting
    public boolean getCollapsed() {
        return this.myIsCollapsed;
    }

    @VisibleForTesting
    @NotNull
    JComponent getSessionsPanel() {
        JPanel jPanel = this.mySessionsPanel;
        if (jPanel == null) {
            SessionsView.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @VisibleForTesting
    @NotNull
    CommonAction getProcessSelectionAction() {
        CommonAction commonAction = this.myProcessSelectionAction;
        if (commonAction == null) {
            SessionsView.$$$reportNull$$$0(6);
        }
        return commonAction;
    }

    @VisibleForTesting
    @NotNull
    JButton getStopProfilingButton() {
        JButton jButton = this.myStopProfilingButton;
        if (jButton == null) {
            SessionsView.$$$reportNull$$$0(7);
        }
        return jButton;
    }

    @VisibleForTesting
    @NotNull
    public JButton getExpandButton() {
        JButton jButton = this.myExpandButton;
        if (jButton == null) {
            SessionsView.$$$reportNull$$$0(8);
        }
        return jButton;
    }

    @VisibleForTesting
    @NotNull
    public JButton getCollapseButton() {
        JButton jButton = this.myCollapseButton;
        if (jButton == null) {
            SessionsView.$$$reportNull$$$0(9);
        }
        return jButton;
    }

    public void addExpandListener(@NotNull ActionListener listener) {
        if (listener == null) {
            SessionsView.$$$reportNull$$$0(10);
        }
        this.myExpandButton.addActionListener(listener);
    }

    public void addCollapseListener(@NotNull ActionListener listener) {
        if (listener == null) {
            SessionsView.$$$reportNull$$$0(11);
        }
        this.myCollapseButton.addActionListener(listener);
    }

    private void initializeUI() {
        this.myComponent.removeAll();
        if (this.myIsCollapsed) {
            this.myComponent.add((Component)this.createToolbar(), "Center");
        } else {
            this.myComponent.add((Component)this.createToolbar(), "North");
            this.myComponent.add((Component)this.myScrollPane, "Center");
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    @NotNull
    private JComponent createToolbar() {
        JPanel toolbar;
        if (this.myIsCollapsed) {
            toolbar = new JPanel();
            toolbar.setLayout(new BoxLayout(toolbar, 1));
            toolbar.setMinimumSize(new Dimension(SESSIONS_COLLAPSED_MIN_WIDTH, 0));
            toolbar.add(this.myExpandButton);
            this.myExpandButton.setVisible(true);
            toolbar.add((Component)this.myCollapseButton, new TabularLayout.Constraint(1, 0, 1, 3));
            this.myCollapseButton.setVisible(false);
            toolbar.add(this.myStopProfilingButton);
            toolbar.add((Component)this.myProcessSelectionDropDown);
        } else {
            toolbar = new JPanel();
            toolbar.setLayout(new BoxLayout(toolbar, 0));
            toolbar.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
            toolbar.setMinimumSize(new Dimension(SESSIONS_EXPANDED_MIN_WIDTH, ProfilerLayout.TOOLBAR_HEIGHT));
            toolbar.setPreferredSize(new Dimension(SESSIONS_EXPANDED_MIN_WIDTH, ProfilerLayout.TOOLBAR_HEIGHT));
            JLabel label = new JLabel("SESSIONS");
            label.setAlignmentY(0.5f);
            label.setBorder(ProfilerLayout.TOOLBAR_LABEL_BORDER);
            label.setFont(ProfilerFonts.SMALL_FONT);
            label.setForeground(StandardColors.TEXT_COLOR);
            toolbar.add(label);
            toolbar.add(Box.createHorizontalGlue());
            toolbar.add((Component)this.myProcessSelectionDropDown);
            toolbar.add(this.myStopProfilingButton);
            toolbar.add(this.myCollapseButton);
            this.myCollapseButton.setVisible(true);
            toolbar.add(this.myExpandButton);
            this.myExpandButton.setVisible(false);
        }
        JPanel jPanel = toolbar;
        if (jPanel == null) {
            SessionsView.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    private void refreshSessions() {
        List<SessionArtifact> sessionItems = this.mySessionsManager.getSessionArtifacts();
        this.mySessionsPanel.removeAll();
        for (int i = 0; i < sessionItems.size(); ++i) {
            SessionArtifact item = sessionItems.get(i);
            SessionArtifactView.ArtifactDrawInfo drawInfo = new SessionArtifactView.ArtifactDrawInfo(this, i);
            this.mySessionsPanel.add((Component)this.mySessionArtifactViewBinder.build((Object)drawInfo, (Object)item), new TabularLayout.Constraint(i, 0));
        }
        this.mySessionsPanel.revalidate();
        this.mySessionsPanel.repaint();
    }

    private void addImportAction() {
        CommonAction loadAction = new CommonAction("Load from file...", null);
        loadAction.setAction(() -> this.myIdeProfilerComponents.createImportDialog().open(() -> "Open", (List<String>)ImmutableList.of((Object)"hprof", (Object)"trace"), file -> {
            if (!this.myProfilers.getSessionsManager().importSessionFromFile(new File(file.getPath()))) {
                this.myIdeProfilerComponents.createUiMessageHandler().displayErrorMessage(this.myComponent, "File Open Error", String.format("Unknown file type: %s", file.getPath()));
            }
        }));
        this.myProcessSelectionAction.addChildrenActions(new CommonAction[]{loadAction, new CommonAction.SeparatorAction()});
    }

    void stopProfilingSession() {
        this.myProfilers.setAutoProfilingEnabled(false);
        this.myProfilers.setProcess(null, null);
        this.myProfilers.getIdeServices().getFeatureTracker().trackStopSession();
    }

    private void refreshProcessDropdown() {
        Map<Common.Device, List<Common.Process>> processMap = this.myProfilers.getDeviceProcessMap();
        this.myProcessSelectionAction.clear();
        this.addImportAction();
        Set devices = processMap.keySet().stream().filter(device -> device.getState() == Common.Device.State.ONLINE).collect(Collectors.toSet());
        if (devices.isEmpty()) {
            CommonAction noDeviceAction = new CommonAction(NO_SUPPORTED_DEVICES, null);
            noDeviceAction.setEnabled(false);
            this.myProcessSelectionAction.addChildrenActions(new CommonAction[]{noDeviceAction});
        } else {
            for (Common.Device device2 : devices) {
                CommonAction deviceAction = new CommonAction(StudioProfilers.buildDeviceName(device2), null);
                List processes = processMap.get(device2).stream().filter(process -> process.getState() == Common.Process.State.ALIVE).collect(Collectors.toList());
                if (processes.isEmpty()) {
                    String noProcessReason = device2.getUnsupportedReason().isEmpty() ? NO_DEBUGGABLE_PROCESSES : device2.getUnsupportedReason();
                    CommonAction noProcessAction = new CommonAction(noProcessReason, null);
                    noProcessAction.setEnabled(false);
                    deviceAction.addChildrenActions(new CommonAction[]{noProcessAction});
                } else {
                    ArrayList<CommonAction> preferredProcessActions = new ArrayList<CommonAction>();
                    ArrayList<CommonAction> otherProcessActions = new ArrayList<CommonAction>();
                    for (Common.Process process2 : processes) {
                        CommonAction processAction = new CommonAction(String.format("%s (%d)", process2.getName(), process2.getPid()), null);
                        processAction.setAction(() -> {
                            if (SessionsManager.isSessionAlive(this.myProfilers.getSessionsManager().getProfilingSession())) {
                                boolean confirmed = true;
                                if (!this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().getBoolean(HIDE_RESTART_PROMPT, false)) {
                                    confirmed = this.myIdeProfilerComponents.createUiMessageHandler().displayOkCancelMessage(CONFIRM_END_TITLE, CONFIRM_RESTART_MESSAGE, CONFIRM_BUTTON_TEXT, CANCEL_BUTTON_TEXT, null, (Consumer<Boolean>)((Consumer)result -> this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(HIDE_RESTART_PROMPT, (boolean)result)));
                                }
                                if (!confirmed) {
                                    return;
                                }
                                this.stopProfilingSession();
                            }
                            this.myProfilers.setProcess(device2, process2);
                            this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.FULL, SessionsManager.SessionCreationSource.MANUAL);
                        });
                        String preferredProcess = this.myProfilers.getPreferredProcessName();
                        if (preferredProcess != null && process2.getName().startsWith(preferredProcess)) {
                            preferredProcessActions.add(processAction);
                            continue;
                        }
                        otherProcessActions.add(processAction);
                    }
                    if (!preferredProcessActions.isEmpty()) {
                        preferredProcessActions.sort(Comparator.comparing(CommonAction::getText, Ordering.natural()));
                        deviceAction.addChildrenActions(preferredProcessActions);
                    }
                    if (!otherProcessActions.isEmpty()) {
                        if (deviceAction.getChildrenActionCount() != 0) {
                            deviceAction.addChildrenActions(new CommonAction[]{new CommonAction.SeparatorAction()});
                        }
                        CommonAction otherProcessesFlyout = new CommonAction("Other processes", null);
                        otherProcessActions.sort(Comparator.comparing(CommonAction::getText, Ordering.natural()));
                        otherProcessesFlyout.addChildrenActions(otherProcessActions);
                        deviceAction.addChildrenActions(new CommonAction[]{otherProcessesFlyout});
                    }
                }
                this.myProcessSelectionAction.addChildrenActions(new CommonAction[]{deviceAction});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/sessions/SessionsView";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/sessions/SessionsView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProfilerComponents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionsPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessSelectionAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStopProfilingButton";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandButton";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapseButton";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addExpandListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCollapseListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

