/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SessionItem
extends AspectModel<Aspect>
implements SessionArtifact<Common.Session> {
    private static final String SESSION_INITIALIZING = "Starting...";
    @VisibleForTesting
    static final String SESSION_LOADING = "Loading...";
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private Common.Session mySession;
    @NotNull
    private final Common.SessionMetaData mySessionMetaData;
    private long myDurationNs;
    private boolean myWaitingForAgent;
    @NotNull
    private List<SessionArtifact> myChildArtifacts;

    public SessionItem(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData metaData) {
        if (profilers == null) {
            SessionItem.$$$reportNull$$$0(0);
        }
        if (session == null) {
            SessionItem.$$$reportNull$$$0(1);
        }
        if (metaData == null) {
            SessionItem.$$$reportNull$$$0(2);
        }
        this.myChildArtifacts = Collections.emptyList();
        this.myProfilers = profilers;
        this.mySession = session;
        this.mySessionMetaData = metaData;
        if (!SessionsManager.isSessionAlive(this.mySession)) {
            this.myDurationNs = this.mySession.getEndTimestamp() - this.mySession.getStartTimestamp();
        }
        profilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.agentStatusChanged();
    }

    @Override
    @NotNull
    public Common.Session getArtifactProto() {
        Common.Session session = this.mySession;
        if (session == null) {
            SessionItem.$$$reportNull$$$0(3);
        }
        return session;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        StudioProfilers studioProfilers = this.myProfilers;
        if (studioProfilers == null) {
            SessionItem.$$$reportNull$$$0(4);
        }
        return studioProfilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySession;
        if (session == null) {
            SessionItem.$$$reportNull$$$0(5);
        }
        return session;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        Common.SessionMetaData sessionMetaData = this.mySessionMetaData;
        if (sessionMetaData == null) {
            SessionItem.$$$reportNull$$$0(6);
        }
        return sessionMetaData;
    }

    @VisibleForTesting
    @NotNull
    List<SessionArtifact> getChildArtifacts() {
        List<SessionArtifact> list = this.myChildArtifacts;
        if (list == null) {
            SessionItem.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.mySessionMetaData.getSessionName();
        if (this.mySessionMetaData.getType() != Common.SessionMetaData.SessionType.FULL) {
            String string = name;
            if (string == null) {
                SessionItem.$$$reportNull$$$0(8);
            }
            return string;
        }
        int firstSpace = name.indexOf(32);
        assert (firstSpace != -1);
        String appName = name.substring(0, firstSpace);
        int lastDot = appName.lastIndexOf(46);
        if (lastDot != -1) {
            appName = appName.substring(lastDot + 1);
        }
        String string = appName + name.substring(firstSpace);
        if (string == null) {
            SessionItem.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getSubtitle() {
        if (this.mySessionMetaData.getType() != Common.SessionMetaData.SessionType.FULL) {
            if (!this.myChildArtifacts.isEmpty()) {
                assert (this.myChildArtifacts.size() == 1);
                String string = this.myChildArtifacts.get(0).getName();
                if (string == null) {
                    SessionItem.$$$reportNull$$$0(10);
                }
                return string;
            }
            return SESSION_LOADING;
        }
        if (this.myWaitingForAgent) {
            return SESSION_INITIALIZING;
        }
        long durationUs = TimeUnit.NANOSECONDS.toMicros(this.myDurationNs);
        String string = TimeFormatter.getMultiUnitDurationString((long)durationUs);
        if (string == null) {
            SessionItem.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public long getTimestampNs() {
        return 0L;
    }

    @Override
    public boolean isOngoing() {
        return SessionsManager.isSessionAlive(this.mySession);
    }

    public void setSession(@NotNull Common.Session session) {
        if (session == null) {
            SessionItem.$$$reportNull$$$0(12);
        }
        assert (session.getSessionId() == this.mySession.getSessionId());
        this.mySession = session;
    }

    public void setChildArtifacts(@NotNull List<SessionArtifact> childArtifacts) {
        if (childArtifacts == null) {
            SessionItem.$$$reportNull$$$0(13);
        }
        this.myChildArtifacts = childArtifacts;
        this.changed(Aspect.MODEL);
    }

    @Override
    public void onSelect() {
        this.myProfilers.getSessionsManager().setSession(this.mySession);
        if (this.mySessionMetaData.getType() == Common.SessionMetaData.SessionType.FULL && !this.myProfilers.getStageClass().equals(StudioMonitorStage.class)) {
            this.myProfilers.setStage(new StudioMonitorStage(this.myProfilers));
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.myProfilers.getSessionsManager().isSessionAlive());
    }

    @Override
    public void update(long elapsedNs) {
        if (SessionsManager.isSessionAlive(this.mySession)) {
            this.myDurationNs += elapsedNs;
            this.changed(Aspect.MODEL);
        }
    }

    private void agentStatusChanged() {
        Common.AgentData agentData;
        boolean oldValue = this.myWaitingForAgent;
        this.myWaitingForAgent = SessionsManager.isSessionAlive(this.mySession) && this.mySession.equals((Object)this.myProfilers.getSessionsManager().getSelectedSession()) ? (agentData = this.myProfilers.getAgentData()).getStatus() == Common.AgentData.Status.UNSPECIFIED : false;
        if (oldValue != this.myWaitingForAgent) {
            this.changed(Aspect.MODEL);
        }
    }

    public void deleteSession() {
        this.myProfilers.getSessionsManager().deleteSession(this.mySession);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/sessions/SessionItem";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/sessions/SessionItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactProto";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionMetaData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildArtifacts";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setChildArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        MODEL;

    }
}

