/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.network.NetworkTrafficDataSeries;
import org.jetbrains.annotations.NotNull;

public class NetworkUsage
extends LineChartModel {
    @NotNull
    private final RangedContinuousSeries myRxSeries;
    @NotNull
    private final RangedContinuousSeries myTxSeries;
    @NotNull
    private final Range myTrafficRange;

    public NetworkUsage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            NetworkUsage.$$$reportNull$$$0(0);
        }
        Range viewRange = profilers.getTimeline().getViewRange();
        Range dataRange = profilers.getTimeline().getDataRange();
        this.myTrafficRange = new Range(0.0, 4.0);
        this.myRxSeries = new RangedContinuousSeries(NetworkTrafficDataSeries.Type.BYTES_RECEIVED.getLabel(false), viewRange, this.myTrafficRange, this.createSeries(profilers, NetworkTrafficDataSeries.Type.BYTES_RECEIVED), dataRange);
        this.myTxSeries = new RangedContinuousSeries(NetworkTrafficDataSeries.Type.BYTES_SENT.getLabel(false), viewRange, this.myTrafficRange, this.createSeries(profilers, NetworkTrafficDataSeries.Type.BYTES_SENT), dataRange);
        this.add(this.myRxSeries);
        this.add(this.myTxSeries);
    }

    @NotNull
    public DataSeries<Long> createSeries(@NotNull StudioProfilers profilers, @NotNull NetworkTrafficDataSeries.Type trafficType) {
        if (profilers == null) {
            NetworkUsage.$$$reportNull$$$0(1);
        }
        if (trafficType == null) {
            NetworkUsage.$$$reportNull$$$0(2);
        }
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return new UnifiedEventDataSeries<Long>(profilers.getClient().getTransportClient(), profilers.getSession().getStreamId(), profilers.getSession().getPid(), Common.Event.Kind.NETWORK_SPEED, trafficType == NetworkTrafficDataSeries.Type.BYTES_SENT ? 101 : 102, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getNetworkSpeed().getThroughput()));
        }
        NetworkServiceGrpc.NetworkServiceBlockingStub client = profilers.getClient().getNetworkClient();
        return new NetworkTrafficDataSeries(client, profilers.getSession(), trafficType);
    }

    @NotNull
    public RangedContinuousSeries getRxSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myRxSeries;
        if (rangedContinuousSeries == null) {
            NetworkUsage.$$$reportNull$$$0(3);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getTxSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myTxSeries;
        if (rangedContinuousSeries == null) {
            NetworkUsage.$$$reportNull$$$0(4);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public Range getTrafficRange() {
        Range range = this.myTrafficRange;
        if (range == null) {
            NetworkUsage.$$$reportNull$$$0(5);
        }
        return range;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trafficType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/NetworkUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/NetworkUsage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRxSeries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTxSeries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrafficRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSeries";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

