/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.NetworkTrafficFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.network.DetailedNetworkUsage;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.LegacyRpcNetworkConnectionsModel;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkTrafficDataSeries;
import com.android.tools.profilers.network.RpcNetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkProfilerStage
extends StreamingStage
implements CodeNavigator.Listener {
    private static final String HAS_USED_NETWORK_SELECTION = "network.used.selection";
    private static final BaseAxisFormatter TRAFFIC_AXIS_FORMATTER = new NetworkTrafficFormatter(1, 5, 5);
    private static final BaseAxisFormatter CONNECTIONS_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 5, 1, "");
    @Nullable
    private HttpData mySelectedConnection;
    private AspectObserver myAspectObserver = new AspectObserver();
    private AspectModel<NetworkProfilerAspect> myAspect = new AspectModel();
    private final NetworkConnectionsModel myConnectionsModel;
    private final DetailedNetworkUsage myDetailedNetworkUsage;
    private final NetworkStageLegends myLegends;
    private final NetworkStageLegends myTooltipLegends;
    private final ClampedAxisComponentModel myTrafficAxis;
    private final ClampedAxisComponentModel myConnectionsAxis;
    private final EventMonitor myEventMonitor;
    private final StackTraceModel myStackTraceModel;
    private final RangeSelectionModel myRangeSelectionModel;
    private final HttpDataFetcher myHttpDataFetcher;
    private final EaseOutModel myInstructionsEaseOutModel;

    public NetworkProfilerStage(final StudioProfilers profilers) {
        super(profilers);
        this.myDetailedNetworkUsage = new DetailedNetworkUsage(profilers);
        this.myTrafficAxis = new ClampedAxisComponentModel.Builder(this.myDetailedNetworkUsage.getTrafficRange(), TRAFFIC_AXIS_FORMATTER).build();
        this.myConnectionsAxis = new ClampedAxisComponentModel.Builder(this.myDetailedNetworkUsage.getConnectionsRange(), CONNECTIONS_AXIS_FORMATTER).build();
        this.myLegends = new NetworkStageLegends(this.myDetailedNetworkUsage, this.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new NetworkStageLegends(this.myDetailedNetworkUsage, this.getTimeline().getTooltipRange(), true);
        this.myEventMonitor = new EventMonitor(profilers);
        this.myStackTraceModel = new StackTraceModel(profilers.getIdeServices().getCodeNavigator());
        this.myRangeSelectionModel = new RangeSelectionModel(this.getTimeline().getSelectionRange());
        profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, () -> this.myRangeSelectionModel.setSelectionEnabled(profilers.isAgentAttached()));
        this.myRangeSelectionModel.setSelectionEnabled(profilers.isAgentAttached());
        this.myRangeSelectionModel.addListener(new RangeSelectionListener(){

            public void selectionCreated() {
                NetworkProfilerStage.this.setProfilerMode(ProfilerMode.EXPANDED);
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
                profilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(NetworkProfilerStage.HAS_USED_NETWORK_SELECTION, true);
                NetworkProfilerStage.this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }

            public void selectionCleared() {
                NetworkProfilerStage.this.setProfilerMode(ProfilerMode.NORMAL);
            }
        });
        this.myConnectionsModel = profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled() ? new RpcNetworkConnectionsModel(profilers.getClient().getTransportClient(), profilers.getSession()) : new LegacyRpcNetworkConnectionsModel(profilers.getClient().getTransportClient(), profilers.getClient().getNetworkClient(), profilers.getSession());
        this.myHttpDataFetcher = new HttpDataFetcher(this.myConnectionsModel, this.getTimeline().getSelectionRange());
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
    }

    public boolean hasUserUsedNetworkSelection() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_NETWORK_SELECTION, false);
    }

    @NotNull
    public NetworkConnectionsModel getConnectionsModel() {
        NetworkConnectionsModel networkConnectionsModel = this.myConnectionsModel;
        if (networkConnectionsModel == null) {
            NetworkProfilerStage.$$$reportNull$$$0(0);
        }
        return networkConnectionsModel;
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        RangeSelectionModel rangeSelectionModel = this.myRangeSelectionModel;
        if (rangeSelectionModel == null) {
            NetworkProfilerStage.$$$reportNull$$$0(1);
        }
        return rangeSelectionModel;
    }

    @NotNull
    public StackTraceModel getStackTraceModel() {
        StackTraceModel stackTraceModel = this.myStackTraceModel;
        if (stackTraceModel == null) {
            NetworkProfilerStage.$$$reportNull$$$0(2);
        }
        return stackTraceModel;
    }

    @NotNull
    public HttpDataFetcher getHttpDataFetcher() {
        HttpDataFetcher httpDataFetcher = this.myHttpDataFetcher;
        if (httpDataFetcher == null) {
            NetworkProfilerStage.$$$reportNull$$$0(3);
        }
        return httpDataFetcher;
    }

    public boolean setSelectedConnection(@Nullable HttpData data) {
        if (Objects.equals(this.mySelectedConnection, data)) {
            return false;
        }
        this.mySelectedConnection = data;
        this.getAspect().changed((Enum)NetworkProfilerAspect.SELECTED_CONNECTION);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectNetworkRequest();
        return true;
    }

    @Nullable
    public HttpData getSelectedConnection() {
        return this.mySelectedConnection;
    }

    @NotNull
    public AspectModel<NetworkProfilerAspect> getAspect() {
        AspectModel<NetworkProfilerAspect> aspectModel = this.myAspect;
        if (aspectModel == null) {
            NetworkProfilerStage.$$$reportNull$$$0(4);
        }
        return aspectModel;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedNetworkUsage);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTrafficAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myConnectionsAxis);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedNetworkUsage);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTrafficAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myConnectionsAxis);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.myRangeSelectionModel.clearListeners();
    }

    @NotNull
    public String getName() {
        return "NETWORK";
    }

    @NotNull
    public DetailedNetworkUsage getDetailedNetworkUsage() {
        DetailedNetworkUsage detailedNetworkUsage = this.myDetailedNetworkUsage;
        if (detailedNetworkUsage == null) {
            NetworkProfilerStage.$$$reportNull$$$0(5);
        }
        return detailedNetworkUsage;
    }

    @NotNull
    public AxisComponentModel getTrafficAxis() {
        ClampedAxisComponentModel clampedAxisComponentModel = this.myTrafficAxis;
        if (clampedAxisComponentModel == null) {
            NetworkProfilerStage.$$$reportNull$$$0(6);
        }
        return clampedAxisComponentModel;
    }

    @NotNull
    public AxisComponentModel getConnectionsAxis() {
        ClampedAxisComponentModel clampedAxisComponentModel = this.myConnectionsAxis;
        if (clampedAxisComponentModel == null) {
            NetworkProfilerStage.$$$reportNull$$$0(7);
        }
        return clampedAxisComponentModel;
    }

    @NotNull
    public NetworkStageLegends getLegends() {
        NetworkStageLegends networkStageLegends = this.myLegends;
        if (networkStageLegends == null) {
            NetworkProfilerStage.$$$reportNull$$$0(8);
        }
        return networkStageLegends;
    }

    @NotNull
    public NetworkStageLegends getTooltipLegends() {
        NetworkStageLegends networkStageLegends = this.myTooltipLegends;
        if (networkStageLegends == null) {
            NetworkProfilerStage.$$$reportNull$$$0(9);
        }
        return networkStageLegends;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        EaseOutModel easeOutModel = this.myInstructionsEaseOutModel;
        if (easeOutModel == null) {
            NetworkProfilerStage.$$$reportNull$$$0(10);
        }
        return easeOutModel;
    }

    @NotNull
    public EventMonitor getEventMonitor() {
        EventMonitor eventMonitor = this.myEventMonitor;
        if (eventMonitor == null) {
            NetworkProfilerStage.$$$reportNull$$$0(11);
        }
        return eventMonitor;
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            NetworkProfilerStage.$$$reportNull$$$0(12);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/NetworkProfilerStage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionsModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeSelectionModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTraceModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpDataFetcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailedNetworkUsage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrafficAxis";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionsAxis";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegends";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipLegends";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionsEaseOutModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMonitor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/NetworkProfilerStage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NetworkStageLegends
    extends LegendComponentModel {
        private final SeriesLegend myRxLegend;
        private final SeriesLegend myTxLegend;
        private final SeriesLegend myConnectionLegend;

        public NetworkStageLegends(DetailedNetworkUsage usage, Range range, boolean tooltip) {
            super(range);
            this.myRxLegend = new SeriesLegend(usage.getRxSeries(), TRAFFIC_AXIS_FORMATTER, range, NetworkTrafficDataSeries.Type.BYTES_RECEIVED.getLabel(tooltip), Interpolatable.SegmentInterpolator);
            this.myTxLegend = new SeriesLegend(usage.getTxSeries(), TRAFFIC_AXIS_FORMATTER, range, NetworkTrafficDataSeries.Type.BYTES_SENT.getLabel(tooltip), Interpolatable.SegmentInterpolator);
            this.myConnectionLegend = new SeriesLegend(usage.getConnectionSeries(), CONNECTIONS_AXIS_FORMATTER, range, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myRxLegend);
            this.add((Legend)this.myTxLegend);
            this.add((Legend)this.myConnectionLegend);
        }

        public SeriesLegend getRxLegend() {
            return this.myRxLegend;
        }

        public SeriesLegend getTxLegend() {
            return this.myTxLegend;
        }

        public SeriesLegend getConnectionLegend() {
            return this.myConnectionLegend;
        }
    }
}

