/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.profilers.BorderlessTableCellRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.TimelineTable;
import com.android.tools.profilers.network.ConnectionsStateChart;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

final class ConnectionsView {
    @NotNull
    private final NetworkProfilerStage myStage;
    @NotNull
    private final ConnectionsTableModel myTableModel;
    @NotNull
    private final JTable myConnectionsTable;
    @NotNull
    private final AspectObserver myAspectObserver;

    ConnectionsView(@NotNull NetworkProfilerStageView stageView) {
        if (stageView == null) {
            ConnectionsView.$$$reportNull$$$0(0);
        }
        this.myStage = (NetworkProfilerStage)stageView.getStage();
        this.myTableModel = new ConnectionsTableModel(this.myStage.getHttpDataFetcher());
        this.myConnectionsTable = TimelineTable.create(this.myTableModel, (Timeline)this.myStage.getTimeline(), Column.TIMELINE.ordinal());
        this.customizeConnectionsTable();
        this.createTooltip(stageView);
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, this::updateTableSelection);
    }

    @NotNull
    public JComponent getComponent() {
        JTable jTable = this.myConnectionsTable;
        if (jTable == null) {
            ConnectionsView.$$$reportNull$$$0(1);
        }
        return jTable;
    }

    private void customizeConnectionsTable() {
        this.myConnectionsTable.setAutoCreateRowSorter(true);
        this.myConnectionsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.SIZE.ordinal()).setCellRenderer(new SizeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TYPE.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.STATUS.ordinal()).setCellRenderer(new StatusRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIME.ordinal()).setCellRenderer(new TimeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer(new TimelineRenderer(this.myConnectionsTable, this.myStage.getTimeline()));
        this.myConnectionsTable.setSelectionMode(0);
        this.myConnectionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedRow = this.myConnectionsTable.getSelectedRow();
            if (0 <= selectedRow && selectedRow < this.myTableModel.getRowCount()) {
                int modelRow = this.myConnectionsTable.convertRowIndexToModel(selectedRow);
                this.myStage.setSelectedConnection(this.myTableModel.getHttpData(modelRow));
            }
        });
        this.myConnectionsTable.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myConnectionsTable.setShowVerticalLines(true);
        this.myConnectionsTable.setShowHorizontalLines(false);
        int defaultFontHeight = this.myConnectionsTable.getFontMetrics(this.myConnectionsTable.getFont()).getHeight();
        this.myConnectionsTable.setRowMargin(0);
        this.myConnectionsTable.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myConnectionsTable.setFocusTraversalKeys(0, null);
        this.myConnectionsTable.setFocusTraversalKeys(1, null);
        this.myConnectionsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (int i = 0; i < Column.values().length; ++i) {
                    Column column = Column.values()[i];
                    ConnectionsView.this.myConnectionsTable.getColumnModel().getColumn(i).setPreferredWidth((int)((double)ConnectionsView.this.myConnectionsTable.getWidth() * column.getWidthPercentage()));
                }
            }
        });
        this.myStage.getHttpDataFetcher().addListener(httpDataList -> this.updateTableSelection());
    }

    private void createTooltip(@NotNull StageView stageView) {
        if (stageView == null) {
            ConnectionsView.$$$reportNull$$$0(2);
        }
        final JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        textPane.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        textPane.setForeground(ProfilerColors.TOOLTIP_TEXT);
        textPane.setFont(TooltipView.TOOLTIP_BODY_FONT);
        final TooltipComponent tooltip = new TooltipComponent.Builder((JComponent)textPane, (JComponent)this.myConnectionsTable, stageView.getProfilersView().getComponent()).build();
        tooltip.registerListenersOn((Component)this.myConnectionsTable);
        this.myConnectionsTable.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = ConnectionsView.this.myConnectionsTable.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    tooltip.setVisible(true);
                    String url = ConnectionsView.this.myTableModel.getHttpData(ConnectionsView.this.myConnectionsTable.convertRowIndexToModel(row)).getUrl();
                    textPane.setText(url);
                } else {
                    tooltip.setVisible(false);
                }
            }
        });
    }

    private void updateTableSelection() {
        HttpData selectedData = this.myStage.getSelectedConnection();
        if (selectedData != null) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.myTableModel.getHttpData(i).getId() != selectedData.getId()) continue;
                int row = this.myConnectionsTable.convertRowIndexToView(i);
                this.myConnectionsTable.setRowSelectionInterval(row, row);
                return;
            }
        } else {
            this.myConnectionsTable.clearSelection();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/ConnectionsView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/ConnectionsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TimelineRenderer
    extends TimelineTable.CellRenderer
    implements TableModelListener {
        @NotNull
        private final List<ConnectionsStateChart> myConnectionsCharts;
        @NotNull
        private final JTable myTable;

        TimelineRenderer(@NotNull JTable table, @NotNull StreamingTimeline timeline) {
            if (table == null) {
                TimelineRenderer.$$$reportNull$$$0(0);
            }
            if (timeline == null) {
                TimelineRenderer.$$$reportNull$$$0(1);
            }
            super((Timeline)timeline);
            this.myConnectionsCharts = new ArrayList<ConnectionsStateChart>();
            this.myTable = table;
            this.myTable.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.myTable.getModel()));
        }

        @Override
        @NotNull
        protected Component getTableCellRendererComponent(boolean isSelected, int row) {
            ConnectionsStateChart chart = this.myConnectionsCharts.get(this.myTable.convertRowIndexToModel(row));
            chart.getColors().setColorIndex(isSelected ? 1 : 0);
            JComponent jComponent = chart.getComponent();
            if (jComponent == null) {
                TimelineRenderer.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.myConnectionsCharts.clear();
            ConnectionsTableModel model = (ConnectionsTableModel)this.myTable.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                ConnectionsStateChart chart = new ConnectionsStateChart(model.getHttpData(i), this.getTimeline().getSelectionRange());
                chart.setHeightGap(0.3f);
                this.myConnectionsCharts.add(chart);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeline";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/ConnectionsView$TimelineRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/ConnectionsView$TimelineRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TimeRenderer
    extends BorderlessTableCellRenderer {
        private TimeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            Long durationUs = (Long)value;
            if (durationUs >= 0L) {
                long durationMs = TimeUnit.MICROSECONDS.toMillis(durationUs);
                this.setText(StringUtil.formatDuration((long)durationMs));
            } else {
                this.setText("");
            }
        }
    }

    private static final class StatusRenderer
    extends BorderlessTableCellRenderer {
        private StatusRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            Integer status = (Integer)value;
            this.setText(status > -1 ? Integer.toString(status) : "");
        }
    }

    private static final class SizeRenderer
    extends BorderlessTableCellRenderer {
        private SizeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            int bytes = (Integer)value;
            this.setText(bytes >= 0 ? NumberFormatter.formatFileSize((long)bytes) : "");
        }
    }

    private static final class ConnectionsTableModel
    extends AbstractTableModel {
        @NotNull
        private List<HttpData> myDataList = new ArrayList<HttpData>();

        private ConnectionsTableModel(HttpDataFetcher httpDataFetcher) {
            httpDataFetcher.addListener(httpDataList -> {
                this.myDataList = httpDataList;
                this.fireTableDataChanged();
            });
        }

        @Override
        public int getRowCount() {
            return this.myDataList.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return Column.values()[column].toDisplayString();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HttpData data = this.myDataList.get(rowIndex);
            return Column.values()[columnIndex].getValueFrom(data);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @NotNull
        public HttpData getHttpData(int rowIndex) {
            HttpData httpData = this.myDataList.get(rowIndex);
            if (httpData == null) {
                ConnectionsTableModel.$$$reportNull$$$0(0);
            }
            return httpData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/network/ConnectionsView$ConnectionsTableModel", "getHttpData"));
        }
    }

    @VisibleForTesting
    static enum Column {
        NAME(0.25, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return HttpData.getUrlName(data.getUrl());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$1", "getValueFrom"));
            }
        }
        ,
        SIZE(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return data.getResponsePayloadSize();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$2", "getValueFrom"));
            }
        }
        ,
        TYPE(0.0625, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    3.$$$reportNull$$$0(0);
                }
                HttpData.ContentType type = data.getResponseHeader().getContentType();
                String[] mimeTypeParts = type.getMimeType().split("/");
                return mimeTypeParts[mimeTypeParts.length - 1];
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$3", "getValueFrom"));
            }
        }
        ,
        STATUS(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    4.$$$reportNull$$$0(0);
                }
                return data.getResponseHeader().getStatusCode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$4", "getValueFrom"));
            }
        }
        ,
        TIME(0.0625, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    5.$$$reportNull$$$0(0);
                }
                return data.getConnectionEndTimeUs() - data.getRequestStartTimeUs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$5", "getValueFrom"));
            }
        }
        ,
        TIMELINE(0.5, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    6.$$$reportNull$$$0(0);
                }
                return data.getRequestStartTimeUs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$6", "getValueFrom"));
            }
        };

        private final double myWidthPercentage;
        private final Class<?> myType;

        private Column(double widthPercentage, Class<?> type) {
            this.myWidthPercentage = widthPercentage;
            this.myType = type;
        }

        public double getWidthPercentage() {
            return this.myWidthPercentage;
        }

        public Class<?> getType() {
            return this.myType;
        }

        public String toDisplayString() {
            return StringUtil.capitalize((String)this.name().toLowerCase(Locale.getDefault()));
        }

        abstract Object getValueFrom(@NotNull HttpData var1);
    }
}

