/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.instancefilters;

import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectClassesInstanceFilter
implements CaptureObjectInstanceFilter {
    @NotNull
    private final IdeProfilerServices myIdeProfilerServices;

    public ProjectClassesInstanceFilter(@NotNull IdeProfilerServices profilerServices) {
        if (profilerServices == null) {
            ProjectClassesInstanceFilter.$$$reportNull$$$0(0);
        }
        this.myIdeProfilerServices = profilerServices;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Project Classes";
    }

    @Override
    @NotNull
    public String getSummaryDescription() {
        return "Show instances of classes from only the current project.";
    }

    @Override
    @Nullable
    public String getDetailedDescription() {
        return null;
    }

    @Override
    @Nullable
    public String getDocumentationLink() {
        return null;
    }

    @Override
    public Set<InstanceObject> filter(@NotNull Set<InstanceObject> instances, @NotNull ClassDb classDatabase) {
        if (instances == null) {
            ProjectClassesInstanceFilter.$$$reportNull$$$0(1);
        }
        if (classDatabase == null) {
            ProjectClassesInstanceFilter.$$$reportNull$$$0(2);
        }
        Set<String> projectClasses = this.myIdeProfilerServices.getAllProjectClasses();
        return instances.stream().filter(instance -> {
            String className = instance.getClassEntry().getClassName();
            int innerClassStartIndex = className.indexOf("$");
            if (innerClassStartIndex != -1) {
                className = className.substring(0, innerClassStartIndex);
            }
            return projectClasses.contains(className);
        }).collect(Collectors.toSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerServices";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instances";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDatabase";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/adapters/instancefilters/ProjectClassesInstanceFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

