/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.instancefilters;

import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityFragmentLeakInstanceFilter
implements CaptureObjectInstanceFilter {
    @VisibleForTesting
    static final String ACTIVTY_CLASS_NAME = "android.app.Activity";
    @VisibleForTesting
    static final String NATIVE_FRAGMENT_CLASS_NAME = "android.app.Fragment";
    @VisibleForTesting
    static final String SUPPORT_FRAGMENT_CLASS_NAME = "android.support.v4.app.Fragment";
    @VisibleForTesting
    static final String ANDROIDX_FRAGMENT_CLASS_NAME = "androidx.fragment.app.Fragment";
    @VisibleForTesting
    static final String FINISHED_FIELD_NAME = "mFinished";
    @VisibleForTesting
    static final String DESTROYED_FIELD_NAME = "mDestroyed";
    @VisibleForTesting
    static final String FRAGFMENT_MANAGER_FIELD_NAME = "mFragmentManager";
    private static final Set<String> FRAGMENT_CLASS_NAMES = ImmutableSet.of((Object)"android.app.Fragment", (Object)"android.support.v4.app.Fragment", (Object)"androidx.fragment.app.Fragment");

    @Override
    @NotNull
    public String getDisplayName() {
        return "Activity/Fragment Leaks";
    }

    @Override
    @NotNull
    public String getSummaryDescription() {
        return "Show Activities and Fragments that are potentially causing memory leaks.";
    }

    @Override
    @Nullable
    public String getDetailedDescription() {
        return "Activity/Fragment leaks may include false positives.";
    }

    @Override
    @Nullable
    public String getDocumentationLink() {
        return "https://developer.android.com/r/studio-ui/profiler-memory-leak-detection";
    }

    @Override
    public Set<InstanceObject> filter(@NotNull Set<InstanceObject> instances, @NotNull ClassDb classDatabase) {
        if (instances == null) {
            ActivityFragmentLeakInstanceFilter.$$$reportNull$$$0(0);
        }
        if (classDatabase == null) {
            ActivityFragmentLeakInstanceFilter.$$$reportNull$$$0(1);
        }
        Set allActivitySubclasses = classDatabase.getEntriesByName(ACTIVTY_CLASS_NAME).stream().flatMap(classEntry -> classDatabase.getDescendantClasses(classEntry.getClassId()).stream()).collect(Collectors.toSet());
        Set allFragmentSubclasses = FRAGMENT_CLASS_NAMES.stream().flatMap(className -> classDatabase.getEntriesByName((String)className).stream()).flatMap(classEntry -> classDatabase.getDescendantClasses(classEntry.getClassId()).stream()).collect(Collectors.toSet());
        return instances.stream().filter(instance -> {
            if (allActivitySubclasses.contains(instance.getClassEntry()) && this.isPotentialActivityLeak((InstanceObject)instance)) {
                return true;
            }
            return allFragmentSubclasses.contains(instance.getClassEntry()) && this.isPotentialFragmentLeak((InstanceObject)instance);
        }).collect(Collectors.toSet());
    }

    private boolean isPotentialActivityLeak(@NotNull InstanceObject instance) {
        int depth;
        if (instance == null) {
            ActivityFragmentLeakInstanceFilter.$$$reportNull$$$0(2);
        }
        if ((depth = instance.getDepth()) == 0 || depth == Integer.MAX_VALUE) {
            return false;
        }
        List<FieldObject> fields = instance.getFields();
        for (FieldObject field : fields) {
            String fieldName = field.getFieldName();
            if (!fieldName.equals(FINISHED_FIELD_NAME) && !fieldName.equals(DESTROYED_FIELD_NAME) || !((Boolean)field.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isPotentialFragmentLeak(@NotNull InstanceObject instance) {
        int depth;
        if (instance == null) {
            ActivityFragmentLeakInstanceFilter.$$$reportNull$$$0(3);
        }
        if ((depth = instance.getDepth()) == 0 || depth == Integer.MAX_VALUE) {
            return false;
        }
        List<FieldObject> fields = instance.getFields();
        for (FieldObject field : fields) {
            String fieldName = field.getFieldName();
            if (!fieldName.equals(FRAGFMENT_MANAGER_FIELD_NAME) || field.getValue() != null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instances";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDatabase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/adapters/instancefilters/ActivityFragmentLeakInstanceFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "filter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPotentialActivityLeak";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPotentialFragmentLeak";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

