/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ThreadId;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveAllocationInstanceObject
implements InstanceObject {
    @NotNull
    private final LiveAllocationCaptureObject myCaptureObject;
    @NotNull
    private final ClassDb.ClassEntry myClassEntry;
    @NotNull
    private final ValueObject.ValueType myValueType;
    private long myAllocTime;
    private long myDeallocTime;
    private final long mySize;
    private final int myHeapId;
    @Nullable
    private Memory.AllocationStack myCallstack;
    @Nullable
    private final ThreadId myThreadId;
    @Nullable
    private TLongObjectHashMap<JniReferenceInstanceObject> myJniRefs;

    /*
     * WARNING - void declaration
     */
    public LiveAllocationInstanceObject(@NotNull LiveAllocationCaptureObject captureObject, @NotNull ClassDb.ClassEntry classEntry, @Nullable ThreadId threadId, @Nullable Memory.AllocationStack callstack, long size, int n) {
        void heapId;
        if (captureObject == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(0);
        }
        if (classEntry == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(1);
        }
        this.myAllocTime = Long.MIN_VALUE;
        this.myDeallocTime = Long.MAX_VALUE;
        this.myJniRefs = null;
        this.myCaptureObject = captureObject;
        this.myClassEntry = classEntry;
        this.mySize = size;
        this.myHeapId = heapId;
        this.myThreadId = threadId == null ? ThreadId.INVALID_THREAD_ID : threadId;
        this.myCallstack = callstack;
        this.myValueType = "java.lang.String".equals(classEntry.getClassName()) ? ValueObject.ValueType.STRING : (classEntry.getClassName().endsWith("[]") ? ValueObject.ValueType.ARRAY : ValueObject.ValueType.OBJECT);
    }

    @Override
    public long getAllocTime() {
        return this.myAllocTime;
    }

    public void setDeallocTime(long deallocTime) {
        this.myDeallocTime = deallocTime;
    }

    public void setAllocationTime(long allocTime) {
        this.myAllocTime = allocTime;
    }

    @Override
    public long getDeallocTime() {
        return this.myDeallocTime;
    }

    @Override
    public boolean hasTimeData() {
        return this.hasAllocTime() || this.hasDeallocTime();
    }

    @Override
    public boolean hasAllocTime() {
        return this.myAllocTime != Long.MIN_VALUE;
    }

    @Override
    public boolean hasDeallocTime() {
        return this.myDeallocTime != Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public int getHeapId() {
        return this.myHeapId;
    }

    @Override
    public int getShallowSize() {
        return (int)this.mySize;
    }

    @Override
    @Nullable
    public Memory.AllocationStack getAllocationCallStack() {
        return this.myCallstack;
    }

    @Override
    @NotNull
    public List<CodeLocation> getAllocationCodeLocations() {
        ArrayList<CodeLocation> codeLocations = new ArrayList<CodeLocation>();
        if (this.myCallstack != null && this.myCallstack.getFrameCase() == Memory.AllocationStack.FrameCase.ENCODED_STACK) {
            Memory.AllocationStack.EncodedFrameWrapper encodedFrames = this.myCallstack.getEncodedStack();
            for (Memory.AllocationStack.EncodedFrame frame : encodedFrames.getFramesList()) {
                Memory.AllocationStack.StackFrame resolvedFrame = this.myCaptureObject.getStackFrame(frame.getMethodId());
                CodeLocation.Builder builder = new CodeLocation.Builder(resolvedFrame.getClassName()).setMethodName(resolvedFrame.getMethodName()).setLineNumber(frame.getLineNumber() - 1);
                codeLocations.add(builder.build());
            }
        }
        ArrayList<CodeLocation> arrayList = codeLocations;
        if (arrayList == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        ThreadId threadId = this.myThreadId;
        if (threadId == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(3);
        }
        return threadId;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        ClassDb.ClassEntry classEntry = this.myClassEntry;
        if (classEntry == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(4);
        }
        return classEntry;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        ValueObject.ValueType valueType = this.myValueType;
        if (valueType == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(5);
        }
        return valueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        String string = this.myClassEntry.getSimpleClassName();
        if (string == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public JniReferenceInstanceObject getJniRefByValue(long refValue) {
        if (this.myJniRefs == null) {
            return null;
        }
        return (JniReferenceInstanceObject)this.myJniRefs.get(refValue);
    }

    public void addJniRef(@NotNull JniReferenceInstanceObject ref) {
        if (ref == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(7);
        }
        if (this.myJniRefs == null) {
            this.myJniRefs = new TLongObjectHashMap();
        }
        this.myJniRefs.put(ref.getRefValue(), (Object)ref);
    }

    public void removeJniRef(@NotNull JniReferenceInstanceObject ref) {
        if (ref == null) {
            LiveAllocationInstanceObject.$$$reportNull$$$0(8);
        }
        if (this.myJniRefs == null) {
            return;
        }
        this.myJniRefs.remove(ref.getRefValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classEntry";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/LiveAllocationInstanceObject";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/LiveAllocationInstanceObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationCodeLocations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationThreadId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addJniRef";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeJniRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

