/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveAllocationCaptureObject
implements CaptureObject {
    private static final long QUERY_BUFFER_NS = TimeUnit.SECONDS.toNanos(5L);
    @VisibleForTesting
    static final String SAMPLING_INFO_MESSAGE = "Selected region does not have full tracking. Data may be inaccurate.";
    @Nullable
    private MemoryProfilerStage myStage;
    @VisibleForTesting
    final ExecutorService myExecutorService;
    private final ClassDb myClassDb;
    private final TIntObjectHashMap<LiveAllocationInstanceObject> myInstanceMap;
    private final TIntObjectHashMap<Memory.AllocationStack> myCallstackMap;
    @NotNull
    private final TLongObjectHashMap<Memory.NativeCallStack.NativeFrame> myNativeFrameMap;
    private final TLongObjectHashMap<Memory.AllocationStack.StackFrame> myMethodIdMap;
    private final TIntObjectHashMap<ThreadId> myThreadIdMap;
    private final TreeMap<Long, Memory.MemoryMap.MemoryRegion> myJniMemoryRegionMap;
    private final ProfilerClient myClient;
    private final Common.Session mySession;
    private final long myCaptureStartTime;
    private final List<HeapSet> myHeapSets;
    private final AspectObserver myAspectObserver;
    private final boolean myEnableJniRefsTracking;
    private long myContextEndTimeNs;
    private long myPreviousQueryStartTimeNs;
    private long myPreviousQueryEndTimeNs;
    private long myLastSeenTimestampNs;
    private Range myQueryRange;
    private Future myCurrentTask;
    @Nullable
    private String myInfoMessage;

    private static Logger getLogger() {
        return Logger.getInstance(LiveAllocationCaptureObject.class);
    }

    /*
     * WARNING - void declaration
     */
    public LiveAllocationCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, long captureStartTime, @Nullable ExecutorService loadService, @Nullable MemoryProfilerStage memoryProfilerStage) {
        void stage;
        if (client == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(0);
        }
        if (session == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(1);
        }
        this.myContextEndTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryStartTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryEndTimeNs = Long.MIN_VALUE;
        this.myLastSeenTimestampNs = Long.MIN_VALUE;
        this.myExecutorService = loadService == null ? Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("profiler-live-allocation").build()) : loadService;
        this.myClassDb = new ClassDb();
        this.myInstanceMap = new TIntObjectHashMap();
        this.myCallstackMap = new TIntObjectHashMap();
        this.myNativeFrameMap = new TLongObjectHashMap();
        this.myMethodIdMap = new TLongObjectHashMap();
        this.myThreadIdMap = new TIntObjectHashMap();
        this.myJniMemoryRegionMap = new TreeMap();
        this.myClient = client;
        this.mySession = session;
        this.myCaptureStartTime = captureStartTime;
        this.myAspectObserver = new AspectObserver();
        this.myStage = stage;
        this.myHeapSets = new ArrayList<HeapSet>(Arrays.asList(new HeapSet(this, "default", 0), new HeapSet(this, "image", 1), new HeapSet(this, "zygote", 2), new HeapSet(this, "app", 3)));
        this.myEnableJniRefsTracking = stage.getStudioProfilers().getIdeServices().getFeatureConfig().isJniReferenceTrackingEnabled();
        if (this.myEnableJniRefsTracking) {
            this.myHeapSets.add(new HeapSet(this, "JNI", 4));
        }
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySession;
        if (session == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(2);
        }
        return session;
    }

    @Override
    @NotNull
    public MemoryServiceGrpc.MemoryServiceBlockingStub getClient() {
        MemoryServiceGrpc.MemoryServiceBlockingStub memoryServiceBlockingStub = this.myClient.getMemoryClient();
        if (memoryServiceBlockingStub == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(3);
        }
        return memoryServiceBlockingStub;
    }

    @Override
    @NotNull
    public String getName() {
        return "Live Allocation";
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return null;
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
            ImmutableList immutableList = ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.TOTAL_COUNT), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
            if (immutableList == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(5);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
        if (immutableList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        ImmutableList immutableList = ImmutableList.of((Object)((Object)CaptureObject.InstanceAttribute.LABEL), (Object)((Object)CaptureObject.InstanceAttribute.ALLOCATION_TIME), (Object)((Object)CaptureObject.InstanceAttribute.DEALLOCATION_TIME));
        if (immutableList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public String getInfoMessage() {
        return this.myInfoMessage;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        if (this.myHeapSets.get(0).getInstancesCount() > 0) {
            List<HeapSet> list = this.myHeapSets;
            if (list == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<HeapSet> list = this.myHeapSets.subList(1, this.myHeapSets.size());
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.get(heapId);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        Stream<InstanceObject> stream = this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
        if (stream == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myCaptureStartTime;
    }

    @Override
    public long getEndTimeNs() {
        return Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        ClassDb classDb = this.myClassDb;
        if (classDb == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(11);
        }
        return classDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        assert (queryRange != null);
        assert (queryJoiner != null);
        this.myQueryRange = queryRange;
        this.myQueryRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> this.loadTimeRange(this.myQueryRange, queryJoiner));
        this.loadTimeRange(this.myQueryRange, queryJoiner);
        return true;
    }

    @Override
    @Nullable
    public Memory.AllocationStack.StackFrame getStackFrame(long methodId) {
        return (Memory.AllocationStack.StackFrame)this.myMethodIdMap.get(methodId);
    }

    @Override
    public boolean isDoneLoading() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public void unload() {
        this.myQueryRange.removeDependencies(this.myAspectObserver);
        this.myExecutorService.shutdownNow();
    }

    private void updateAllocationContexts(long endTimeNs) {
        if (this.myContextEndTimeNs >= endTimeNs) {
            return;
        }
        List<Memory.BatchAllocationContexts> contextsList = this.getAllocationContexts(this.myContextEndTimeNs, endTimeNs);
        for (Memory.BatchAllocationContexts contexts : contextsList) {
            for (Memory.AllocatedClass klass : contexts.getClassesList()) {
                this.myClassDb.registerClass(klass.getClassId(), klass.getClassName());
            }
            contexts.getMethodsList().forEach(method -> {
                if (!this.myMethodIdMap.containsKey(method.getMethodId())) {
                    this.myMethodIdMap.put(method.getMethodId(), method);
                }
            });
            contexts.getEncodedStacksList().forEach(callStack -> {
                if (!this.myCallstackMap.contains(callStack.getStackId())) {
                    this.myCallstackMap.put(callStack.getStackId(), callStack);
                }
            });
            contexts.getThreadInfosList().forEach(thread2 -> {
                if (!this.myThreadIdMap.contains(thread2.getThreadId())) {
                    this.myThreadIdMap.put(thread2.getThreadId(), (Object)new ThreadId(thread2.getThreadName()));
                }
            });
            contexts.getMemoryMap().getRegionsList().forEach(region -> this.myJniMemoryRegionMap.put(region.getStartAddress(), (Memory.MemoryMap.MemoryRegion)region));
            this.myContextEndTimeNs = Math.max(this.myContextEndTimeNs, contexts.getTimestamp());
        }
    }

    private void loadTimeRange(@NotNull Range queryRange, @NotNull Executor joiner) {
        if (queryRange == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(12);
        }
        if (joiner == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(13);
        }
        try {
            if (queryRange.isEmpty()) {
                return;
            }
            if (this.myCurrentTask != null) {
                this.myCurrentTask.cancel(false);
            }
            this.myCurrentTask = this.myExecutorService.submit(() -> {
                boolean clear;
                long newStartTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMin());
                long newEndTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMax());
                if (newStartTimeNs == this.myPreviousQueryStartTimeNs && newEndTimeNs == this.myPreviousQueryEndTimeNs) {
                    return null;
                }
                boolean hasNonFullTrackingRegion = !MemoryProfiler.hasOnlyFullAllocationTrackingWithinRegion(this.myStage.getStudioProfilers(), this.mySession, TimeUnit.NANOSECONDS.toMicros(newStartTimeNs), TimeUnit.NANOSECONDS.toMicros(newEndTimeNs));
                joiner.execute(() -> this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATING));
                this.updateAllocationContexts(newEndTimeNs);
                ArrayList<InstanceObject> snapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetSnapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaFreeList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaFreeList = new ArrayList<InstanceObject>();
                boolean bl = clear = this.myPreviousQueryEndTimeNs <= newStartTimeNs || newEndTimeNs <= this.myPreviousQueryStartTimeNs;
                if (clear) {
                    this.myInstanceMap.clear();
                    this.queryJavaInstanceSnapshot(newStartTimeNs, snapshotList);
                    this.queryJniReferencesSnapshot(newStartTimeNs, snapshotList);
                    this.queryJavaInstanceDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                    this.queryJniReferencesDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                } else {
                    ArrayList<InstanceObject> leftAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> leftDeallocations = new ArrayList<InstanceObject>();
                    if (newStartTimeNs < this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        this.queryJniReferencesDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        deltaAllocationList.addAll(leftAllocations);
                        deltaFreeList.addAll(leftDeallocations);
                        resetSnapshotList.addAll(leftAllocations);
                        snapshotList.addAll(leftDeallocations);
                    } else if (newStartTimeNs > this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        this.queryJniReferencesDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        resetDeltaAllocationList.addAll(leftAllocations);
                        resetDeltaFreeList.addAll(leftDeallocations);
                        snapshotList.addAll(leftAllocations);
                        resetSnapshotList.addAll(leftDeallocations);
                    }
                    ArrayList<InstanceObject> rightAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> rightDeallocations = new ArrayList<InstanceObject>();
                    if (newEndTimeNs < this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        this.queryJniReferencesDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        resetDeltaAllocationList.addAll(rightAllocations);
                        resetDeltaFreeList.addAll(rightDeallocations);
                    } else if (newEndTimeNs > this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        this.queryJniReferencesDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        deltaAllocationList.addAll(rightAllocations);
                        deltaFreeList.addAll(rightDeallocations);
                    }
                }
                this.myPreviousQueryStartTimeNs = newStartTimeNs;
                this.myPreviousQueryEndTimeNs = Math.min(newEndTimeNs, this.myLastSeenTimestampNs);
                joiner.execute(() -> {
                    this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATED);
                    if (clear || deltaAllocationList.size() + deltaFreeList.size() + resetDeltaAllocationList.size() + resetDeltaFreeList.size() > 0) {
                        if (clear) {
                            this.myHeapSets.forEach(heap -> heap.clearClassifierSets());
                            if (this.myStage.getSelectedClassSet() != null) {
                                this.myStage.selectClassSet(ClassSet.EMPTY_SET);
                            }
                        }
                        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
                            snapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addSnapshotInstanceObject((InstanceObject)instance));
                            resetSnapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeSnapshotInstanceObject((InstanceObject)instance));
                        }
                        deltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addDeltaInstanceObject((InstanceObject)instance));
                        deltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).freeDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeAddedDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeFreedDeltaInstanceObject((InstanceObject)instance));
                        this.myInfoMessage = hasNonFullTrackingRegion ? SAMPLING_INFO_MESSAGE : null;
                        this.myStage.refreshSelectedHeap();
                    }
                });
                return null;
            });
        }
        catch (RejectedExecutionException e) {
            LiveAllocationCaptureObject.getLogger().debug((Throwable)e);
        }
    }

    @NotNull
    private LiveAllocationInstanceObject getOrCreateInstanceObject(int tag, int classTag, int stackId, int threadId, long size, int heapId) {
        LiveAllocationInstanceObject instance = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (instance == null) {
            ClassDb.ClassEntry entry = this.myClassDb.getEntry(classTag);
            Memory.AllocationStack callstack = null;
            if (stackId != 0) {
                assert (this.myCallstackMap.containsKey(stackId));
                callstack = (Memory.AllocationStack)this.myCallstackMap.get(stackId);
            }
            ThreadId thread2 = null;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            instance = new LiveAllocationInstanceObject(this, entry, thread2, callstack, size, heapId);
            this.myInstanceMap.put(tag, (Object)instance);
        }
        LiveAllocationInstanceObject liveAllocationInstanceObject = instance;
        if (liveAllocationInstanceObject == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(14);
        }
        return liveAllocationInstanceObject;
    }

    @Nullable
    private JniReferenceInstanceObject getOrCreateJniRefObject(int tag, long refValue) {
        LiveAllocationInstanceObject referencedObject = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (referencedObject == null) {
            return null;
        }
        JniReferenceInstanceObject result = referencedObject.getJniRefByValue(refValue);
        if (result == null) {
            result = new JniReferenceInstanceObject(this, referencedObject, tag, refValue);
            referencedObject.addJniRef(result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void queryJavaInstanceSnapshot(long snapshotTimeNs, @NotNull List<InstanceObject> list) {
        void snapshotList;
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(15);
        }
        long sessionStartNs = this.mySession.getStartTimestamp();
        List<Memory.BatchAllocationEvents> eventsList = this.getAllocationEvents(sessionStartNs, snapshotTimeNs);
        LinkedHashMap<Integer, LiveAllocationInstanceObject> liveInstanceMap = new LinkedHashMap<Integer, LiveAllocationInstanceObject>();
        for (Memory.BatchAllocationEvents events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() < snapshotTimeNs).sorted(Comparator.comparingLong(Memory.AllocationEvent::getTimestamp)).iterator();
            while (itr.hasNext()) {
                Memory.AllocationEvent event = (Memory.AllocationEvent)itr.next();
                switch (event.getEventCase()) {
                    case ALLOC_DATA: {
                        Memory.AllocationEvent.Allocation allocation = event.getAllocData();
                        LiveAllocationInstanceObject instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                        instance.setAllocationTime(event.getTimestamp());
                        liveInstanceMap.put(allocation.getTag(), instance);
                        break;
                    }
                    case FREE_DATA: {
                        Memory.AllocationEvent.Deallocation deallocation = event.getFreeData();
                        liveInstanceMap.remove(deallocation.getTag());
                        this.myInstanceMap.remove(deallocation.getTag());
                        break;
                    }
                }
            }
        }
        snapshotList.addAll(liveInstanceMap.values());
    }

    /*
     * WARNING - void declaration
     */
    private void queryJniReferencesSnapshot(long snapshotTimeNs, @NotNull List<InstanceObject> list) {
        void snapshotList;
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(16);
        }
        if (!this.myEnableJniRefsTracking) {
            return;
        }
        long sessionStartNs = this.mySession.getStartTimestamp();
        List<Memory.BatchJNIGlobalRefEvent> eventsList = this.getJniRefEvents(sessionStartNs, snapshotTimeNs);
        LinkedHashMap<Long, JniReferenceInstanceObject> instanceMap = new LinkedHashMap<Long, JniReferenceInstanceObject>();
        for (Memory.BatchJNIGlobalRefEvent events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() < snapshotTimeNs).sorted(Comparator.comparingLong(Memory.JNIGlobalReferenceEvent::getTimestamp)).iterator();
            while (itr.hasNext()) {
                Memory.JNIGlobalReferenceEvent event = (Memory.JNIGlobalReferenceEvent)itr.next();
                switch (event.getEventType()) {
                    case CREATE_GLOBAL_REF: {
                        JniReferenceInstanceObject refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue());
                        if (refObject == null) break;
                        if (event.hasBacktrace()) {
                            refObject.setAllocationBacktrace(event.getBacktrace());
                        }
                        int threadId = event.getThreadId();
                        ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
                        if (threadId != 0) {
                            assert (this.myThreadIdMap.containsKey(threadId));
                            thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
                        }
                        refObject.setAllocThreadId(thread2);
                        refObject.setAllocationTime(event.getTimestamp());
                        instanceMap.put(refObject.getRefValue(), refObject);
                        break;
                    }
                    case DELETE_GLOBAL_REF: {
                        JniReferenceInstanceObject refObject = (JniReferenceInstanceObject)instanceMap.remove(event.getRefValue());
                        if (refObject == null || !this.myInstanceMap.containsKey(event.getObjectTag())) break;
                        ((LiveAllocationInstanceObject)this.myInstanceMap.get(event.getObjectTag())).removeJniRef(refObject);
                    }
                }
            }
        }
        snapshotList.addAll(instanceMap.values());
    }

    /*
     * WARNING - void declaration
     */
    private void queryJavaInstanceDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> list, boolean bl) {
        if (allocationList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(17);
        }
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(18);
        }
        if (startTimeNs == endTimeNs) {
            return;
        }
        List<Memory.BatchAllocationEvents> eventsList = this.getAllocationEvents(startTimeNs, endTimeNs);
        for (Memory.BatchAllocationEvents events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() >= startTimeNs && evt.getTimestamp() < endTimeNs).sorted(Comparator.comparingLong(Memory.AllocationEvent::getTimestamp)).iterator();
            while (itr.hasNext()) {
                Memory.AllocationEvent event = (Memory.AllocationEvent)itr.next();
                switch (event.getEventCase()) {
                    case ALLOC_DATA: {
                        void resetInstance;
                        Memory.AllocationEvent.Allocation allocation = event.getAllocData();
                        LiveAllocationInstanceObject instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                        instance.setAllocationTime(resetInstance != false ? Long.MIN_VALUE : event.getTimestamp());
                        allocationList.add(instance);
                        break;
                    }
                    case FREE_DATA: {
                        void deallocationList;
                        void resetInstance;
                        Memory.AllocationEvent.Deallocation deallocation = event.getFreeData();
                        assert (this.myInstanceMap.containsKey(deallocation.getTag()));
                        LiveAllocationInstanceObject instance = (LiveAllocationInstanceObject)this.myInstanceMap.get(deallocation.getTag());
                        instance.setDeallocTime(resetInstance != false ? Long.MAX_VALUE : event.getTimestamp());
                        deallocationList.add(instance);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void queryJniReferencesDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> list, boolean bl) {
        if (allocationList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(19);
        }
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(20);
        }
        if (!this.myEnableJniRefsTracking || startTimeNs == endTimeNs) {
            return;
        }
        List<Memory.BatchJNIGlobalRefEvent> eventsList = this.getJniRefEvents(startTimeNs, endTimeNs);
        for (Memory.BatchJNIGlobalRefEvent events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() >= startTimeNs && evt.getTimestamp() < endTimeNs).sorted(Comparator.comparingLong(Memory.JNIGlobalReferenceEvent::getTimestamp)).iterator();
            block5: while (itr.hasNext()) {
                Memory.JNIGlobalReferenceEvent event = (Memory.JNIGlobalReferenceEvent)itr.next();
                JniReferenceInstanceObject refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue());
                if (refObject == null) continue;
                int threadId = event.getThreadId();
                ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
                if (threadId != 0) {
                    assert (this.myThreadIdMap.containsKey(threadId));
                    thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
                }
                switch (event.getEventType()) {
                    case CREATE_GLOBAL_REF: {
                        void resetInstance;
                        if (resetInstance != false) {
                            refObject.setAllocationTime(Long.MIN_VALUE);
                        } else {
                            refObject.setAllocationTime(event.getTimestamp());
                            if (event.hasBacktrace()) {
                                refObject.setAllocationBacktrace(event.getBacktrace());
                            }
                            refObject.setAllocThreadId(thread2);
                        }
                        allocationList.add(refObject);
                        continue block5;
                    }
                    case DELETE_GLOBAL_REF: {
                        void deallocatoinList;
                        void resetInstance;
                        if (resetInstance != false) {
                            refObject.setAllocationTime(Long.MAX_VALUE);
                        } else {
                            refObject.setDeallocTime(event.getTimestamp());
                            if (event.hasBacktrace()) {
                                refObject.setDeallocationBacktrace(event.getBacktrace());
                            }
                            refObject.setDeallocThreadId(thread2);
                        }
                        deallocatoinList.add(refObject);
                        continue block5;
                    }
                }
                assert (false);
            }
        }
    }

    @NotNull
    Memory.NativeCallStack resolveNativeBacktrace(@Nullable Memory.NativeBacktrace backtrace) {
        if (backtrace == null || backtrace.getAddressesCount() == 0) {
            Memory.NativeCallStack nativeCallStack = Memory.NativeCallStack.getDefaultInstance();
            if (nativeCallStack == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(21);
            }
            return nativeCallStack;
        }
        Memory.NativeCallStack.Builder builder = Memory.NativeCallStack.newBuilder();
        Iterator iterator = backtrace.getAddressesList().iterator();
        while (iterator.hasNext()) {
            long address = (Long)iterator.next();
            if (!this.myNativeFrameMap.containsKey(address)) {
                String module = "";
                long offset = 0L;
                Memory.MemoryMap.MemoryRegion region = this.getRegionByAddress(address);
                if (region != null) {
                    module = region.getName();
                    offset = region.getFileOffset() + (address - region.getStartAddress());
                }
                Memory.NativeCallStack.NativeFrame unsymbolizedFrame = Memory.NativeCallStack.NativeFrame.newBuilder().setAddress(address).setModuleName(module).setModuleOffset(offset).build();
                Memory.NativeCallStack.NativeFrame symbolizedFrame = this.myStage.getStudioProfilers().getIdeServices().getNativeFrameSymbolizer().symbolize(this.myStage.getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi(), unsymbolizedFrame);
                this.myNativeFrameMap.put(address, (Object)symbolizedFrame);
            }
            builder.addFrames((Memory.NativeCallStack.NativeFrame)this.myNativeFrameMap.get(address));
        }
        Memory.NativeCallStack nativeCallStack = builder.build();
        if (nativeCallStack == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(22);
        }
        return nativeCallStack;
    }

    @Nullable
    private Memory.MemoryMap.MemoryRegion getRegionByAddress(long address) {
        Map.Entry<Long, Memory.MemoryMap.MemoryRegion> entry = this.myJniMemoryRegionMap.floorEntry(address);
        if (entry == null) {
            return null;
        }
        Memory.MemoryMap.MemoryRegion region = entry.getValue();
        if (address >= region.getStartAddress() && address < region.getEndAddress()) {
            return region;
        }
        return null;
    }

    @NotNull
    private List<Memory.BatchAllocationContexts> getAllocationContexts(long startTimeNs, long endTimeNs) {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(this.buildEventGroupRequest(Common.Event.Kind.MEMORY_ALLOC_CONTEXTS, startTimeNs, endTimeNs + QUERY_BUFFER_NS));
            assert (response.getGroupsCount() <= 1);
            List<Object> list = response.getGroupsCount() == 1 ? response.getGroups(0).getEventsList().stream().map(event -> event.getMemoryAllocContexts().getContexts()).collect(Collectors.toList()) : Collections.emptyList();
            if (list == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(23);
            }
            return list;
        }
        MemoryProfiler.AllocationContextsResponse response = this.getClient().getAllocationContexts(MemoryProfiler.AllocationContextsRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs).setEndTime(endTimeNs + QUERY_BUFFER_NS).build());
        List list = response.getContextsList();
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private List<Memory.BatchAllocationEvents> getAllocationEvents(long startTimeNs, long endTimeNs) {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(this.buildEventGroupRequest(Common.Event.Kind.MEMORY_ALLOC_EVENTS, startTimeNs - QUERY_BUFFER_NS, endTimeNs + QUERY_BUFFER_NS));
            assert (response.getGroupsCount() <= 1);
            List<Memory.BatchAllocationEvents> list = response.getGroupsCount() == 1 ? this.getEventsAndUpdateSeenTimestamp(response.getGroups(0).getEventsList().stream().map(event -> event.getMemoryAllocEvents().getEvents()).collect(Collectors.toList()), Memory.BatchAllocationEvents::getTimestamp) : Collections.emptyList();
            if (list == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(25);
            }
            return list;
        }
        MemoryProfiler.AllocationEventsResponse response = this.getClient().getAllocationEvents(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs - QUERY_BUFFER_NS).setEndTime(endTimeNs + QUERY_BUFFER_NS).build());
        List eventsList = response.getEventsList();
        List<Memory.BatchAllocationEvents> list = this.getEventsAndUpdateSeenTimestamp(eventsList, Memory.BatchAllocationEvents::getTimestamp);
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private List<Memory.BatchJNIGlobalRefEvent> getJniRefEvents(long startTimeNs, long endTimeNs) {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(this.buildEventGroupRequest(Common.Event.Kind.MEMORY_JNI_REF_EVENTS, startTimeNs - QUERY_BUFFER_NS, endTimeNs + QUERY_BUFFER_NS));
            assert (response.getGroupsCount() <= 1);
            List<Memory.BatchJNIGlobalRefEvent> list = response.getGroupsCount() == 1 ? this.getEventsAndUpdateSeenTimestamp(response.getGroups(0).getEventsList().stream().map(event -> event.getMemoryJniRefEvents().getEvents()).collect(Collectors.toList()), Memory.BatchJNIGlobalRefEvent::getTimestamp) : Collections.emptyList();
            if (list == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(27);
            }
            return list;
        }
        MemoryProfiler.JNIGlobalRefsEventsRequest request = MemoryProfiler.JNIGlobalRefsEventsRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs - QUERY_BUFFER_NS).setEndTime(endTimeNs + QUERY_BUFFER_NS).build();
        List eventsList = this.getClient().getJNIGlobalRefsEvents(request).getEventsList();
        List<Memory.BatchJNIGlobalRefEvent> list = this.getEventsAndUpdateSeenTimestamp(eventsList, Memory.BatchJNIGlobalRefEvent::getTimestamp);
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private Transport.GetEventGroupsRequest buildEventGroupRequest(Common.Event.Kind kind, long startTimeNs, long endTimeNs) {
        Transport.GetEventGroupsRequest getEventGroupsRequest = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(kind).setFromTimestamp(startTimeNs).setToTimestamp(endTimeNs).build();
        if (getEventGroupsRequest == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(29);
        }
        return getEventGroupsRequest;
    }

    private <T> List<T> getEventsAndUpdateSeenTimestamp(List<T> eventList, Function<T, Long> timestampFunc) {
        for (T event : eventList) {
            this.myLastSeenTimestampNs = Math.max(timestampFunc.apply(event), this.myLastSeenTimestampNs);
        }
        return eventList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryRange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joiner";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotList";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationList";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deallocationList";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deallocatoinList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDatabase";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstanceObject";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNativeBacktrace";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationContexts";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationEvents";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getJniRefEvents";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEventGroupRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadTimeRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "queryJavaInstanceSnapshot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "queryJniReferencesSnapshot";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "queryJavaInstanceDelta";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "queryJniReferencesDelta";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

