/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.LegacyAllocationConverter;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationsInstanceObject;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LegacyAllocationCaptureObject
implements CaptureObject {
    static final int DEFAULT_HEAP_ID = 0;
    static final String DEFAULT_HEAP_NAME = "default";
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final ClassDb myClassDb;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Memory.AllocationsInfo myInfo;
    @NotNull
    private final LegacyAllocationConverter myAllocationConverter;
    private long myStartTimeNs;
    private long myEndTimeNs;
    private final FeatureTracker myFeatureTracker;
    private volatile boolean myIsDoneLoading;
    private volatile boolean myIsLoadingError;
    private final HeapSet myFakeHeapSet;

    public LegacyAllocationCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull FeatureTracker featureTracker) {
        if (client == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(0);
        }
        if (session == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(1);
        }
        if (info == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(2);
        }
        if (featureTracker == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(3);
        }
        this.myIsDoneLoading = false;
        this.myIsLoadingError = false;
        this.myClient = client;
        this.myClassDb = new ClassDb();
        this.mySession = session;
        this.myInfo = info;
        this.myAllocationConverter = new LegacyAllocationConverter();
        this.myStartTimeNs = info.getStartTime();
        this.myEndTimeNs = info.getEndTime();
        this.myFakeHeapSet = new HeapSet(this, DEFAULT_HEAP_NAME, 0);
        this.myFeatureTracker = featureTracker;
    }

    @Override
    @NotNull
    public String getName() {
        return "Recorded Allocations";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "alloc";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(4);
        }
        MemoryProfiler.saveLegacyAllocationToFile(this.myClient, this.mySession, this.myInfo, outputStream, this.myFeatureTracker);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        assert (this.isDoneLoading() && !this.isError());
        Stream<InstanceObject> stream = this.myFakeHeapSet.getInstancesStream();
        if (stream == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myStartTimeNs;
    }

    @Override
    public long getEndTimeNs() {
        return this.myEndTimeNs;
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        ClassDb classDb = this.myClassDb;
        if (classDb == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(6);
        }
        return classDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        Transport.BytesResponse response;
        if (!this.myInfo.getSuccess()) {
            this.myIsLoadingError = true;
            return false;
        }
        while ((response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myInfo.getStartTime())).build())).getContents().isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.myIsLoadingError = true;
                return false;
            }
        }
        HashMap classEntryMap = new HashMap();
        HashMap callStacks = new HashMap();
        this.myAllocationConverter.parseDump(response.getContents().toByteArray());
        this.myAllocationConverter.getAllocationStacks().forEach(stack -> callStacks.putIfAbsent(stack.getStackId(), stack));
        this.myAllocationConverter.getClassNames().forEach(klass -> classEntryMap.put(klass.getClassId(), this.myClassDb.registerClass(klass.getClassId(), klass.getClassName())));
        for (Memory.AllocationEvent.Allocation event : this.myAllocationConverter.getAllocationEvents()) {
            assert (classEntryMap.containsKey(event.getClassTag()));
            assert (callStacks.containsKey(event.getStackId()));
            this.myFakeHeapSet.addDeltaInstanceObject(new LegacyAllocationsInstanceObject(event, (ClassDb.ClassEntry)classEntryMap.get(event.getClassTag()), (Memory.AllocationStack)callStacks.get(event.getStackId())));
        }
        this.myIsDoneLoading = true;
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.myIsDoneLoading || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        List<CaptureObject.ClassifierAttribute> list = Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE);
        if (list == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        List<CaptureObject.InstanceAttribute> list = Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.SHALLOW_SIZE);
        if (list == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        List<HeapSet> list = Collections.singletonList(this.myFakeHeapSet);
        if (list == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        assert (heapId == 0);
        return this.myFakeHeapSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/LegacyAllocationCaptureObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/LegacyAllocationCaptureObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDatabase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

