/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.simpleperf.NodeNameParser;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniReferenceInstanceObject
implements InstanceObject {
    @NotNull
    private final LiveAllocationCaptureObject myCaptureObject;
    @NotNull
    private final LiveAllocationInstanceObject myReferencedObject;
    private long myAllocTime;
    private long myDeallocTime;
    private final long myRefValue;
    private final long myObjectTag;
    @NotNull
    private ThreadId myAllocThreadId;
    @NotNull
    private ThreadId myDeallocThreadId;
    @Nullable
    private Memory.NativeBacktrace myAllocationBacktrace;
    @Nullable
    private Memory.NativeBacktrace myDeallocationBacktrace;
    @Nullable
    private List<CodeLocation> myAllocationLocations;
    @Nullable
    private List<CodeLocation> myDeallocationLocations;
    @Nullable
    private List<FieldObject> myFields;
    private static final String REF_NAME_FORMATTER = "JNI Global Reference (0x%x)";
    private static final String OBJECT_NAME_FORMATTER = "%s@%d";
    private static final String APP_DIR_PATH_PREFIX = "/data/app/";

    /*
     * WARNING - void declaration
     */
    public JniReferenceInstanceObject(@NotNull LiveAllocationCaptureObject captureObject, @NotNull LiveAllocationInstanceObject referencedObject, long objectTag, long l) {
        void refValue;
        if (captureObject == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(0);
        }
        if (referencedObject == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(1);
        }
        this.myAllocTime = Long.MIN_VALUE;
        this.myDeallocTime = Long.MAX_VALUE;
        this.myAllocThreadId = ThreadId.INVALID_THREAD_ID;
        this.myDeallocThreadId = ThreadId.INVALID_THREAD_ID;
        this.myCaptureObject = captureObject;
        this.myReferencedObject = referencedObject;
        this.myRefValue = refValue;
        this.myObjectTag = objectTag;
    }

    public void setAllocationTime(long allocTime) {
        this.myAllocTime = allocTime;
    }

    @Override
    public long getAllocTime() {
        return this.myAllocTime;
    }

    public void setDeallocTime(long deallocTime) {
        this.myDeallocTime = deallocTime;
    }

    @Override
    public long getDeallocTime() {
        return this.myDeallocTime;
    }

    @Override
    public int getCallStackDepth() {
        if (this.myAllocationBacktrace == null) {
            return 0;
        }
        return this.getAllocationCodeLocations().size();
    }

    @Override
    @NotNull
    public List<CodeLocation> getAllocationCodeLocations() {
        if (this.myAllocationLocations != null) {
            List<CodeLocation> list = this.myAllocationLocations;
            if (list == null) {
                JniReferenceInstanceObject.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<CodeLocation> list = this.myAllocationLocations = this.resolveBacktrace(this.myAllocationBacktrace);
        if (list == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CodeLocation> getDeallocationCodeLocations() {
        if (this.myDeallocationLocations != null) {
            List<CodeLocation> list = this.myDeallocationLocations;
            if (list == null) {
                JniReferenceInstanceObject.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<CodeLocation> list = this.myDeallocationLocations = this.resolveBacktrace(this.myDeallocationBacktrace);
        if (list == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private List<CodeLocation> resolveBacktrace(@Nullable Memory.NativeBacktrace backtrace) {
        if (backtrace == null || backtrace.getAddressesCount() == 0) {
            List<CodeLocation> list = Collections.emptyList();
            if (list == null) {
                JniReferenceInstanceObject.$$$reportNull$$$0(6);
            }
            return list;
        }
        Memory.NativeCallStack resolvedStack = this.myCaptureObject.resolveNativeBacktrace(backtrace);
        ArrayList<CodeLocation> codeLocations = new ArrayList<CodeLocation>(resolvedStack.getFramesCount());
        for (Memory.NativeCallStack.NativeFrame frame : resolvedStack.getFramesList()) {
            if (JniReferenceInstanceObject.isHiddenFrame(frame)) continue;
            String functionName = frame.getSymbolName();
            String classOrNamespace = "";
            List<String> parameters = Collections.emptyList();
            try {
                CppFunctionModel nativeFunction = NodeNameParser.createCppFunctionModel(frame.getSymbolName(), false);
                functionName = nativeFunction.getName();
                parameters = nativeFunction.getParameters();
                classOrNamespace = nativeFunction.getClassOrNamespace();
            }
            catch (IllegalStateException | IndexOutOfBoundsException nativeFunction) {
                // empty catch block
            }
            int lineNumber = frame.getLineNumber() == 0 ? -1 : frame.getLineNumber() - 1;
            CodeLocation codeLocation = new CodeLocation.Builder(classOrNamespace).setMethodName(functionName).setMethodParameters(parameters).setNativeCode(true).setNativeModuleName(frame.getModuleName()).setLineNumber(lineNumber).setFileName(frame.getFileName()).build();
            codeLocations.add(codeLocation);
        }
        ArrayList<CodeLocation> arrayList = codeLocations;
        if (arrayList == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean isHiddenFrame(@NotNull Memory.NativeCallStack.NativeFrame frame) {
        String module;
        if (frame == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(8);
        }
        return (module = frame.getModuleName()) == null || !module.startsWith(APP_DIR_PATH_PREFIX);
    }

    public void setAllocThreadId(@NotNull ThreadId allocThreadId) {
        if (allocThreadId == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(9);
        }
        this.myAllocThreadId = allocThreadId;
    }

    public void setDeallocThreadId(@NotNull ThreadId deallocThreadId) {
        if (deallocThreadId == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(10);
        }
        this.myDeallocThreadId = deallocThreadId;
    }

    public void setAllocationBacktrace(@NotNull Memory.NativeBacktrace backtrace) {
        if (backtrace == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(11);
        }
        this.myAllocationLocations = null;
        this.myAllocationBacktrace = backtrace;
    }

    public void setDeallocationBacktrace(@NotNull Memory.NativeBacktrace backtrace) {
        if (backtrace == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(12);
        }
        this.myDeallocationLocations = null;
        this.myDeallocationBacktrace = backtrace;
    }

    @Override
    public boolean hasTimeData() {
        return this.hasAllocTime() || this.hasDeallocTime();
    }

    @Override
    public boolean hasAllocTime() {
        return this.myAllocTime != Long.MIN_VALUE;
    }

    @Override
    public boolean hasDeallocTime() {
        return this.myDeallocTime != Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public int getHeapId() {
        return 4;
    }

    @Override
    public int getShallowSize() {
        return this.myReferencedObject.getShallowSize();
    }

    @Override
    public boolean getIsRoot() {
        return true;
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    @NotNull
    public List<FieldObject> getFields() {
        if (this.myFields == null) {
            this.myFields = Collections.singletonList(new JniRefField());
        }
        List<FieldObject> list = this.myFields;
        if (list == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        ThreadId threadId = this.myAllocThreadId;
        if (threadId == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(14);
        }
        return threadId;
    }

    @Override
    @NotNull
    public ThreadId getDeallocationThreadId() {
        ThreadId threadId = this.myDeallocThreadId;
        if (threadId == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(15);
        }
        return threadId;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        ClassDb.ClassEntry classEntry = this.myReferencedObject.getClassEntry();
        if (classEntry == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(16);
        }
        return classEntry;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        ValueObject.ValueType valueType = this.myReferencedObject.getValueType();
        if (valueType == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(17);
        }
        return valueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        String string = String.format(REF_NAME_FORMATTER, this.myRefValue);
        if (string == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(18);
        }
        return string;
    }

    public long getRefValue() {
        return this.myRefValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedObject";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/JniReferenceInstanceObject";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocThreadId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deallocThreadId";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backtrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/JniReferenceInstanceObject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationCodeLocations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeallocationCodeLocations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBacktrace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationThreadId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeallocationThreadId";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassEntry";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isHiddenFrame";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setAllocThreadId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDeallocThreadId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setAllocationBacktrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDeallocationBacktrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JniRefField
    implements FieldObject {
        private JniRefField() {
        }

        @Override
        @NotNull
        public String getFieldName() {
            return "";
        }

        @Override
        @Nullable
        public InstanceObject getAsInstance() {
            return JniReferenceInstanceObject.this.myReferencedObject;
        }

        @Override
        @Nullable
        public Object getValue() {
            return "";
        }

        @Override
        @NotNull
        public ValueObject.ValueType getValueType() {
            ValueObject.ValueType valueType = ValueObject.ValueType.OBJECT;
            if (valueType == null) {
                JniRefField.$$$reportNull$$$0(0);
            }
            return valueType;
        }

        @Override
        @NotNull
        public String getValueText() {
            String string = String.format(JniReferenceInstanceObject.OBJECT_NAME_FORMATTER, JniReferenceInstanceObject.this.myReferencedObject.getValueText(), JniReferenceInstanceObject.this.myObjectTag);
            if (string == null) {
                JniRefField.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/memory/adapters/JniReferenceInstanceObject$JniRefField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

