/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassifierSet
implements MemoryObject {
    @Nullable
    private String myName;
    @Nullable
    private Supplier<String> myNameSupplier;
    @NotNull
    protected final Set<InstanceObject> mySnapshotInstances;
    @NotNull
    protected final Set<InstanceObject> myDeltaInstances;
    @Nullable
    protected Classifier myClassifier;
    private int myObjectSetCount;
    private int myFilteredObjectSetCount;
    private int mySnapshotObjectCount;
    private int myDeltaAllocations;
    private int myDeltaDeallocations;
    private long myTotalNativeSize;
    private long myTotalShallowSize;
    private long myTotalRetainedSize;
    private int myInstancesWithStackInfoCount;
    protected int myFilterMatchCount;
    protected boolean myIsFiltered;
    protected boolean myIsMatched;
    protected boolean myNeedsRefiltering;

    public ClassifierSet(@NotNull String name) {
        if (name == null) {
            ClassifierSet.$$$reportNull$$$0(0);
        }
        this.myNameSupplier = null;
        this.mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
        this.myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myFilterMatchCount = 0;
        this.myName = name;
    }

    public ClassifierSet(@NotNull Supplier<String> nameSupplier) {
        if (nameSupplier == null) {
            ClassifierSet.$$$reportNull$$$0(1);
        }
        this.myNameSupplier = null;
        this.mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
        this.myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myFilterMatchCount = 0;
        this.myNameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            assert (this.myNameSupplier != null);
            this.myName = this.myNameSupplier.get();
        }
        String string = this.myName;
        if (string == null) {
            ClassifierSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEmpty() {
        return this.mySnapshotObjectCount == 0 && this.myDeltaAllocations == 0 && this.myDeltaDeallocations == 0;
    }

    public int getTotalObjectCount() {
        return this.mySnapshotObjectCount + this.myDeltaAllocations - this.myDeltaDeallocations;
    }

    public int getTotalObjectSetCount() {
        return this.myObjectSetCount;
    }

    public int getFilteredObjectSetCount() {
        return this.myFilteredObjectSetCount;
    }

    public int getDeltaAllocationCount() {
        return this.myDeltaAllocations;
    }

    public int getDeltaDeallocationCount() {
        return this.myDeltaDeallocations;
    }

    public long getTotalRetainedSize() {
        return this.myTotalRetainedSize;
    }

    public long getTotalShallowSize() {
        return this.myTotalShallowSize;
    }

    public long getTotalNativeSize() {
        return this.myTotalNativeSize;
    }

    public int getFilterMatchCount() {
        return this.myFilterMatchCount;
    }

    public void addSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(3);
        }
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            this.myClassifier.getClassifierSet(instanceObject, true).addSnapshotInstanceObject(instanceObject);
        } else {
            assert (!this.mySnapshotInstances.contains(instanceObject));
            this.mySnapshotInstances.add(instanceObject);
        }
        ++this.mySnapshotObjectCount;
        this.myTotalNativeSize += instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize();
        this.myTotalShallowSize += instanceObject.getShallowSize() == -1 ? 0L : (long)instanceObject.getShallowSize();
        this.myTotalRetainedSize += instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize();
        if (instanceObject.getCallStackDepth() > 0) {
            ++this.myInstancesWithStackInfoCount;
        }
        this.myNeedsRefiltering = true;
    }

    public void removeSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(4);
        }
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, false);
            assert (classifierSet != null);
            classifierSet.removeSnapshotInstanceObject(instanceObject);
        } else {
            assert (this.mySnapshotInstances.contains(instanceObject));
            this.mySnapshotInstances.remove(instanceObject);
        }
        --this.mySnapshotObjectCount;
        this.myTotalNativeSize -= instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize();
        this.myTotalShallowSize -= instanceObject.getShallowSize() == -1 ? 0L : (long)instanceObject.getShallowSize();
        this.myTotalRetainedSize -= instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize();
        if (instanceObject.getCallStackDepth() > 0) {
            --this.myInstancesWithStackInfoCount;
        }
        this.myNeedsRefiltering = true;
    }

    public boolean addDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(5);
        }
        return this.addDeltaInstanceInformation(instanceObject, true);
    }

    public boolean freeDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(6);
        }
        return this.addDeltaInstanceInformation(instanceObject, false);
    }

    public boolean removeAddedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(7);
        }
        return this.removeDeltaInstanceInformation(instanceObject, true);
    }

    public boolean removeFreedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(8);
        }
        return this.removeDeltaInstanceInformation(instanceObject, false);
    }

    private boolean addDeltaInstanceInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(9);
        }
        boolean instanceAdded = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            instanceAdded = this.myClassifier.getClassifierSet(instanceObject, true).addDeltaInstanceInformation(instanceObject, isAllocation);
        } else if (!this.myDeltaInstances.contains(instanceObject)) {
            instanceAdded = true;
            this.myDeltaInstances.add(instanceObject);
        }
        if (isAllocation) {
            ++this.myDeltaAllocations;
        } else {
            ++this.myDeltaDeallocations;
        }
        this.myTotalNativeSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceAdded && instanceObject.getCallStackDepth() > 0) {
            ++this.myInstancesWithStackInfoCount;
            this.myNeedsRefiltering = true;
        }
        return instanceAdded;
    }

    private boolean removeDeltaInstanceInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(10);
        }
        boolean instanceRemoved = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, false);
            assert (classifierSet != null);
            instanceRemoved = classifierSet.removeDeltaInstanceInformation(instanceObject, isAllocation);
        } else if (!instanceObject.hasTimeData() && this.myDeltaInstances.contains(instanceObject)) {
            this.myDeltaInstances.remove(instanceObject);
            instanceRemoved = true;
        }
        if (isAllocation) {
            --this.myDeltaAllocations;
        } else {
            --this.myDeltaDeallocations;
        }
        this.myTotalNativeSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize -= (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceRemoved && instanceObject.getCallStackDepth() > 0) {
            --this.myInstancesWithStackInfoCount;
            this.myNeedsRefiltering = true;
        }
        return instanceRemoved;
    }

    public void clearClassifierSets() {
        this.mySnapshotInstances.clear();
        this.myDeltaInstances.clear();
        this.myClassifier = this.createSubClassifier();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.myFilterMatchCount = 0;
    }

    public int getInstancesCount() {
        if (this.myClassifier == null) {
            HashSet<InstanceObject> total = new HashSet<InstanceObject>(this.mySnapshotInstances);
            total.addAll(this.myDeltaInstances);
            return total.size();
        }
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public Stream<InstanceObject> getInstancesStream() {
        Stream<InstanceObject> total = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).distinct();
        if (this.myClassifier == null) {
            Stream<InstanceObject> stream = total;
            if (stream == null) {
                ClassifierSet.$$$reportNull$$$0(11);
            }
            return stream;
        }
        Stream<InstanceObject> stream = Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(ClassifierSet::getInstancesStream), total);
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @NotNull
    protected Stream<InstanceObject> getDeltaInstanceStream() {
        if (this.myClassifier == null) {
            Stream<InstanceObject> stream = this.myDeltaInstances.stream();
            if (stream == null) {
                ClassifierSet.$$$reportNull$$$0(13);
            }
            return stream;
        }
        Stream<InstanceObject> stream = Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(ClassifierSet::getDeltaInstanceStream), this.myDeltaInstances.stream());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @NotNull
    protected Stream<InstanceObject> getSnapshotInstanceStream() {
        if (this.myClassifier == null) {
            Stream<InstanceObject> stream = this.mySnapshotInstances.stream();
            if (stream == null) {
                ClassifierSet.$$$reportNull$$$0(15);
            }
            return stream;
        }
        Stream<InstanceObject> stream = Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(ClassifierSet::getSnapshotInstanceStream), this.mySnapshotInstances.stream());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(16);
        }
        return stream;
    }

    public boolean hasStackInfo() {
        return this.myInstancesWithStackInfoCount > 0;
    }

    @NotNull
    public List<ClassifierSet> getChildrenClassifierSets() {
        this.ensurePartition();
        assert (this.myClassifier != null);
        List<ClassifierSet> list = this.myClassifier.getFilteredClassifierSets();
        if (list == null) {
            ClassifierSet.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    public ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        boolean instancesContainsTarget;
        if (target == null) {
            ClassifierSet.$$$reportNull$$$0(18);
        }
        if ((instancesContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).filter(instance -> target.equals(instance)).findAny().isPresent()) && this.myClassifier != null) {
            return this;
        }
        if (instancesContainsTarget || this.myClassifier != null) {
            List<ClassifierSet> childrenClassifierSets = this.getChildrenClassifierSets();
            boolean stillContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).filter(instance -> target.equals(instance)).findAny().isPresent();
            if (instancesContainsTarget && stillContainsTarget) {
                return this;
            }
            for (ClassifierSet set : childrenClassifierSets) {
                ClassifierSet result = set.findContainingClassifierSet(target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean isSupersetOf(@NotNull ClassifierSet targetSet) {
        if (targetSet == null) {
            ClassifierSet.$$$reportNull$$$0(19);
        }
        if (this.getInstancesCount() < targetSet.getInstancesCount()) {
            return false;
        }
        Set instances = this.getInstancesStream().collect(Collectors.toSet());
        return targetSet.getInstancesStream().allMatch(instances::contains);
    }

    protected void ensurePartition() {
        if (this.myClassifier == null) {
            this.myClassifier = this.createSubClassifier();
            this.myClassifier.partition(this.mySnapshotInstances, this.myDeltaInstances);
        }
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public boolean getIsFiltered() {
        return this.isEmpty() || this.myIsFiltered;
    }

    public boolean getIsMatched() {
        return this.myIsMatched;
    }

    protected void applyFilter(@NotNull Filter filter, boolean hasMatchedAncestor, boolean filterChanged) {
        if (filter == null) {
            ClassifierSet.$$$reportNull$$$0(20);
        }
        if (!filterChanged && !this.myNeedsRefiltering) {
            return;
        }
        this.myIsFiltered = true;
        this.ensurePartition();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = this.myClassifier.getAllClassifierSets().size();
        this.myFilteredObjectSetCount = 0;
        this.myIsMatched = this.matches(filter);
        int n = this.myFilterMatchCount = this.myIsMatched ? 1 : 0;
        assert (this.myClassifier != null);
        for (ClassifierSet classifierSet : this.myClassifier.getAllClassifierSets()) {
            classifierSet.applyFilter(filter, hasMatchedAncestor || this.myIsMatched, filterChanged);
            this.myObjectSetCount += classifierSet.myObjectSetCount;
            if (classifierSet.getIsFiltered()) continue;
            this.myIsFiltered = false;
            this.mySnapshotObjectCount += classifierSet.mySnapshotObjectCount;
            this.myDeltaAllocations += classifierSet.myDeltaAllocations;
            this.myDeltaDeallocations += classifierSet.myDeltaDeallocations;
            this.myTotalShallowSize += classifierSet.myTotalShallowSize;
            this.myTotalNativeSize += classifierSet.myTotalNativeSize;
            this.myTotalRetainedSize += classifierSet.myTotalRetainedSize;
            this.myInstancesWithStackInfoCount += classifierSet.myInstancesWithStackInfoCount;
            this.myFilterMatchCount += classifierSet.myFilterMatchCount;
            ++this.myFilteredObjectSetCount;
        }
        this.myNeedsRefiltering = false;
    }

    protected boolean matches(@NotNull Filter filter) {
        if (filter == null) {
            ClassifierSet.$$$reportNull$$$0(21);
        }
        return filter.matches(this.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSupplier";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassifierSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceObject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSet";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassifierSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstancesStream";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeltaInstanceStream";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshotInstanceStream";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenClassifierSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSnapshotInstanceObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSnapshotInstanceObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDeltaInstanceObject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "freeDeltaInstanceObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeAddedDeltaInstanceObject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeFreedDeltaInstanceObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDeltaInstanceInformation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeDeltaInstanceInformation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findContainingClassifierSet";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSupersetOf";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public static abstract class Classifier {
        public static final Classifier IDENTITY_CLASSIFIER = new Classifier(){

            @Override
            public boolean isTerminalClassifier() {
                return true;
            }

            @Override
            @NotNull
            public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
                if (instance == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public List<ClassifierSet> getFilteredClassifierSets() {
                List<ClassifierSet> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @NotNull
            protected List<ClassifierSet> getAllClassifierSets() {
                List<ClassifierSet> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instance";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassifierSet$Classifier$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassifierSet$Classifier$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilteredClassifierSets";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllClassifierSets";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getClassifierSet";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        public boolean isTerminalClassifier() {
            return false;
        }

        @Nullable
        public abstract ClassifierSet getClassifierSet(@NotNull InstanceObject var1, boolean var2);

        @NotNull
        public abstract List<ClassifierSet> getFilteredClassifierSets();

        @NotNull
        protected abstract List<ClassifierSet> getAllClassifierSets();

        public final void partition(@NotNull Collection<InstanceObject> snapshotInstances, @NotNull Collection<InstanceObject> deltaInstances) {
            if (snapshotInstances == null) {
                Classifier.$$$reportNull$$$0(0);
            }
            if (deltaInstances == null) {
                Classifier.$$$reportNull$$$0(1);
            }
            if (this.isTerminalClassifier()) {
                return;
            }
            snapshotInstances.forEach(instance -> this.getClassifierSet((InstanceObject)instance, true).addSnapshotInstanceObject((InstanceObject)instance));
            deltaInstances.forEach(instance -> {
                if (instance.hasTimeData()) {
                    if (instance.hasAllocTime() && !snapshotInstances.contains(instance)) {
                        this.getClassifierSet((InstanceObject)instance, true).addDeltaInstanceObject((InstanceObject)instance);
                    }
                    if (instance.hasDeallocTime()) {
                        this.getClassifierSet((InstanceObject)instance, true).freeDeltaInstanceObject((InstanceObject)instance);
                    }
                } else {
                    this.getClassifierSet((InstanceObject)instance, true).addDeltaInstanceObject((InstanceObject)instance);
                }
            });
            snapshotInstances.clear();
            deltaInstances.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "snapshotInstances";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deltaInstances";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/memory/adapters/ClassifierSet$Classifier";
            objectArray[2] = "partition";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

