/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class AllocationSamplingRateDataSeries
implements DataSeries<AllocationSamplingRateDurationData> {
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;
    private final boolean myNewPipeline;

    public AllocationSamplingRateDataSeries(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull boolean newPipeline) {
        if (client == null) {
            AllocationSamplingRateDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            AllocationSamplingRateDataSeries.$$$reportNull$$$0(1);
        }
        this.myClient = client;
        this.mySession = session;
        this.myNewPipeline = newPipeline;
    }

    public List<SeriesData<AllocationSamplingRateDurationData>> getDataForRange(Range range) {
        Common.Event currEvent;
        long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)range.getMin());
        long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)range.getMax());
        if (!this.myNewPipeline) {
            return this.getLegacyData(rangeMin, rangeMax);
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.MEMORY_ALLOC_SAMPLING).setFromTimestamp(rangeMin).setToTimestamp(rangeMax).build();
        Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(request);
        assert (response.getGroupsCount() <= 1);
        if (response.getGroupsCount() == 0) {
            return new ArrayList<SeriesData<AllocationSamplingRateDurationData>>();
        }
        Transport.EventGroup group = response.getGroups(0);
        ArrayList<SeriesData<AllocationSamplingRateDurationData>> seriesData = new ArrayList<SeriesData<AllocationSamplingRateDurationData>>();
        for (int i = 0; i < group.getEventsCount() && (currEvent = group.getEvents(i)).getTimestamp() <= rangeMax; ++i) {
            Common.Event nextEvent;
            Common.Event prevEvent = i == 0 ? null : group.getEvents(i - 1);
            Common.Event event = nextEvent = i == group.getEventsCount() - 1 ? null : group.getEvents(i + 1);
            if (nextEvent != null && nextEvent.getTimestamp() <= rangeMin) continue;
            long durationUs = nextEvent == null ? Long.MAX_VALUE : TimeUnit.NANOSECONDS.toMicros(nextEvent.getTimestamp() - currEvent.getTimestamp());
            seriesData.add((SeriesData<AllocationSamplingRateDurationData>)new SeriesData(TimeUnit.NANOSECONDS.toMicros(currEvent.getTimestamp()), (Object)new AllocationSamplingRateDurationData(durationUs, prevEvent != null ? prevEvent.getMemoryAllocSampling() : null, currEvent.getMemoryAllocSampling())));
        }
        return seriesData;
    }

    private List<SeriesData<AllocationSamplingRateDurationData>> getLegacyData(long rangeMinNs, long rangeMaxNs) {
        MemoryProfiler.AllocationSamplingRateEvent currEvent;
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(0L).setEndTime(Long.MAX_VALUE);
        List events = this.myClient.getMemoryClient().getJvmtiData(dataRequestBuilder.build()).getAllocSamplingRateEventsList();
        ArrayList<SeriesData<AllocationSamplingRateDurationData>> seriesData = new ArrayList<SeriesData<AllocationSamplingRateDurationData>>();
        MemoryProfiler.AllocationSamplingRateEvent prevEvent = null;
        for (int i = 0; i < events.size() && (currEvent = (MemoryProfiler.AllocationSamplingRateEvent)events.get(i)).getTimestamp() <= rangeMaxNs; ++i) {
            long durationUs;
            MemoryProfiler.AllocationSamplingRateEvent nextRateEvent = i == events.size() - 1 ? null : (MemoryProfiler.AllocationSamplingRateEvent)events.get(i + 1);
            long l = durationUs = nextRateEvent == null ? Long.MAX_VALUE : TimeUnit.NANOSECONDS.toMicros(nextRateEvent.getTimestamp() - currEvent.getTimestamp());
            if (nextRateEvent == null || nextRateEvent.getTimestamp() > rangeMinNs) {
                seriesData.add((SeriesData<AllocationSamplingRateDurationData>)new SeriesData(TimeUnit.NANOSECONDS.toMicros(currEvent.getTimestamp()), (Object)new AllocationSamplingRateDurationData(durationUs, prevEvent != null ? prevEvent.getSamplingRate() : null, currEvent.getSamplingRate())));
            }
            prevEvent = currEvent;
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/memory/AllocationSamplingRateDataSeries";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

