/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.event.UserEventTooltip;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserEventTooltipView
extends TooltipView {
    private static final int HOVER_OVER_WIDTH_PX = 16;
    @VisibleForTesting
    protected JLabel myStartTimeLabel;
    @VisibleForTesting
    protected JLabel myDurationLabel;
    @VisibleForTesting
    protected JLabel myContentLabel;
    private JComponent myComponent;
    @NotNull
    private final UserEventTooltip myTooltip;

    public UserEventTooltipView(JComponent parent, @NotNull UserEventTooltip tooltip) {
        if (tooltip == null) {
            UserEventTooltipView.$$$reportNull$$$0(0);
        }
        super(tooltip.getTimeline());
        this.myTooltip = tooltip;
        this.myComponent = parent;
        this.getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
    }

    public void dispose() {
        super.dispose();
        this.getTimeline().getDataRange().removeDependencies((AspectObserver)this);
    }

    protected void updateTooltip() {
        this.timeChanged();
    }

    private void timeChanged() {
        Range dataRange = this.getTimeline().getDataRange();
        Range range = this.getTimeline().getTooltipRange();
        if (!range.isEmpty()) {
            this.showSimpleEventInfo(this.getTimeline(), dataRange, range);
        }
    }

    private void clearTooltipInfo() {
        this.myContentLabel.setText("");
        this.myStartTimeLabel.setText("");
        this.myDurationLabel.setText("");
    }

    private void showSimpleEventInfo(Timeline timeline, Range dataRange, Range range) {
        EventAction event = this.getEventAt((long)range.getMin());
        if (event == null) {
            this.clearTooltipInfo();
            return;
        }
        double endTime = event.getEndUs() == 0L ? dataRange.getMax() : (double)event.getEndUs();
        this.setTimelineText(timeline.getDataRange(), event.getStartUs(), endTime);
        String label = "";
        if (event.getType() == UserEvent.KEYBOARD) {
            label = "Key Event - Press";
        } else if (event.getType() == UserEvent.TOUCH) {
            label = "Touch Event - Press";
        } else if (event.getType() == UserEvent.ROTATION) {
            label = "Rotation Event";
        }
        this.myContentLabel.setText(label);
    }

    private void setTimelineText(Range dataRange, double startTime, double endTime) {
        String startTimeString = TimeFormatter.getSemiSimplifiedClockString((long)((long)(startTime - dataRange.getMin())));
        String durationString = TimeFormatter.getSingleUnitDurationString((long)((long)(endTime - startTime)));
        this.myStartTimeLabel.setText(String.format("Start: %s", startTimeString));
        this.myDurationLabel.setText(String.format("Duration: %s", durationString));
    }

    @Nullable
    private EventAction getEventAt(double time) {
        double timePerPixel = this.getTimeline().getViewRange().getLength() / (double)this.myComponent.getWidth();
        long hoverWidthAsTime = (long)timePerPixel * 16L;
        List userEventSeries = this.myTooltip.getUserEvents().getRangedSeries().getSeries();
        for (SeriesData series : userEventSeries) {
            if (!(((EventAction)series.value).getEndUs() - ((EventAction)series.value).getStartUs() <= hoverWidthAsTime / 2L || ((EventAction)series.value).getType() == UserEvent.KEYBOARD ? (double)(((EventAction)series.value).getStartUs() - hoverWidthAsTime / 2L) <= time && (double)(((EventAction)series.value).getStartUs() + hoverWidthAsTime / 2L) >= time : (double)((EventAction)series.value).getStartUs() <= time && ((double)((EventAction)series.value).getEndUs() > time || ((EventAction)series.value).getEndUs() == 0L))) continue;
            return (EventAction)series.value;
        }
        return null;
    }

    @NotNull
    public JComponent createTooltip() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,5px,Fit-,5px,Fit-"));
        panel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myContentLabel = new JLabel();
        this.myContentLabel.setForeground(Color.GRAY);
        this.myContentLabel.setFont(this.myFont);
        this.myStartTimeLabel = new JLabel();
        this.myStartTimeLabel.setForeground(Color.GRAY);
        this.myStartTimeLabel.setFont(this.myFont);
        this.myDurationLabel = new JLabel();
        this.myDurationLabel.setForeground(Color.GRAY);
        this.myDurationLabel.setFont(this.myFont);
        panel.add((Component)this.myContentLabel, new TabularLayout.Constraint(0, 0));
        panel.add((Component)this.myDurationLabel, new TabularLayout.Constraint(2, 0));
        panel.add((Component)this.myStartTimeLabel, new TabularLayout.Constraint(4, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            UserEventTooltipView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/event/UserEventTooltipView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/event/UserEventTooltipView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

