/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

abstract class CapturePane
extends JPanel {
    private static final Map<CaptureDetails.Type, String> DEFAULT_TAB_NAMES = ImmutableMap.of((Object)((Object)CaptureDetails.Type.CALL_CHART), (Object)"Call Chart", (Object)((Object)CaptureDetails.Type.FLAME_CHART), (Object)"Flame Chart", (Object)((Object)CaptureDetails.Type.TOP_DOWN), (Object)"Top Down", (Object)((Object)CaptureDetails.Type.BOTTOM_UP), (Object)"Bottom Up");
    private static final Map<CaptureDetails.Type, String> ATRACE_TAB_NAMES = ImmutableMap.of((Object)((Object)CaptureDetails.Type.CALL_CHART), (Object)"Trace Events");
    private static final Map<CaptureDetails.Type, String> RENDER_AUDIT_TAB_NAMES = ImmutableMap.of((Object)((Object)CaptureDetails.Type.RENDER_AUDIT), (Object)"Render Audit");
    protected final Map<CaptureDetails.Type, String> myTabs;
    @NotNull
    protected final CpuProfilerStageView myStageView;
    @NotNull
    protected final CommonTabbedPane myTabsPanel;
    @NotNull
    private final JPanel myRecordingPanel;
    @NotNull
    protected final Toolbar myToolbar;

    protected CapturePane(@NotNull CpuProfilerStageView stageView) {
        if (stageView == null) {
            CapturePane.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new TabularLayout("*,Fit-", ProfilerLayout.TOOLBAR_HEIGHT - 1 + "px,*"));
        this.myTabs = new LinkedHashMap<CaptureDetails.Type, String>(DEFAULT_TAB_NAMES);
        this.myStageView = stageView;
        this.myTabsPanel = new CommonTabbedPane();
        this.myRecordingPanel = new JPanel(new BorderLayout());
        this.myToolbar = new Toolbar(stageView);
        if (((CpuProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
            this.add((Component)this.myRecordingPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        } else {
            CpuCapture capture = ((CpuProfilerStage)this.myStageView.getStage()).getCapture();
            if (capture != null && capture.getType() == Cpu.CpuTraceType.ATRACE) {
                this.myTabs.putAll(ATRACE_TAB_NAMES);
                if (((CpuProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isAuditsEnabled()) {
                    this.myTabs.putAll(RENDER_AUDIT_TAB_NAMES);
                }
            }
            for (String label : this.myTabs.values()) {
                this.myTabsPanel.addTab(label, (Component)new JPanel(new BorderLayout()));
            }
            this.myTabsPanel.setSelectedIndex(0);
            this.add((Component)this.myToolbar, new TabularLayout.Constraint(0, 1));
            this.add((Component)this.myTabsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        }
    }

    final void updateView() {
        if (((CpuProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
            this.myRecordingPanel.removeAll();
            this.populateContent(this.myRecordingPanel);
            return;
        }
        for (Component tab : this.myTabsPanel.getComponents()) {
            assert (tab instanceof JPanel);
            ((JPanel)tab).removeAll();
        }
        CaptureDetails details = ((CpuProfilerStage)this.myStageView.getStage()).getCaptureDetails();
        if (details != null) {
            String tabTitle = this.myTabs.get((Object)details.getType());
            int currentTabIndex = this.myTabsPanel.getSelectedIndex();
            if (currentTabIndex < 0 || !this.myTabsPanel.getTitleAt(currentTabIndex).equals(tabTitle)) {
                for (int i = 0; i < this.myTabsPanel.getTabCount(); ++i) {
                    if (!this.myTabsPanel.getTitleAt(i).equals(tabTitle)) continue;
                    this.myTabsPanel.setSelectedIndex(i);
                    break;
                }
            }
        }
        assert (this.myTabsPanel.getSelectedIndex() != -1);
        JPanel selectedTab = (JPanel)this.myTabsPanel.getSelectedComponent();
        this.populateContent(selectedTab);
        selectedTab.revalidate();
    }

    abstract void populateContent(@NotNull JPanel var1);

    void disableInteraction() {
        this.myTabsPanel.setEnabled(false);
        this.myToolbar.setEnabled(false);
        this.myRecordingPanel.setEnabled(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stageView", "com/android/tools/profilers/cpu/capturedetails/CapturePane", "<init>"));
    }

    static class Toolbar
    extends JPanel {
        @NotNull
        private final CommonToggleButton myFilterButton;
        @NotNull
        private final JComboBox<ClockType> myClockType = new ComboBox();

        Toolbar(CpuProfilerStageView stageView) {
            super(ProfilerLayout.createToolbarLayout());
            JComboBoxView<ClockType, CpuProfilerAspect> clockTypes = new JComboBoxView<ClockType, CpuProfilerAspect>(this.myClockType, ((CpuProfilerStage)stageView.getStage()).getAspect(), CpuProfilerAspect.CLOCK_TYPE, ((CpuProfilerStage)stageView.getStage())::getClockTypes, ((CpuProfilerStage)stageView.getStage())::getClockType, ((CpuProfilerStage)stageView.getStage())::setClockType);
            clockTypes.bind();
            this.myClockType.setRenderer((ListCellRenderer<ClockType>)SimpleListCellRenderer.create((String)"", value -> value == ClockType.GLOBAL ? "Wall Clock Time" : (value == ClockType.THREAD ? "Thread Time" : "")));
            CpuCapture capture = ((CpuProfilerStage)stageView.getStage()).getCapture();
            this.myClockType.setEnabled(capture != null && capture.isDualClock());
            this.add(this.myClockType);
            this.add(stageView.getSelectionTimeLabel());
            this.myFilterButton = FilterComponent.createFilterToggleButton();
            this.add((Component)new FlatSeparator());
            this.add((Component)this.myFilterButton);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.myFilterButton.setEnabled(enabled);
            this.myClockType.setEnabled(enabled);
        }

        @NotNull
        CommonToggleButton getFilterButton() {
            CommonToggleButton commonToggleButton = this.myFilterButton;
            if (commonToggleButton == null) {
                Toolbar.$$$reportNull$$$0(0);
            }
            return commonToggleButton;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/cpu/capturedetails/CapturePane$Toolbar", "getFilterButton"));
        }
    }
}

