/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerfettoPacketDBSorter
implements Iterator<String> {
    private Connection myConnection;
    private PreparedStatement myInsertStmt;
    private ResultSet myQueryResults;
    private boolean myLastResult = false;
    private boolean myReturnedCurrentResults = true;

    private static Logger getLogger() {
        return Logger.getInstance(PerfettoPacketDBSorter.class);
    }

    public PerfettoPacketDBSorter() {
        try {
            File dbFile = FileUtil.createTempFile((String)"perfetto", (String)".db", (boolean)true);
            this.myConnection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", dbFile.getPath()));
            this.myConnection.setAutoCommit(false);
            try (Statement stmt = this.myConnection.createStatement();){
                stmt.execute("CREATE TABLE Events (Timestamp INTEGER, Line TEXT);");
            }
            this.myInsertStmt = this.myConnection.prepareStatement("INSERT INTO Events (Timestamp, Line) VALUES (?, ?)");
        }
        catch (IOException | SQLException e) {
            PerfettoPacketDBSorter.getLogger().error((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addLine(long timestamp, @NotNull String string) {
        if (string == null) {
            PerfettoPacketDBSorter.$$$reportNull$$$0(0);
        }
        try {
            void line;
            if (this.myConnection.isClosed()) {
                return;
            }
            this.myInsertStmt.setLong(1, timestamp);
            this.myInsertStmt.setString(2, (String)line);
            this.myInsertStmt.execute();
        }
        catch (SQLException ex) {
            PerfettoPacketDBSorter.getLogger().warn((Throwable)ex);
        }
    }

    public void resetForIterator() {
        try {
            this.myQueryResults = this.myConnection.createStatement().executeQuery("SELECT Line FROM Events ORDER BY Timestamp asc");
        }
        catch (SQLException ex) {
            PerfettoPacketDBSorter.getLogger().error((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.myQueryResults.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.myQueryResults = null;
        }
        try {
            this.myInsertStmt.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.myInsertStmt = null;
        }
        try {
            this.myConnection.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.myConnection = null;
        }
        this.myLastResult = false;
        this.myReturnedCurrentResults = true;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.myReturnedCurrentResults && this.myQueryResults != null) {
                this.myLastResult = this.myQueryResults.next();
                this.myReturnedCurrentResults = false;
            }
            return this.myLastResult;
        }
        catch (SQLException ex) {
            PerfettoPacketDBSorter.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    @Nullable
    public String next() {
        try {
            this.myReturnedCurrentResults = true;
            return this.myQueryResults.getString(1);
        }
        catch (Exception ex) {
            PerfettoPacketDBSorter.getLogger().error((Throwable)ex);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/profilers/cpu/atrace/PerfettoPacketDBSorter", "addLine"));
    }
}

