/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuKernelTooltip
extends AspectModel<Aspect>
implements TooltipModel {
    @NotNull
    private final Timeline myTimeline;
    @Nullable
    private DataSeries<CpuThreadSliceInfo> mySeries;
    @Nullable
    private CpuThreadSliceInfo myCpuThreadSliceInfo;
    private int myCpuId;
    private final int myProcessId;

    public CpuKernelTooltip(@NotNull Timeline timeline, int pid) {
        if (timeline == null) {
            CpuKernelTooltip.$$$reportNull$$$0(0);
        }
        this.myTimeline = timeline;
        this.myProcessId = pid;
        timeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateState);
    }

    public void dispose() {
        this.myTimeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private void updateState() {
        this.myCpuThreadSliceInfo = null;
        if (this.mySeries == null) {
            this.changed(Aspect.CPU_KERNEL_THREAD_SLICE_INFO);
            return;
        }
        Range tooltipRange = this.myTimeline.getTooltipRange();
        List series = this.mySeries.getDataForRange(tooltipRange);
        CpuThreadSliceInfo cpuThreadSliceInfo = this.myCpuThreadSliceInfo = series.isEmpty() ? null : (CpuThreadSliceInfo)((SeriesData)series.get((int)0)).value;
        if (this.myCpuThreadSliceInfo == CpuThreadSliceInfo.NULL_THREAD) {
            this.myCpuThreadSliceInfo = null;
        }
        this.changed(Aspect.CPU_KERNEL_THREAD_SLICE_INFO);
    }

    public void setCpuSeries(int cpuId, @Nullable DataSeries<CpuThreadSliceInfo> stateSeries) {
        this.mySeries = stateSeries;
        this.myCpuId = cpuId;
        this.updateState();
    }

    @Nullable
    public CpuThreadSliceInfo getCpuThreadSliceInfo() {
        return this.myCpuThreadSliceInfo;
    }

    public int getCpuId() {
        return this.myCpuId;
    }

    public int getProcessId() {
        return this.myProcessId;
    }

    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.myTimeline;
        if (timeline == null) {
            CpuKernelTooltip.$$$reportNull$$$0(1);
        }
        return timeline;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/atrace/CpuKernelTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/atrace/CpuKernelTooltip";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        CPU_KERNEL_THREAD_SLICE_INFO;

    }
}

