/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.event.EventAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.base.SliceGroup;

public class AtraceFrame
extends EventAction<PerfClass>
implements DurationData {
    private static final double SECONDS_TO_US = TimeUnit.SECONDS.toMicros(1L);
    public static final AtraceFrame EMPTY = new AtraceFrame(0, t -> 0L, 0L, FrameThread.OTHER);
    private static final String APP_MAIN_THREAD_FRAME_ID_MPLUS = "Choreographer#doFrame";
    private static final String APP_RENDER_THREAD_FRAME_ID_MPLUS = "(DrawFrame|doFrame|queueBuffer)";
    private AtraceFrame myAssociatedFrame;
    @NotNull
    private final Range myTotalRangeSeconds;
    @NotNull
    private final Function<Double, Long> myBootClockSecondsToMonoUs;
    private double myCpuTimeSeconds;
    private final long myLongFrameTimeUs;
    @NotNull
    private PerfClass myPerfClass;
    private final int myThreadId;
    private final FrameThread myThread;
    private final List<SliceGroup> mySlices;

    /*
     * WARNING - void declaration
     */
    public AtraceFrame(int threadId, @NotNull Function<Double, Long> bootClockSecondsToMonoUs, long longFrameTimeUs, FrameThread frameThread) {
        void thread2;
        if (bootClockSecondsToMonoUs == null) {
            AtraceFrame.$$$reportNull$$$0(0);
        }
        super(0L, 0L, (Object)PerfClass.NOT_SET);
        this.myTotalRangeSeconds = new Range();
        this.myBootClockSecondsToMonoUs = bootClockSecondsToMonoUs;
        this.myLongFrameTimeUs = longFrameTimeUs;
        this.myThreadId = threadId;
        this.myPerfClass = PerfClass.NOT_SET;
        this.myThread = thread2;
        this.mySlices = new ArrayList<SliceGroup>();
    }

    public FrameThread getThread() {
        return this.myThread;
    }

    public void setAssociatedFrame(AtraceFrame associatedFrame) {
        this.myAssociatedFrame = associatedFrame;
    }

    public AtraceFrame getAssociatedFrame() {
        return this.myAssociatedFrame;
    }

    @NotNull
    public PerfClass getPerfClass() {
        PerfClass perfClass = this.myPerfClass;
        if (perfClass == null) {
            AtraceFrame.$$$reportNull$$$0(1);
        }
        return perfClass;
    }

    public PerfClass getTotalPerfClass() {
        double associatedFrameLength;
        if (this.myPerfClass == PerfClass.NOT_SET) {
            return PerfClass.NOT_SET;
        }
        double d = associatedFrameLength = this.myAssociatedFrame == null ? 0.0 : this.myAssociatedFrame.getTotalRangeSeconds().getLength();
        if (SECONDS_TO_US * (associatedFrameLength + this.myTotalRangeSeconds.getLength()) > (double)this.myLongFrameTimeUs) {
            return PerfClass.BAD;
        }
        return PerfClass.GOOD;
    }

    public long getDurationUs() {
        return (long)(SECONDS_TO_US * this.getTotalRangeSeconds().getLength());
    }

    public long getStartUs() {
        return this.myBootClockSecondsToMonoUs.apply(this.myTotalRangeSeconds.getMin());
    }

    public long getEndUs() {
        return this.myBootClockSecondsToMonoUs.apply(this.myTotalRangeSeconds.getMax());
    }

    public double getCpuTimeSeconds() {
        return this.myCpuTimeSeconds;
    }

    @NotNull
    public PerfClass getType() {
        PerfClass perfClass = this.getPerfClass();
        if (perfClass == null) {
            AtraceFrame.$$$reportNull$$$0(2);
        }
        return perfClass;
    }

    @NotNull
    public Range getTotalRangeSeconds() {
        Range range = this.myTotalRangeSeconds;
        if (range == null) {
            AtraceFrame.$$$reportNull$$$0(3);
        }
        return range;
    }

    public int getThreadId() {
        return this.myThreadId;
    }

    public void addSlice(@NotNull SliceGroup sliceGroup, @NotNull Range range) {
        if (sliceGroup == null) {
            AtraceFrame.$$$reportNull$$$0(4);
        }
        if (range == null) {
            AtraceFrame.$$$reportNull$$$0(5);
        }
        this.mySlices.add(sliceGroup);
        this.myTotalRangeSeconds.setMin(Math.min(this.myTotalRangeSeconds.getMin(), range.getMin()));
        this.myTotalRangeSeconds.setMax(Math.max(this.myTotalRangeSeconds.getMax(), range.getMax()));
        this.myCpuTimeSeconds += sliceGroup.getCpuTime();
        this.myPerfClass = SECONDS_TO_US * this.myTotalRangeSeconds.getLength() > (double)this.myLongFrameTimeUs ? PerfClass.BAD : PerfClass.GOOD;
    }

    public List<SliceGroup> getSlices() {
        return this.mySlices;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootClockSecondsToMonoUs";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sliceGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerfClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalRangeSeconds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSlice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FrameThread {
        MAIN("Choreographer#doFrame"),
        RENDER("(DrawFrame|doFrame|queueBuffer)"),
        OTHER("");

        private final String myIdentifierRegEx;

        public String getIdentifierRegEx() {
            return this.myIdentifierRegEx;
        }

        private FrameThread(String identifierRegEx) {
            this.myIdentifierRegEx = identifierRegEx;
        }
    }

    public static enum PerfClass {
        NOT_SET,
        GOOD,
        BAD;

    }
}

